package org.dfood.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class PotionBlockEntity extends class_2586 {
    private class_6880<class_1842> potion;

    public PotionBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public PotionBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntityTypes.POTION_BLOCK_ENTITY, pos, state);
    }

    public void readCustomDataFromItem(class_1844 potionContents) {
        Optional<class_6880<class_1842>> potion = potionContents.comp_2378();
        potion.ifPresent(potionRegistryEntry -> this.potion = potionRegistryEntry);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        String potionId = nbt.method_10558("Potion");
        if (!potionId.isEmpty()) {
            this.potion = byId(potionId);
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (potion != null) {
            nbt.method_10582("Potion", Objects.requireNonNull(class_7923.field_41179.method_10221(potion.comp_349())).toString());
        }
    }

    public class_6880<class_1842> byId(String potionId) {
        return class_6880.method_40223(class_7923.field_41179.method_10223(class_2960.method_12829(potionId)));
    }

    @Override
    protected void method_57567(class_9323.class_9324 builder) {
        if (potion != null) {
            builder.method_57840(class_9334.field_49651, new class_1844(potion));
        }
    }

    public class_6880<class_1842> getPotion() {
        return potion;
    }

    public class_1844 getPotionContents() {
        return potion != null ? new class_1844(this.getPotion()) : new class_1844(class_1847.field_8991);
    }

    public int getColor() {
        return potion != null
                ? this.getPotionContents().method_8064()
                : 16253176;
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 nbt = new class_2487();
        if (potion != null) {
            nbt.method_10582("Potion", Objects.requireNonNull(class_7923.field_41179.method_10221(potion.comp_349())).toString());
        }
        return nbt;
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public class_1799 getPotionStack() {
        class_1799 stack = new class_1799(class_1802.field_8574);
        if (potion != null) {
            stack.method_57379(class_9334.field_49651, new class_1844(potion));
        }
        return stack;
    }
}