package org.dfood.block.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9298;
import net.minecraft.class_9334;

public class SuspiciousStewBlockEntity extends class_2586 {
    protected final Map<class_2960, Integer> EffectMap = new HashMap<>();

    public SuspiciousStewBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SuspiciousStewBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntityTypes.SUSPICIOUS_STEW_BLOCK_ENTITY, pos, state);
    }

    private void readEffectsFromComponent(class_9298 component) {
        EffectMap.clear();

        // 如果组件存在且包含效果，则处理每个效果
        if (component != null && component.comp_2416() != null) {
            for (class_9298.class_8751 stewEffect : component.comp_2416()) {
                // 获取效果的注册表ID作为键
                class_6880<class_1291> effectEntry = stewEffect.comp_1838();
                if (effectEntry.method_40230().isPresent()) {
                    class_2960 effectId = effectEntry.method_40230().get().method_29177();
                    int duration = stewEffect.comp_1839();
                    EffectMap.put(effectId, duration);
                }
            }
        }
    }

    public void readCustomDataFromItem(class_9298 component) {
        readEffectsFromComponent(component);
        this.method_5431();
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);

        EffectMap.clear();

        // 从NBT读取效果数据
        if (nbt.method_10573("Effects", class_2520.field_33259)) {
            class_2499 effectsList = nbt.method_10554("Effects", class_2520.field_33260);

            for (int i = 0; i < effectsList.size(); i++) {
                class_2487 effectTag = effectsList.method_10602(i);
                if (effectTag.method_10573("EffectId", class_2520.field_33258) &&
                        effectTag.method_10573("EffectDuration", class_2520.field_33253)) {

                    class_2960 effectId = class_2960.method_12829(effectTag.method_10558("EffectId"));
                    int duration = effectTag.method_10550("EffectDuration");

                    if (effectId != null) {
                        EffectMap.put(effectId, duration);
                    }
                }
            }
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);

        // 将效果数据写入NBT
        if (!EffectMap.isEmpty()) {
            class_2499 effectsList = new class_2499();

            for (Map.Entry<class_2960, Integer> entry : EffectMap.entrySet()) {
                class_2487 effectTag = new class_2487();
                effectTag.method_10582("EffectId", entry.getKey().toString());
                effectTag.method_10569("EffectDuration", entry.getValue());
                effectsList.add(effectTag);
            }

            nbt.method_10566("Effects", effectsList);
        }
    }

    public class_9298 createStewEffectsComponent() {
        if (EffectMap.isEmpty()) {
            return class_9298.field_49362;
        }

        // 将EffectMap转换为StewEffect列表
        var effects = EffectMap.entrySet().stream()
                .map(entry -> {
                    // 通过注册表查找StatusEffect
                    class_6880<class_1291> effectEntry = getRegistryEntry(entry.getKey());
                    return new class_9298.class_8751(
                            effectEntry,
                            entry.getValue()
                    );
                })
                .toList();

        return new class_9298(effects);
    }

    private class_6880<class_1291> getRegistryEntry(class_2960 effectId) {
        return class_7923.field_41174.method_47983(class_7923.field_41174.method_10223(effectId));
    }

    public class_1799 getStewStack() {
        class_1799 stack = new class_1799(class_1802.field_8766);

        // 设置组件
        class_9298 component = createStewEffectsComponent();
        if (component != class_9298.field_49362) {
            stack.method_57379(class_9334.field_49652, component);
        }

        return stack;
    }

    public Map<class_2960, Integer> getEffectMap() {
        return new HashMap<>(EffectMap);
    }

    public void addEffect(class_2960 effectId, int duration) {
        EffectMap.put(effectId, duration);
        this.method_5431();
    }

    public void clearEffects() {
        EffectMap.clear();
        this.method_5431();
    }
}