package org.dfood.item;

import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_7699;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import net.minecraft.server.MinecraftServer;
import org.dfood.util.DFoodUtils;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;

public class ModBucketItem extends class_1755 implements HaveBlock {
    private final class_2248 block;

    public ModBucketItem(class_3611 fluid, class_1793 settings, class_2248 block) {
        super(fluid, settings);
        this.block = block;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1792 item = context.method_8041().method_7909();
        // 仅当父类方法失败时才尝试放置方块
        if (super.method_7884(context) != class_1269.field_5811 || (player != null && !player.method_5715() && DFoodUtils.isModFoodItem(item))){
            return class_1269.field_5811;
        }
        class_1269 actionResult = this.place(new class_1750(context));
        if (!actionResult.method_23665() && context.method_8041().method_57826(class_9334.field_50075)) {
            class_1269 actionResult2 = super.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467();
            return actionResult2 == class_1269.field_21466 ? class_1269.field_33562 : actionResult2;
        } else {
            return actionResult;
        }
    }

    public class_1269 place(class_1750 context) {
        if (!this.getBlock().method_45382(context.method_8045().method_45162())) {
            return class_1269.field_5814;
        } else if (!context.method_7716()) {
            return class_1269.field_5814;
        } else {
            class_1750 itemPlacementContext = this.getPlacementContext(context);
            if (itemPlacementContext == null) {
                return class_1269.field_5814;
            } else {
                class_2680 blockState = this.getPlacementState(itemPlacementContext);
                if (blockState == null) {
                    return class_1269.field_5814;
                } else if (!this.place(itemPlacementContext, blockState)) {
                    return class_1269.field_5814;
                } else {
                    class_2338 blockPos = itemPlacementContext.method_8037();
                    class_1937 world = itemPlacementContext.method_8045();
                    class_1657 playerEntity = itemPlacementContext.method_8036();
                    class_1799 itemStack = itemPlacementContext.method_8041();
                    class_2680 blockState2 = world.method_8320(blockPos);
                    if (blockState2.method_27852(blockState.method_26204())) {
                        blockState2 = this.placeFromNbt(blockPos, world, itemStack, blockState2);
                        this.postPlacement(blockPos, world, playerEntity, itemStack, blockState2);
                        copyComponentsToBlockEntity(world, blockPos, itemStack);
                        blockState2.method_26204().method_9567(world, blockPos, blockState2, playerEntity, itemStack);
                        if (playerEntity instanceof class_3222) {
                            class_174.field_1191.method_23889((class_3222)playerEntity, blockPos, itemStack);
                        }
                    }

                    class_2498 blockSoundGroup = blockState2.method_26231();
                    world.method_8396(
                            playerEntity,
                            blockPos,
                            this.getPlaceSound(blockState2),
                            class_3419.field_15245,
                            (blockSoundGroup.method_10597() + 1.0F) / 2.0F,
                            blockSoundGroup.method_10599() * 0.8F
                    );
                    world.method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286(playerEntity, blockState2));
                    itemStack.method_57008(1, playerEntity);
                    return class_1269.method_29236(world.field_9236);
                }
            }
        }
    }

    protected class_3414 getPlaceSound(class_2680 state) {
        return state.method_26231().method_10598();
    }

    @Nullable
    public class_1750 getPlacementContext(class_1750 context) {
        return context;
    }

    private static void copyComponentsToBlockEntity(class_1937 world, class_2338 pos, class_1799 stack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            blockEntity.method_58683(stack);
            blockEntity.method_5431();
        }
    }

    protected boolean postPlacement(class_2338 pos, class_1937 world, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        return writeNbtToBlockEntity(world, player, pos, stack);
    }

    @Nullable
    protected class_2680 getPlacementState(class_1750 context) {
        class_2680 blockState = this.getBlock().method_9605(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    private class_2680 placeFromNbt(class_2338 pos, class_1937 world, class_1799 stack, class_2680 state) {
        class_9275 blockStateComponent = stack.method_57825(class_9334.field_49623, class_9275.field_49284);
        if (blockStateComponent.method_57414()) {
            return state;
        } else {
            class_2680 blockState = blockStateComponent.method_57415(state);
            if (blockState != state) {
                world.method_8652(pos, blockState, class_2248.field_31028);
            }

            return blockState;
        }
    }

    protected boolean canPlace(class_1750 context, class_2680 state) {
        class_1657 playerEntity = context.method_8036();
        class_3726 shapeContext = playerEntity == null ? class_3726.method_16194() : class_3726.method_16195(playerEntity);
        return (!this.checkStatePlacement() || state.method_26184(context.method_8045(), context.method_8037()))
                && context.method_8045().method_8628(state, context.method_8037(), shapeContext);
    }

    protected boolean checkStatePlacement() {
        return true;
    }

    protected boolean place(class_1750 context, class_2680 state) {
        return context.method_8045().method_8652(context.method_8037(), state, class_2248.field_31022);
    }

    public static boolean writeNbtToBlockEntity(class_1937 world, @Nullable class_1657 player, class_2338 pos, class_1799 stack) {
        MinecraftServer minecraftServer = world.method_8503();
        if (minecraftServer != null) {
            class_9279 nbtComponent = stack.method_57825(class_9334.field_49611, class_9279.field_49302);
            if (!nbtComponent.method_57458()) {
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity != null) {
                    if (world.field_9236 || !blockEntity.method_11011() || player != null && player.method_7338()) {
                        return nbtComponent.method_57449(blockEntity, world.method_30349());
                    }

                    return false;
                }
            }

        }
        return false;
    }

    @Override
    public String method_7876() {
        return this.getBlock().method_9539();
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        this.getBlock().method_9568(stack, context, tooltip, type);
    }

    @Override
    public class_2248 getBlock() {
        return this.block;
    }

    public void appendBlocks(Map<class_2248, class_1792> map, class_1792 item) {
        map.put(this.getBlock(), item);
    }

    @Override
    public boolean method_31568() {
        return !(this.getBlock() instanceof class_2480);
    }

    @Override
    public void method_33261(class_1542 entity) {
        class_9288 containerComponent = entity.method_6983().method_57379(class_9334.field_49622, class_9288.field_49334);
        if (containerComponent != null) {
            class_5328.method_33263(entity, containerComponent.method_59715());
        }
    }

    @Override
    public class_7699 method_45322() {
        return this.getBlock().method_45322();
    }
}
