package org.dfood.mixin;

import net.minecraft.block.*;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.dfood.block.FoodBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2246.class)
public class BlocksMixin {

    @Inject(method = "<clinit>", at = @At("HEAD"), remap = false)
    private static void registerFoodBlocks(CallbackInfo ci) {
        // 遍历映射表中的所有方块并进行注册
        FoodBlocks.FOOD_BLOCK_REGISTRY.forEach(BlocksMixin::register);
    }

    @Unique
    private static void register(String id, class_2248 block) {
        class_2378.method_10230(class_7923.field_41175, class_2960.method_60654(id), block);
    }
}
