package org.dfood.mixin;

import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.dfood.block.FoodBlocks;
import org.dfood.item.HaveBlock;
import org.dfood.util.StewToBlocks;
import org.dfood.util.foodToBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1802.class)
public abstract class foodToBlockMixin {

    /**
     *该Mixin类通过掉换注册方法的Item实例来实现将食物物品转换为对应的方块。
     * 原本的Item实例被更改了标识符变为了被遗弃的物品
     */
    @ModifyVariable(method = "register(Ljava/lang/String;Lnet/minecraft/item/Item;)Lnet/minecraft/item/Item;", at = @At("HEAD"), argsOnly = true)
    private static class_1792 modifyItem(class_1792 item, String value) {
        if (foodToBlocks.foodMap.containsKey(value)) {
            register(item, value);
            return foodToBlocks.foodMap.get(value);
        } else if(foodToBlocks.other.contains(value)){
            register(item, value);
            return StewToBlocks.stewMap.get(value);
        } else if (value.equals("bowl")) {
            register(item, value);
            return new class_1747(FoodBlocks.BOWL, new class_1792.class_1793());
        } else {
            return item;
        }
    }

    @Inject(method = "register(Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/item/Item;)Lnet/minecraft/item/Item;", at = @At("HEAD"))
    private static void modifyBlockItem(class_5321<class_1792> key, class_1792 item, CallbackInfoReturnable<class_1792> cir){
        if (item instanceof HaveBlock haveBlock) {
            haveBlock.appendBlocks(class_1792.field_8003, item);
        }
    }

    @Unique
    private static void register(class_1792 item, String value){
        class_2378.method_10230(class_7923.field_41178, class_2960.method_60656(value + "_de"), item);
    }
}
