package org.dfood.util;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_4174;

/**
 * 包含模组中非炖菜类食物的食物组件定义
 */
public class ModFoodComponents {
    // 零食类
    public static final class_4174 COOKIE = createFood(2, 0.1F);
    public static final class_4174 APPLE = createFood(4, 0.3F);
    public static final class_4174 MELON_SLICE = createFood(2, 0.3F);
    public static final class_4174 BREAD = createFood(5, 0.6F);

    // 蔬菜类
    public static final class_4174 BEETROOT = createFood(1, 0.6F);
    public static final class_4174 POTATO = createFood(1, 0.3F);
    public static final class_4174 BAKED_POTATO = createFood(5, 0.6F);
    public static final class_4174 CARROT = createFood(3, 0.6F);
    public static final class_4174 SWEET_BERRIES = createFood(2, 0.1F);
    public static final class_4174 GLOW_BERRIES = createFood(2, 0.1F);

    // 金制食物
    public static final class_4174 GOLDEN_APPLE = new class_4174.class_4175()
            .method_19238(4)
            .method_19237(1.2F)
            .method_19239(new class_1293(class_1294.field_5924, 100, 1), 1.0F)
            .method_19239(new class_1293(class_1294.field_5898, 2400, 0), 1.0F)
            .method_19240()
            .method_19242();
    public static final class_4174 GOLDEN_CARROT = new class_4174.class_4175().method_19238(6).method_19237(1.2F).method_19242();

    // 生熟肉类
    public static final class_4174 CHICKEN = createFoodWithEffect(
            2, 0.3F,
            new class_1293(class_1294.field_5903, 600, 0),
            0.3F
    );
    public static final class_4174 COOKED_CHICKEN = createFood(6, 0.6F);
    public static final class_4174 BEEF = createFood(3, 0.3F);
    public static final class_4174 COOKED_BEEF = createFood(8, 0.8F);
    public static final class_4174 MUTTON = createFood(2, 0.3F);
    public static final class_4174 COOKED_MUTTON = createFood(6, 0.8F);
    public static final class_4174 PORKCHOP = createFood(3, 0.3F);
    public static final class_4174 COOKED_PORKCHOP = createFood(8, 0.8F);
    public static final class_4174 RABBIT = createFood(3, 0.3F);
    public static final class_4174 COOKED_RABBIT = createFood(5, 0.6F);

    // 鱼类
    public static final class_4174 COD = createFood(2, 0.1F);
    public static final class_4174 COOKED_COD = createFood(5, 0.6F);
    public static final class_4174 SALMON = createFood(2, 0.1F);
    public static final class_4174 COOKED_SALMON = createFood(6, 0.8F);
    public static final class_4174 PUFFERFISH = createFoodWithEffects(
            1, 0.1F,
            new class_1293(class_1294.field_5899, 1200, 1),
            new class_1293(class_1294.field_5903, 300, 2),
            new class_1293(class_1294.field_5916, 300, 0)
    );

    // 其他非炖菜类
    public static final class_4174 PUMPKIN_PIE = createFood(8, 0.3F);
    public static final class_4174 CHORUS_FRUIT = createAlwaysEdibleFood(4, 0.3F);
    public static final class_4174 POISONOUS_POTATO = createFoodWithEffect(
            2, 0.3F,
            new class_1293(class_1294.field_5899, 100, 0),
            0.6F
    );

    // 创建基本食物组件
    private static class_4174 createFood(int nutrition, float saturationModifier) {
        return new class_4174.class_4175()
                .method_19238(nutrition)
                .method_19237(saturationModifier)
                .method_19242();
    }
    private static class_4174 createAlwaysEdibleFood(int nutrition, float saturationModifier){
        return new class_4174.class_4175()
                .method_19238(nutrition)
                .method_19237(saturationModifier)
                .method_19240()
                .method_19242();
    }

    // 创建带状态效果的食物组件
    private static class_4174 createFoodWithEffect(int nutrition, float saturationModifier,
                                                      class_1293 effect, float probability) {
        return new class_4174.class_4175()
                .method_19238(nutrition)
                .method_19237(saturationModifier)
                .method_19239(effect, probability)
                .method_19242();
    }

    // 创建带多个状态效果的食物组件
    private static class_4174 createFoodWithEffects(int nutrition, float saturationModifier,
                                                       class_1293... effects) {
        class_4174.class_4175 builder = new class_4174.class_4175()
                .method_19238(nutrition)
                .method_19237(saturationModifier);

        for (class_1293 effect : effects) {
            builder.method_19239(effect, 1.0F);
        }

        return builder.method_19242();
    }
}