/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.dfood.shape.FoodShapeHandle;
import org.dfood.tag.ModTags;
import org.dfood.util.DFoodUtils;
import org.dfood.util.IntPropertyManager;
import org.jetbrains.annotations.Nullable;

public class FoodBlock
extends class_2248 {
    public static final Set<FoodBlock> FOOD_BLOCKS = new HashSet<FoodBlock>();
    public static final class_2753 FACING = class_2741.field_12481;
    protected static final FoodShapeHandle SHAPE_HANDLE = FoodShapeHandle.getInstance();
    public final class_2758 NUMBER_OF_FOOD;
    public final int MAX_FOOD;
    @Nullable
    private EnforceAsItem cItem;
    private onUseHook onUseHook = (state, world, pos, player, hit) -> class_1269.field_5811;

    public onUseHook getOnUseHook() {
        return this.onUseHook;
    }

    public void setOnUseHook(onUseHook onUseHook2) {
        this.onUseHook = onUseHook2;
    }

    public FoodBlock(class_4970.class_2251 settings, int max_food, boolean isFood) {
        super(settings);
        this.MAX_FOOD = max_food;
        this.NUMBER_OF_FOOD = IntPropertyManager.create("number_of_food", this.MAX_FOOD);
        if (isFood) {
            FOOD_BLOCKS.add(this);
        }
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(1)));
    }

    public FoodBlock(class_4970.class_2251 settings, int max_food) {
        this(settings, max_food, true);
    }

    public FoodBlock(class_4970.class_2251 settings, int max_food, @Nullable EnforceAsItem cItem) {
        this(settings, max_food);
        this.cItem = cItem;
    }

    public boolean haveCItem() {
        return this.cItem != null;
    }

    public String method_9539() {
        return class_156.method_646((String)"item", (class_2960)class_7923.field_41175.method_10221((Object)this));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_HANDLE.getShape(state, this.NUMBER_OF_FOOD);
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(1));
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1269 HookResult = this.onUseHook.interact(state, world, pos, player, hit);
        if (HookResult != class_1269.field_5811) {
            return HookResult;
        }
        class_1268 hand = player.method_6058();
        class_1799 handStack = player.method_5998(hand);
        int currentCount = (Integer)state.method_11654((class_2769)this.NUMBER_OF_FOOD);
        class_2586 blockEntity = world.method_8321(pos);
        boolean isSameItem = this.isSame(handStack, blockEntity);
        boolean tryFetch = false;
        if (world.field_9236) {
            if (isSameItem && currentCount < this.MAX_FOOD) {
                this.playSound(this.field_23162.method_10598(), world, pos, player);
            } else if (!isSameItem && currentCount > 0) {
                this.playSound(this.field_23162.method_10595(), world, pos, player);
            }
            return class_1269.field_5812;
        }
        if (isSameItem) {
            if (currentCount < this.MAX_FOOD && this.tryAdd(state, world, pos, player, handStack, blockEntity)) {
                this.playSound(this.field_23162.method_10598(), world, pos, player);
                if (!player.method_7337()) {
                    handStack.method_7934(1);
                    player.method_6122(hand, handStack);
                }
                return class_1269.field_5812;
            }
            tryFetch = true;
        }
        if ((currentCount > 0 || tryFetch) && this.tryRemove(state, world, pos, player, blockEntity)) {
            this.playSound(this.field_23162.method_10595(), world, pos, player);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected boolean tryAdd(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1799 handStack, class_2586 blockEntity) {
        int currentCount = (Integer)state.method_11654((class_2769)this.NUMBER_OF_FOOD);
        class_2680 newState = (class_2680)state.method_11657((class_2769)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(currentCount + 1));
        return world.method_8652(pos, newState, 3);
    }

    protected boolean tryRemove(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_2586 blockEntity) {
        class_1799 foodItem;
        int currentCount = (Integer)state.method_11654((class_2769)this.NUMBER_OF_FOOD);
        int newCount = currentCount - 1;
        if (newCount > 0) {
            class_2680 newState = (class_2680)state.method_11657((class_2769)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(newCount));
            world.method_8652(pos, newState, 3);
        } else {
            world.method_22352(pos, false);
        }
        if (!player.method_7337() && !player.method_7270(foodItem = this.createStack(1, blockEntity))) {
            player.method_7328(foodItem, false);
        }
        return true;
    }

    public boolean isSame(class_1799 stack, class_2586 blockEntity) {
        return stack.method_7909() == this.method_8389();
    }

    public class_1799 createStack(int count, @Nullable class_2586 blockEntity) {
        if (count <= 0 || count > this.MAX_FOOD) {
            throw new IllegalArgumentException("Count must be between 1 and " + this.MAX_FOOD);
        }
        return new class_1799((class_1935)this.method_8389(), count);
    }

    public void playSound(class_3414 event, class_1937 world, class_2338 pos, class_1657 player) {
        world.method_8396(player, pos, this.field_23162.method_10598(), class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 downPos = pos.method_10074();
        class_2680 checkState = world.method_8320(downPos);
        return !checkState.method_26164(ModTags.FOOD_PLACE) && !DFoodUtils.isModFoodBlock(checkState.method_26204());
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        int foodCount = (Integer)state.method_11654((class_2769)this.NUMBER_OF_FOOD);
        if (foodCount <= 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new class_1799((class_1935)this.method_8389(), foodCount));
    }

    public class_1792 method_8389() {
        if (this.cItem != null) {
            return this.cItem.getItem();
        }
        return super.method_8389();
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{IntPropertyManager.take()});
    }

    @FunctionalInterface
    public static interface onUseHook {
        public class_1269 interact(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4, class_3965 var5);
    }

    public static interface EnforceAsItem {
        public class_1792 getItem();
    }
}

