package org.dfood.block.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class SuspiciousStewBlockEntity extends class_2586 {
    protected final Map<Integer, Integer> EffectMap = new HashMap<>();

    public SuspiciousStewBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SuspiciousStewBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntityTypes.SUSPICIOUS_STEW_BLOCK_ENTITY, pos, state);
    }

    private void readEffectsFromNbt(class_2487 nbt) {
        EffectMap.clear();
        // 检查NBT中是否包含效果列表
        if (nbt != null && nbt.method_10573("Effects", class_2520.field_33259)) {
            class_2499 effectsList = nbt.method_10554("Effects", class_2520.field_33260);
            // 获取效果ID
            for (int i = 0; i < effectsList.size(); i++) {
                class_2487 effectTag = effectsList.method_10602(i);
                if (effectTag.method_10573("EffectId", class_2520.field_33263)) {
                    int effectId = effectTag.method_10550("EffectId");
                    // 获取持续时间，如果不存在则使用默认值160
                    int duration = effectTag.method_10573("EffectDuration", class_2520.field_33263)
                            ? effectTag.method_10550("EffectDuration")
                            : 160;

                    EffectMap.put(effectId, duration);
                }
            }
        }
    }

    public void readCustomDataFromItem(class_2487 nbt) {
        readEffectsFromNbt(nbt);
        this.method_5431();
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        readEffectsFromNbt(nbt);
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        writeCustomDataToItem(nbt);
    }

    public void writeCustomDataToItem(class_2487 nbt) {
        if (!EffectMap.isEmpty()) {
            class_2499 effectsList = new class_2499();

            for (Map.Entry<Integer, Integer> entry : EffectMap.entrySet()) {
                class_2487 effectTag = new class_2487();
                effectTag.method_10569("EffectId", entry.getKey());
                effectTag.method_10569("EffectDuration", entry.getValue());
                effectsList.add(effectTag);
            }

            nbt.method_10566("Effects", effectsList);
        }
    }

    public class_1799 getStewStack() {
        class_1799 stack = new class_1799(class_1802.field_8766);
        writeCustomDataToItem(stack.method_7948());
        return stack;
    }

    public Map<Integer, Integer> getEffectMap() {
        return new HashMap<>(EffectMap);
    }

    public void addEffect(int effectId, int duration) {
        EffectMap.put(effectId, duration);
        this.method_5431();
    }

    public void clearEffects() {
        EffectMap.clear();
        this.method_5431();
    }
}
