package org.dfood.block;

import org.dfood.block.entity.SuspiciousStewBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_8567;

public class SuspiciousStewBlock extends FoodBlock implements class_2343 {

    public SuspiciousStewBlock(class_2251 settings, int max_food) {
        super(settings, max_food);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SuspiciousStewBlockEntity(pos, state);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity) {
                class_2487 stackNbt = itemStack.method_7969();
                if (stackNbt != null) {
                    suspiciousStewBlockEntity.readCustomDataFromItem(stackNbt);
                }
            }
        }
    }

    @Override
    public boolean isSame(class_1799 stack, class_2586 blockEntity) {
        if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity && super.isSame(stack, blockEntity)) {
            class_2487 stewStackNbt = suspiciousStewBlockEntity.getStewStack().method_7969();
            class_2487 stackNbt = stack.method_7969();

            // 检查两个NBT是否都包含效果列表
            if (stackNbt != null && stewStackNbt != null &&
                    stackNbt.method_10545("Effects") && stewStackNbt.method_10545("Effects")) {
                // 比较效果列表是否相同
                return Objects.equals(stewStackNbt.method_10580("Effects"), stackNbt.method_10580("Effects"));
            }
            // 如果其中一个没有效果，则认为它们不匹配
            return false;
        }
        return false;
    }

    @Override
    public class_1799 createStack(int count, @Nullable class_2586 blockEntity) {
        class_1799 stack = new class_1799(class_1802.field_8766, count);

        if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity) {
            // 将方块实体中的效果写入物品NBT
            class_2487 nbt = stack.method_7948();
            suspiciousStewBlockEntity.writeCustomDataToItem(nbt);
        }

        return stack;
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = builder.method_51876(class_181.field_1228);

        if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity) {
            int count = state.method_11654(NUMBER_OF_FOOD);
            class_1799 baseStack = suspiciousStewBlockEntity.getStewStack();
            List<class_1799> drops = new java.util.ArrayList<>();

            for (int i = 0; i < count; i++) {
                drops.add(baseStack.method_7972());
            }

            return drops;
        }

        // 没有方块实体时，返回空列表
        return List.of();
    }
}