package org.dfood.mixin;

import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.dfood.item.HaveBlock;
import org.dfood.util.FoodToBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1802.class)
public abstract class foodToBlockMixin {

    /**
     *该Mixin类通过掉换注册方法的Item实例来实现将食物物品转换为对应的方块。
     * 原本的Item实例被更改了标识符变为了被遗弃的物品
     */
    @ModifyVariable(method = "register(Ljava/lang/String;Lnet/minecraft/item/Item;)Lnet/minecraft/item/Item;", at = @At("HEAD"), argsOnly = true)
    private static class_1792 modifyItem(class_1792 item, String value) {
        if (FoodToBlocks.foodMap.containsKey(value)) {
            class_2378.method_10230(class_7923.field_41178, new class_2960(value + "_de"), item);
            return FoodToBlocks.foodMap.get(value);
        } else {
            return item;
        }
    }

    @Inject(method = "register(Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/item/Item;)Lnet/minecraft/item/Item;", at = @At("RETURN"))
    private static void registerBlock(class_5321<class_1792> key, class_1792 item, CallbackInfoReturnable<class_1792> cir) {
        if (item instanceof HaveBlock haveBlock) {
            haveBlock.appendBlocks(class_1792.field_8003, item);
        }
    }
}
