package org.dfood.util;

import org.dfood.block.FoodBlock;
import org.dfood.item.HaveBlock;

import java.util.function.BiFunction;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;

public class DFoodUtils {

    /**
     * 检查物品是否是该模组添加的食物方块
     */
    public static boolean isModFoodItem(class_1792 item) {
        class_2680 state = getBlockStateFromItem(item);
        if (state == null) return false;

        if (item instanceof class_1747 && isPotatoOrCarrot(state)) {
            return true;
        }

        if (state.method_26204() instanceof FoodBlock block){
            return FoodBlock.FOOD_BLOCKS.contains(block);
        }

        return false;
    }

    public static boolean isModFoodBlock(class_2248 block){
        if (block instanceof FoodBlock foodBlock){
            return FoodBlock.FOOD_BLOCKS.contains(foodBlock);
        }

        return false;
    }

    public static boolean isHaveBlock(class_1792 item) {
        return item instanceof HaveBlock;
    }

    /**
     * 检查作物能否放置在指定位置
     */
    public static boolean isCropCanPlaceAt(class_1792 item, class_2338 pos, class_1937 world) {
        if (!(item instanceof class_1747)) return false;

        class_2680 state = getBlockStateFromItem(item);
        return state != null
                && isPotatoOrCarrot(state)
                && state.method_26184(world, pos.method_10084());
    }

    /**
     * 辅助方法
     * @param item 要转换的物品
     * @return 对应的默认方块状态
     */
    private static class_2680 getBlockStateFromItem(class_1792 item) {
        if (item instanceof class_1747 blockItem) {
            return blockItem.method_7711().method_9564();
        }
        if (item instanceof HaveBlock haveBlock) {
            return haveBlock.getBlock().method_9564();
        }
        return null;
    }

    private static boolean isPotatoOrCarrot(class_2680 state) {
        return state.equals(class_2246.field_10247.method_9564())
                || state.equals(class_2246.field_10609.method_9564());
    }

    public static class_2248 createFoodBlock(int foodValue, class_4970.class_2251 settings,
                                        BiFunction<class_4970.class_2251, Integer, class_2248> blockCreator) {
        IntPropertyManager.preCache("number_of_food", foodValue);
        return blockCreator.apply(settings, foodValue);
    }
}