package org.dfood.util;

import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3612;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.item.*;
import org.dfood.block.FoodBlocks;
import org.dfood.item.*;
import org.dfood.mixin.foodToBlockMixin;

import java.util.HashMap;
import java.util.Map;

/**
 * 一个映射类，使开发者可以高度自定义新的Item实例
 * @see foodToBlockMixin
 */
public class FoodToBlocks {
    public static final Map<String, class_1792> foodMap = new HashMap<>();

    static {
        // 零食类
        foodMap.put("cookie", getItem(FoodBlocks.COOKIE, class_4176.field_18655));
        foodMap.put("apple", getItem(FoodBlocks.APPLE, class_4176.field_18638));
        foodMap.put("melon_slice", getItem(FoodBlocks.MELON_SLICE, class_4176.field_18660));
        foodMap.put("bread", getItem(FoodBlocks.BREAD, class_4176.field_18643));

        // 蔬菜类
        foodMap.put("beetroot", getItem(FoodBlocks.BEETROOT, class_4176.field_18641));
        foodMap.put("potato", new DoubleBlockItem(class_2246.field_10247, new class_1792.class_1793().method_19265(class_4176.field_18627), FoodBlocks.POTATO));
        foodMap.put("baked_potato", getItem(FoodBlocks.BAKED_POTATO, class_4176.field_18639));
        foodMap.put("carrot", new DoubleBlockItem(class_2246.field_10609, new class_1792.class_1793().method_19265(class_4176.field_18644), FoodBlocks.CARROT));
        foodMap.put("sweet_berries", getItem(FoodBlocks.SWEET_BERRIES, class_4176.field_18636));
        foodMap.put("glow_berries", getItem(FoodBlocks.GLOW_BERRIES, class_4176.field_28647));

        // 金制食物
        foodMap.put("golden_apple", getItem(FoodBlocks.GOLDEN_APPLE, class_4176.field_18658));
        foodMap.put("golden_carrot", getItem(FoodBlocks.GOLDEN_CARROT, class_4176.field_18659));
        foodMap.put("glistering_melon_slice", new class_1747(FoodBlocks.GLISTERING_MELON_SLICE, new class_1792.class_1793()));

        // 生熟肉类
        foodMap.put("chicken", getItem(FoodBlocks.CHICKEN, class_4176.field_18645));
        foodMap.put("cooked_chicken", getItem(FoodBlocks.COOKED_CHICKEN, class_4176.field_18649));
        foodMap.put("beef", getItem(FoodBlocks.BEEF, class_4176.field_18640));
        foodMap.put("cooked_beef", getItem(FoodBlocks.COOKED_BEEF, class_4176.field_18648));
        foodMap.put("mutton", getItem(FoodBlocks.MUTTON, class_4176.field_18662));
        foodMap.put("cooked_mutton", getItem(FoodBlocks.COOKED_MUTTON, class_4176.field_18651));
        foodMap.put("porkchop", getItem(FoodBlocks.PORKCHOP, class_4176.field_18626));
        foodMap.put("cooked_porkchop", getItem(FoodBlocks.COOKED_PORKCHOP, class_4176.field_18652));
        foodMap.put("rabbit", getItem(FoodBlocks.RABBIT, class_4176.field_18630));
        foodMap.put("cooked_rabbit", getItem(FoodBlocks.COOKED_RABBIT, class_4176.field_18653));

        // 鱼类
        foodMap.put("cod", getItem(FoodBlocks.COD, class_4176.field_18647));
        foodMap.put("cooked_cod", getItem(FoodBlocks.COOKED_COD, class_4176.field_18650));
        foodMap.put("salmon", getItem(FoodBlocks.SALMON, class_4176.field_18633));
        foodMap.put("cooked_salmon", getItem(FoodBlocks.COOKED_SALMON, class_4176.field_18654));
        foodMap.put("pufferfish", getItem(FoodBlocks.PUFFERFISH, class_4176.field_18628));

        // 炖菜类
        foodMap.put("rabbit_stew", new ModStewItem(FoodBlocks.RABBIT_STEW, new class_1792.class_1793().method_7889(1).method_19265(class_4176.field_18631)));
        foodMap.put("mushroom_stew", new ModStewItem(FoodBlocks.MUSHROOM_STEW, new class_1792.class_1793().method_7889(1).method_19265(class_4176.field_18661)));
        foodMap.put("beetroot_soup", new ModStewItem(FoodBlocks.BEETROOT_SOUP, new class_1792.class_1793().method_7889(1).method_19265(class_4176.field_18642)));
        foodMap.put("suspicious_stew", new ModSuspiciousStewItem(FoodBlocks.SUSPICIOUS_STEW, new class_1792.class_1793().method_7889(1).method_19265(class_4176.field_18635)));
        foodMap.put("bowl", new class_1747(FoodBlocks.BOWL, new class_1792.class_1793()));

        // 桶
        foodMap.put("bucket", new ModBucketItem(class_3612.field_15906, new class_1792.class_1793().method_7889(16), FoodBlocks.BUCKET));
        foodMap.put("water_bucket", new ModBucketItem(class_3612.field_15910, new class_1792.class_1793().method_7896(class_1802.field_8550).method_7889(1), FoodBlocks.WATER_BUCKET));
        foodMap.put("milk_bucket", new ModMilkBucketItem(FoodBlocks.MILK_BUCKET, new class_1792.class_1793().method_7896(class_1802.field_8550).method_7889(1)));

        // 其他
        foodMap.put("pumpkin_pie", getItem(FoodBlocks.PUMPKIN_PIE, class_4176.field_18629));
        foodMap.put("chorus_fruit", new ModChorusFruitItem(FoodBlocks.CHORUS_FRUIT,new class_1792.class_1793().method_19265(class_4176.field_18646)));
        foodMap.put("egg", new ModEggItem(FoodBlocks.EGG, new class_1792.class_1793()));
        foodMap.put("totem_of_undying", new class_1747(FoodBlocks.TOTEM_OF_UNDYING, new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8907)));

        // 药水类
        foodMap.put("potion", new ModPotionItem(FoodBlocks.POTION, new class_1792.class_1793().method_7889(1)));
    }

    public static class_1747 getItem(class_2248 foodBlock, class_4174 foodComponent) {
        return new class_1747(foodBlock, new class_1792.class_1793().method_19265(foodComponent));
    }
}
