/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.dfood.block.entity.ModBlockEntityTypes;

public class SuspiciousStewBlockEntity
extends class_2586 {
    protected final Map<Integer, Integer> EffectMap = new HashMap<Integer, Integer>();

    public SuspiciousStewBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SuspiciousStewBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntityTypes.SUSPICIOUS_STEW_BLOCK_ENTITY, pos, state);
    }

    private void readEffectsFromNbt(class_2487 nbt) {
        this.EffectMap.clear();
        if (nbt != null && nbt.method_10573("Effects", 9)) {
            class_2499 effectsList = nbt.method_10554("Effects", 10);
            for (int i = 0; i < effectsList.size(); ++i) {
                class_2487 effectTag = effectsList.method_10602(i);
                if (!effectTag.method_10573("EffectId", 99)) continue;
                int effectId = effectTag.method_10550("EffectId");
                int duration = effectTag.method_10573("EffectDuration", 99) ? effectTag.method_10550("EffectDuration") : 160;
                this.EffectMap.put(effectId, duration);
            }
        }
    }

    public void readCustomDataFromItem(class_2487 nbt) {
        this.readEffectsFromNbt(nbt);
        this.method_5431();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.readEffectsFromNbt(nbt);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.writeCustomDataToItem(nbt);
    }

    public void writeCustomDataToItem(class_2487 nbt) {
        if (!this.EffectMap.isEmpty()) {
            class_2499 effectsList = new class_2499();
            for (Map.Entry<Integer, Integer> entry : this.EffectMap.entrySet()) {
                class_2487 effectTag = new class_2487();
                effectTag.method_10569("EffectId", entry.getKey().intValue());
                effectTag.method_10569("EffectDuration", entry.getValue().intValue());
                effectsList.add((Object)effectTag);
            }
            nbt.method_10566("Effects", (class_2520)effectsList);
        }
    }

    public class_1799 getStewStack() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8766);
        this.writeCustomDataToItem(stack.method_7948());
        return stack;
    }

    public Map<Integer, Integer> getEffectMap() {
        return new HashMap<Integer, Integer>(this.EffectMap);
    }

    public void addEffect(int effectId, int duration) {
        this.EffectMap.put(effectId, duration);
        this.method_5431();
    }

    public void clearEffects() {
        this.EffectMap.clear();
        this.method_5431();
    }
}

