/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2758;
import org.jetbrains.annotations.NotNull;

public class IntPropertyManager {
    private static final Map<String, class_2758> PROPERTY_CACHE = new HashMap<String, class_2758>();
    private static PendingPropertyInfo pendingInfo = null;

    public static void preCache(String name, int max) {
        IntPropertyManager.preCache(name, 1, max);
    }

    public static void preCache(String name, int min, int max) {
        if (max == min) {
            --min;
        }
        pendingInfo = new PendingPropertyInfo(name, min, max);
    }

    public static class_2758 take() {
        if (pendingInfo == null) {
            throw new IllegalStateException("No pre-cached property found");
        }
        String key = IntPropertyManager.generateKey(IntPropertyManager.pendingInfo.name, IntPropertyManager.pendingInfo.min, IntPropertyManager.pendingInfo.max);
        if (PROPERTY_CACHE.containsKey(key)) {
            class_2758 property = PROPERTY_CACHE.get(key);
            IntPropertyManager.clearPending();
            return property;
        }
        class_2758 property = class_2758.method_11867((String)IntPropertyManager.pendingInfo.name, (int)IntPropertyManager.pendingInfo.min, (int)IntPropertyManager.pendingInfo.max);
        PROPERTY_CACHE.put(key, property);
        IntPropertyManager.clearPending();
        return property;
    }

    public static class_2758 create(String name, int max) {
        return IntPropertyManager.create(name, 1, max);
    }

    public static class_2758 create(String name, int min, int max) {
        String key;
        if (max == min) {
            --min;
        }
        if (PROPERTY_CACHE.containsKey(key = IntPropertyManager.generateKey(name, min, max))) {
            return PROPERTY_CACHE.get(key);
        }
        class_2758 property = class_2758.method_11867((String)name, (int)min, (int)max);
        PROPERTY_CACHE.put(key, property);
        return property;
    }

    private static String generateKey(String name, int min, int max) {
        return name + ":" + min + ":" + max;
    }

    private static void clearPending() {
        pendingInfo = null;
    }

    public static boolean hasPending() {
        return pendingInfo != null;
    }

    public static String getPendingInfo() {
        return pendingInfo != null ? pendingInfo.toString() : null;
    }

    public static void clearAll() {
        PROPERTY_CACHE.clear();
        IntPropertyManager.clearPending();
    }

    public static int getCacheSize() {
        return PROPERTY_CACHE.size();
    }

    private record PendingPropertyInfo(String name, int min, int max) {
        @Override
        @NotNull
        public String toString() {
            return "PendingPropertyInfo{name='" + this.name + "', min=" + this.min + ", max=" + this.max + "}";
        }
    }
}

