/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.widget.field.MultiLineTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class MacroOptionList
extends MacroBindList {
    private final Macro macro;
    private OptionList.Entry.ActionButton addMessageEntry;

    public MacroOptionList(Minecraft mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Profile profile, Macro macro) {
        super(mc, width, height, y, entryWidth, entryHeight, entrySpacing, profile, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(Entry.MessageOptions.class, macro::moveMessage)));
        this.macro = macro;
        this.addMessageEntry = new OptionList.Entry.ActionButton(this.entryX, entryWidth, entryHeight, (Component)Component.literal((String)"+"), null, -1, button -> {
            macro.addMessage(new Message());
            this.init();
            this.ensureVisible((AbstractSelectionList.Entry)this.addMessageEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.addEntry((AbstractSelectionList.Entry)new Entry.DualKeybind(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, this.profile, this.macro));
        if (this.profile.getShowHudMessage().equals((Object)Profile.Control.DEFER) || this.profile.getAddToHistory().equals((Object)Profile.Control.DEFER) || this.profile.getResumeRepeating().equals((Object)Profile.Control.DEFER) || this.profile.getUseRatelimit().equals((Object)Profile.Control.DEFER)) {
            this.addEntry((AbstractSelectionList.Entry)new Entry.MacroControls(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this.profile, this.macro));
        }
        this.addEntry((AbstractSelectionList.Entry)new Entry.MacroMode1(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, this.profile, this.macro));
        this.addEntry((AbstractSelectionList.Entry)new Entry.MacroMode2(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this.profile, this.macro));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "macro.messages", new Object[0]), null, -1));
        this.refreshMessageSubList();
        this.addMessageEntry.setBounds(this.dynEntryX, this.dynEntryWidth, this.entryHeight);
        this.addEntry((AbstractSelectionList.Entry)this.addMessageEntry);
    }

    protected void refreshMessageSubList() {
        this.children().removeIf(entry -> entry instanceof Entry.MessageOptions);
        int start = this.children().indexOf((Object)this.addMessageEntry);
        start = start == -1 ? this.children().size() : --start;
        List<Message> messages = this.macro.getMessages();
        for (int i = messages.size() - 1; i >= 0; --i) {
            Message message = messages.get(i);
            Entry.MessageOptions msgEntry = new Entry.MessageOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.macro, message, i);
            this.children().add(start, new OptionList.Entry.Space(msgEntry));
            this.children().add(start, msgEntry);
        }
        this.refreshScrollAmount();
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class MessageOptions
        extends Entry {
            MessageOptions(int x, int width, int height, MacroOptionList list, Macro macro, Message msg, int index) {
                Font font = Minecraft.getInstance().font;
                boolean showDelayField = macro.getStrategy() == Macro.ConflictStrategy.AVOID || macro.getMode() == Macro.SendMode.SEND && macro.spaceTicks == 0 || macro.getMode() == Macro.SendMode.REPEAT || macro.getMode() == Macro.SendMode.RANDOM || macro.getMode() == Macro.SendMode.CYCLE;
                int minDelayFieldWidth = font.width("0__") + 8;
                int msgFieldWidth = width - (showDelayField ? minDelayFieldWidth + 4 : 0);
                this.elements.add(Button.builder((Component)Component.literal((String)"\u2191\u2193"), button -> {
                    this.setDragging(true);
                    list.startDragging(this, null, false);
                }).pos(x - list.smallWidgetWidth - 4, 0).size(list.smallWidgetWidth, height).build());
                MultiLineTextField messageField = new MultiLineTextField(x, 0, msgFieldWidth, height * 2);
                messageField.setCharacterLimit(512);
                messageField.setValueListener(val -> {
                    msg.string = val.stripLeading();
                });
                messageField.setValue(msg.string);
                this.elements.add(messageField);
                if (showDelayField) {
                    TextField delayField = new TextField(x + width - minDelayFieldWidth, 0, minDelayFieldWidth, height).posIntValidator().strict();
                    delayField.setTooltip(Tooltip.create((Component)Localization.localized("option", "macro.delay.individual.tooltip" + (index == 0 ? ".first" : ".subsequent"), new Object[0])));
                    delayField.setTooltipDelay(Duration.ofMillis(500L));
                    delayField.setMaxLength(8);
                    delayField.setResponder(val -> {
                        int newWidth = Math.max(minDelayFieldWidth, font.width(val) + font.width("__") + 8);
                        int deltaWidth = delayField.getWidth() - newWidth;
                        messageField.setWidth(messageField.getWidth() + deltaWidth);
                        delayField.setX(delayField.getX() + deltaWidth);
                        delayField.setWidth(delayField.getWidth() - deltaWidth);
                        try {
                            int delay = Integer.parseInt(val.strip());
                            if (delay < 0) {
                                throw new NumberFormatException();
                            }
                            msg.delayTicks = delay;
                            delayField.setTextColor(0xFFFFFF);
                        }
                        catch (NumberFormatException ignored) {
                            delayField.setTextColor(0xFF0000);
                        }
                    });
                    delayField.setValue(String.valueOf(msg.delayTicks));
                    delayField.setCursorPosition(0);
                    delayField.setHighlightPos(0);
                    this.elements.add(delayField);
                }
                this.elements.add(Button.builder((Component)Component.literal((String)"\u274c").withStyle(ChatFormatting.RED), button -> {
                    macro.removeMessage(index);
                    list.init();
                }).pos(x + width + 4, 0).size(list.smallWidgetWidth, height).build());
            }
        }

        private static class MacroMode2
        extends Entry {
            MacroMode2(int x, int width, int height, Profile profile, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(CycleButton.builder(Macro.ActivationType::title).withValues((Object[])Macro.ActivationType.values()).withInitialValue((Object)macro.getActivationType()).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.activation", new Object[0]), (button, status) -> profile.setActivationType(macro, (Macro.ActivationType)((Object)status))));
                if (macro.getMode().equals((Object)Macro.SendMode.REPEAT)) {
                    TextField delayField = new TextField(x + width - buttonWidth, 0, buttonWidth, height).posIntValidator().strict();
                    delayField.setMaxLength(8);
                    delayField.setResponder(val -> {
                        macro.maxRepeats = Integer.parseInt(val.strip());
                    });
                    delayField.setValue(String.valueOf(macro.maxRepeats));
                    delayField.setTooltip(Tooltip.create((Component)Localization.localized("option", "macro.maxRepeats.tooltip", new Object[0])));
                    this.elements.add(delayField);
                }
            }
        }

        private static class MacroMode1
        extends Entry {
            private TextField delayField;

            MacroMode1(int x, int width, int height, MacroOptionList list, Profile profile, Macro macro) {
                Font font = Minecraft.getInstance().font;
                int buttonWidth = (width - 4) / 2;
                int minDelayFieldWidth = font.width("0_") + 8;
                int modeButtonWidth = switch (macro.getMode()) {
                    default -> throw new MatchException(null, null);
                    case Macro.SendMode.SEND, Macro.SendMode.REPEAT -> buttonWidth - minDelayFieldWidth;
                    case Macro.SendMode.TYPE, Macro.SendMode.RANDOM, Macro.SendMode.EDIT -> buttonWidth;
                    case Macro.SendMode.CYCLE -> buttonWidth - list.smallWidgetWidth;
                };
                this.elements.add(CycleButton.builder(Macro.ConflictStrategy::title).withValues((Object[])Macro.ConflictStrategy.values()).withInitialValue((Object)macro.getStrategy()).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.conflict", new Object[0]), (button, status) -> {
                    profile.setConflictStrategy(macro, (Macro.ConflictStrategy)((Object)status));
                    list.init();
                }));
                CycleButton modeButton = CycleButton.builder(Macro.SendMode::title).withValues((Object[])Macro.SendMode.values()).withInitialValue((Object)macro.getMode()).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(x + width - buttonWidth, 0, modeButtonWidth, height, (Component)Localization.localized("option", "macro.mode", new Object[0]), (button, status) -> {
                    profile.setSendMode(macro, (Macro.SendMode)((Object)status));
                    list.init();
                });
                this.elements.add(modeButton);
                if (macro.getMode().equals((Object)Macro.SendMode.CYCLE)) {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (int i = 0; i < macro.getMessages().size(); ++i) {
                        values.add(i);
                    }
                    if (values.isEmpty()) {
                        values.add(0);
                    }
                    if (macro.cycleIndex > (Integer)values.getLast()) {
                        macro.cycleIndex = 0;
                    }
                    this.elements.add(CycleButton.builder(status -> Component.literal((String)status.toString())).withValues(values).withInitialValue((Object)macro.cycleIndex).displayOnlyValue().withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.cycleIndex.tooltip", new Object[0]))).create(x + width - list.smallWidgetWidth, 0, list.smallWidgetWidth, height, (Component)Component.empty(), (button, status) -> {
                        macro.cycleIndex = status;
                    }));
                } else if (macro.getMode().equals((Object)Macro.SendMode.SEND) || macro.getMode().equals((Object)Macro.SendMode.REPEAT)) {
                    this.delayField = new TextField(x + width - minDelayFieldWidth, 0, minDelayFieldWidth, height).posIntValidator().strict();
                    this.delayField.setMaxLength(8);
                    this.delayField.setResponder(arg_0 -> this.lambda$new$7(minDelayFieldWidth, font, (AbstractButton)modeButton, macro, list, arg_0));
                    this.delayField.setValue(String.valueOf(macro.spaceTicks));
                    this.delayField.setCursorPosition(0);
                    this.delayField.setHighlightPos(0);
                    this.delayField.setTooltip(Tooltip.create((Component)Localization.localized("option", "macro.delay.tooltip" + (macro.getMode().equals((Object)Macro.SendMode.REPEAT) ? ".repeat" : ""), new Object[0])));
                    this.elements.add(this.delayField);
                }
            }

            private /* synthetic */ void lambda$new$7(int minDelayFieldWidth, Font font, AbstractButton modeButton, Macro macro, MacroOptionList list, String val) {
                int newWidth = Math.max(minDelayFieldWidth, font.width(val) + font.width("_") + 8);
                int deltaWidth = this.delayField.getWidth() - newWidth;
                modeButton.setWidth(modeButton.getWidth() + deltaWidth);
                this.delayField.setX(this.delayField.getX() + deltaWidth);
                this.delayField.setWidth(this.delayField.getWidth() - deltaWidth);
                int space = Integer.parseInt(val.strip());
                int oldSpace = macro.spaceTicks;
                macro.spaceTicks = space;
                if (macro.getMode() == Macro.SendMode.SEND && (space == 0 && oldSpace != 0 || space != 0 && oldSpace == 0)) {
                    list.refreshMessageSubList();
                }
            }
        }

        private static class MacroControls
        extends Entry {
            MacroControls(int x, int width, int height, Profile profile, Macro macro) {
                int buttonWidth = (width - 6) / 4;
                int movingX = x;
                boolean hudActive = profile.getShowHudMessage().equals((Object)Profile.Control.DEFER);
                CycleButton hudButton = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)(hudActive ? macro.getShowHudMessage() : macro.getShowHudMessageStatus())).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.hud.tooltip", new Object[0]))).create(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.hud", new Object[0]), (button, status) -> profile.setShowHudMessage(macro, (boolean)status));
                hudButton.setTooltipDelay(Duration.ofMillis(500L));
                hudButton.active = hudActive;
                this.elements.add(hudButton);
                boolean historyActive = profile.getAddToHistory().equals((Object)Profile.Control.DEFER);
                CycleButton historyButton = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)(historyActive ? macro.getAddToHistory() : macro.getAddToHistoryStatus())).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.history.tooltip", new Object[0]))).create(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.history", new Object[0]), (button, status) -> profile.setAddToHistory(macro, (boolean)status));
                historyButton.setTooltipDelay(Duration.ofMillis(500L));
                historyButton.active = historyActive;
                this.elements.add(historyButton);
                movingX = x + width - buttonWidth * 2 - 2;
                boolean resumeActive = profile.getResumeRepeating().equals((Object)Profile.Control.DEFER);
                CycleButton resumeButton = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)(resumeActive ? macro.getResumeRepeating() : macro.getResumeRepeatingStatus())).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.resume.tooltip", new Object[0]))).create(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.resume", new Object[0]), (button, status) -> profile.setResumeRepeating(macro, (boolean)status));
                resumeButton.setTooltipDelay(Duration.ofMillis(500L));
                resumeButton.active = resumeActive;
                this.elements.add(resumeButton);
                boolean ratelimitActive = profile.getUseRatelimit().equals((Object)Profile.Control.DEFER);
                CycleButton ratelimitButton = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)(ratelimitActive ? macro.getUseRatelimit() : macro.getUseRatelimitStatus())).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.ratelimit.tooltip", new Object[0]))).create(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.ratelimit", new Object[0]), (button, status) -> profile.setUseRatelimit(macro, (boolean)status));
                ratelimitButton.setTooltipDelay(Duration.ofMillis(500L));
                ratelimitButton.active = ratelimitActive;
                this.elements.add(ratelimitButton);
            }
        }

        private static class DualKeybind
        extends Entry {
            DualKeybind(int x, int width, int height, MacroOptionList list, Profile profile, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                KeybindUtil.KeybindInfo info = new KeybindUtil.KeybindInfo(profile, macro, macro.getKeybind());
                this.elements.add(Button.builder((Component)info.conflictLabel, button -> {
                    list.setSelected(macro, macro.getKeybind());
                    button.setMessage((Component)Component.literal((String)"> ").append((Component)info.label.withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.UNDERLINE)).append(" <").withStyle(ChatFormatting.YELLOW));
                }).tooltip(Tooltip.create((Component)info.tooltip)).pos(x, 0).size(buttonWidth, height).build());
                KeybindUtil.KeybindInfo altInfo = new KeybindUtil.KeybindInfo(profile, macro, macro.getAltKeybind());
                this.elements.add(Button.builder((Component)altInfo.conflictLabel, button -> {
                    list.setSelected(macro, macro.getAltKeybind());
                    button.setMessage((Component)Component.literal((String)"> ").append((Component)altInfo.label.withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.UNDERLINE)).append(" <").withStyle(ChatFormatting.YELLOW));
                }).tooltip(Tooltip.create((Component)(altInfo.tooltip.getString().isBlank() ? Localization.localized("option", "macro.bind.alt.tooltip", new Object[0]) : altInfo.tooltip))).pos(x + width - buttonWidth, 0).size(buttonWidth, height).build());
            }
        }
    }
}

