/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.field;

import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.mixin.accessor.MultiLineEditBoxAccessor;
import dev.terminalmc.commandkeys.mixin.accessor.MultilineTextFieldAccessor;
import dev.terminalmc.commandkeys.mixin.accessor.StringViewAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLineTextField
extends MultiLineEditBox {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = -2039584;
    public static final int TEXT_COLOR_ERROR = -43691;
    public final List<@NotNull TextField.Validator> validators = new ArrayList<TextField.Validator>();
    public boolean lenient = true;
    private int normalTextColor;
    private int currentTextColor = this.normalTextColor = -2039584;
    @Nullable
    private Tooltip normalTooltip;
    @Nullable
    private Tooltip errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private long lastClickTime;
    private int chainedClicks;

    public MultiLineTextField(int x, int y, int width, int height) {
        this(Minecraft.getInstance().font, x, y, width, height, (Component)Component.empty(), (Component)Component.empty(), null);
    }

    public MultiLineTextField(int x, int y, int width, int height, Component placeholder) {
        this(Minecraft.getInstance().font, x, y, width, height, placeholder, (Component)Component.empty(), null);
    }

    public MultiLineTextField(Font font, int x, int y, int width, int height, Component placeholder, Component message, @Nullable TextField.Validator validator) {
        super(font, x, y, width, height, placeholder, message, -2039584, true, -3092272, true, true);
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public MultiLineTextField withValidator(@NotNull TextField.Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public void setValueListener(@NotNull Consumer<String> responder) {
        super.setValueListener(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (TextField.Validator v : this.validators) {
            Optional<Component> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = Tooltip.create((Component)error.get());
            super.setTooltip(this.errorTooltip);
            this.currentTextColor = -43691;
            return false;
        }
        this.errorTooltip = null;
        this.currentTextColor = this.normalTextColor;
        super.setTooltip(this.normalTooltip);
        return true;
    }

    public void setTooltip(@Nullable Tooltip tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.setTooltip(tooltip);
        }
    }

    public int getTextColor() {
        return this.currentTextColor;
    }

    public void setTextColor(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            this.currentTextColor = color;
        }
    }

    public void setWidth(int width) {
        super.setWidth(width);
        ((MultilineTextFieldAccessor)((MultiLineEditBoxAccessor)((Object)this)).commandkeys$getTextField()).commandkeys$setWidth(width);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            long time = Util.getMillis();
            if (this.lastClickTime + 250L > time) {
                MultilineTextField field = ((MultiLineEditBoxAccessor)((Object)this)).commandkeys$getTextField();
                MultilineTextFieldAccessor fieldAcc = (MultilineTextFieldAccessor)field;
                switch (++this.chainedClicks) {
                    case 1: {
                        field.seekCursor(Whence.ABSOLUTE, ((StringViewAccessor)field.getNextWord()).commandkeys$getBeginIndex());
                        int pos = fieldAcc.commandkeys$getCursor();
                        field.seekCursor(Whence.ABSOLUTE, ((StringViewAccessor)field.getPreviousWord()).commandkeys$getBeginIndex());
                        fieldAcc.commandkeys$setSelectCursor(pos);
                        break;
                    }
                    case 2: 
                    case 3: {
                        fieldAcc.commandkeys$setCursor(this.getValue().length());
                        fieldAcc.commandkeys$setSelectCursor(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        fieldAcc.commandkeys$setSelectCursor(fieldAcc.commandkeys$getCursor());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            return true;
        }
        return false;
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                    this.history.removeLast();
                }
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!super.keyPressed(keyCode, scanCode, modifiers)) {
            if (TextField.isUndo(keyCode)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(keyCode)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.setValue(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.setValue(this.history.get(++this.historyIndex));
        }
    }
}

