/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import dev.terminalmc.commandkeys.gui.widget.field.FakeTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.gui.widget.list.ProfileOptionList;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class MainOptionList
extends OptionList {
    @Nullable
    private Profile editingProfile;

    public MainOptionList(Minecraft mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpace, @Nullable Profile editingProfile) {
        super(mc, width, height, y, entryWidth, entryHeight, entrySpace);
        this.editingProfile = editingProfile;
    }

    @Override
    protected void addEntries() {
        boolean inGame = CommandKeys.inGame();
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)(inGame ? Localization.localized("option", "main.profiles.activate", new Object[0]) : Localization.localized("option", "main.profiles", "\u2139")), inGame ? null : Tooltip.create((Component)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
        int i = 0;
        for (Profile profile : Config.get().getProfiles()) {
            this.addEntry((AbstractSelectionList.Entry)new Entry.ProfileOptions(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, profile, i, inGame));
            if (profile.equals(this.editingProfile)) {
                this.addEntry((AbstractSelectionList.Entry)new Entry.ProfileName(this.dynEntryX, this.dynEntryWidth, this.entryHeight, profile));
                for (String address : profile.getLinks()) {
                    this.addEntry((AbstractSelectionList.Entry)new Entry.ProfileLink(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, profile, address));
                }
            }
            if (i++ != 0 || !inGame) continue;
            this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.profiles.other", "\u2139"), Tooltip.create((Component)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
        }
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.ActionButton(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Component.literal((String)"+"), null, -1, button -> {
            this.editingProfile = Config.get().addNewProfile();
            this.init();
        }));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.default", "\u2139"), Tooltip.create((Component)Localization.localized("option", "main.default.tooltip", new Object[0])), 500));
        this.addEntry((AbstractSelectionList.Entry)new Entry.DefaultOptions1(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.addEntry((AbstractSelectionList.Entry)new Entry.DefaultOptions2(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.ratelimit", "\u2139"), Tooltip.create((Component)Localization.localized("option", "main.ratelimit.tooltip", new Object[0])), 500));
        this.addEntry((AbstractSelectionList.Entry)new Entry.Ratelimit(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.lengthlimit", "\u2139"), Tooltip.create((Component)Localization.localized("option", "main.lengthlimit.tooltip", new Object[0])), 500));
        this.addEntry((AbstractSelectionList.Entry)new Entry.LengthLimit(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
    }

    public void openProfileOptions(Profile profile) {
        this.mc.setScreen((Screen)new OptionScreen((Screen)this.screen, (Component)Localization.localized("option", "profile", profile.getDisplayName()), new ProfileOptionList(this.mc, this.width, this.height, this.getY(), this.entryWidth, this.entryHeight, this.entrySpacing, profile)));
    }

    @Override
    public boolean keyPressed(InputConstants.Key key) {
        return false;
    }

    @Override
    public boolean keyReleased(InputConstants.Key key) {
        return false;
    }

    @Override
    public boolean mouseClicked(InputConstants.Key key) {
        return false;
    }

    @Override
    public boolean mouseReleased(InputConstants.Key key) {
        return false;
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class LengthLimit
        extends Entry {
            LengthLimit(int x, int width, int height) {
                TextField lengthField = new TextField(x, 0, width, height);
                lengthField.posIntValidator().strict();
                lengthField.setMaxLength(6);
                lengthField.setResponder(val -> {
                    try {
                        int space = Integer.parseInt(val.strip());
                        if (space < 1) {
                            throw new NumberFormatException();
                        }
                        Config.get().setLengthLimitLength(space);
                        lengthField.setTextColor(0xFFFFFF);
                    }
                    catch (NumberFormatException ignored) {
                        lengthField.setTextColor(0xFF0000);
                    }
                });
                lengthField.setValue(String.valueOf(Config.get().getLengthLimitLength()));
                lengthField.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.lengthlimit.length.tooltip", new Object[0]).append("\n").append((Component)Localization.localized("option", "main.lengthlimit.length.tooltip.warning", new Object[0]).withStyle(ChatFormatting.RED))));
                this.elements.add(lengthField);
            }
        }

        private static class Ratelimit
        extends Entry {
            Ratelimit(int x, int width, int height) {
                int buttonWidth = (width - 8) / 3;
                int fieldWidth = (buttonWidth - 4) / 2;
                int movingX = x;
                TextField countField = new TextField(movingX, 0, fieldWidth, height);
                countField.posIntValidator().strict();
                countField.setMaxLength(6);
                countField.setResponder(val -> Config.get().setRatelimitCount(Integer.parseInt(val.strip())));
                countField.setValue(String.valueOf(Config.get().getRatelimitCount()));
                countField.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.ratelimit.count.tooltip", new Object[0])));
                this.elements.add(countField);
                TextField ticksField = new TextField(movingX += fieldWidth + 4, 0, fieldWidth, height);
                ticksField.posIntValidator().strict();
                ticksField.setMaxLength(6);
                ticksField.setResponder(val -> {
                    try {
                        int space = Integer.parseInt(val.strip());
                        if (space < 1) {
                            throw new NumberFormatException();
                        }
                        Config.get().setRatelimitTicks(space);
                        ticksField.setTextColor(0xFFFFFF);
                    }
                    catch (NumberFormatException ignored) {
                        ticksField.setTextColor(0xFF0000);
                    }
                });
                ticksField.setValue(String.valueOf(Config.get().getRatelimitTicks()));
                ticksField.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.ratelimit.ticks.tooltip", new Object[0])));
                this.elements.add(ticksField);
                movingX = x + width - buttonWidth * 2 - 4;
                CycleButton strictButton = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)Config.get().ratelimitStrict).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "main.ratelimit.strict.tooltip", new Object[0]))).create(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "main.ratelimit.strict", new Object[0]), (button, status) -> {
                    Config.get().ratelimitStrict = status;
                });
                strictButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(strictButton);
                movingX = x + width - buttonWidth;
                CycleButton spButton = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)Config.get().ratelimitSp).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "main.ratelimit.sp.tooltip", new Object[0]))).create(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "main.ratelimit.sp", new Object[0]), (button, status) -> {
                    Config.get().ratelimitSp = status;
                });
                spButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(spButton);
            }
        }

        private static class DefaultOptions2
        extends Entry {
            DefaultOptions2(int x, int width, int height) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(CycleButton.builder(Macro.ActivationType::title).withValues((Object[])Macro.ActivationType.values()).withInitialValue((Object)Config.get().defaultActivationType).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.activation", new Object[0]), (button, status) -> {
                    Config.get().defaultActivationType = status;
                }));
            }
        }

        private static class DefaultOptions1
        extends Entry {
            DefaultOptions1(int x, int width, int height) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(CycleButton.builder(Macro.ConflictStrategy::title).withValues((Object[])Macro.ConflictStrategy.values()).withInitialValue((Object)Config.get().defaultConflictStrategy).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.conflict", new Object[0]), (button, status) -> {
                    Config.get().defaultConflictStrategy = status;
                }));
                this.elements.add(CycleButton.builder(Macro.SendMode::title).withValues((Object[])Macro.SendMode.values()).withInitialValue((Object)Config.get().defaultSendMode).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(x + width - buttonWidth, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.mode", new Object[0]), (button, status) -> {
                    Config.get().defaultSendMode = status;
                }));
            }
        }

        private static class ProfileLink
        extends Entry {
            ProfileLink(int x, int width, int height, MainOptionList list, Profile profile, String address) {
                int labelWidth = 50;
                int linkFieldWidth = width - labelWidth - list.smallWidgetWidth - 4;
                Button label = Button.builder((Component)Localization.localized("option", "main.profiles.link", new Object[0]), button -> {}).pos(x, 0).size(labelWidth, height).build();
                label.active = false;
                this.elements.add(label);
                FakeTextField linkField = new FakeTextField(x + labelWidth, 0, linkFieldWidth, height, () -> {});
                linkField.setMaxLength(64);
                linkField.setValue(address);
                linkField.active = false;
                this.elements.add(linkField);
                Button removeButton = Button.builder((Component)Component.literal((String)"\u274c"), button -> {
                    profile.removeLink(address);
                    list.init();
                }).pos(x + width - list.smallWidgetWidth, 0).size(list.smallWidgetWidth, height).build();
                removeButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profile.link.remove.tooltip", new Object[0])));
                removeButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(removeButton);
            }
        }

        private static class ProfileName
        extends Entry {
            ProfileName(int x, int width, int height, Profile profile) {
                int labelWidth = 50;
                int nameBoxWidth = width - labelWidth - 4;
                Button label = Button.builder((Component)Localization.localized("option", "main.profile.name", new Object[0]), button -> {}).pos(x, 0).size(labelWidth, height).build();
                label.active = false;
                this.elements.add(label);
                TextField nameBox = new TextField(x + labelWidth, 0, nameBoxWidth, height);
                nameBox.setMaxLength(64);
                nameBox.setResponder(value -> {
                    profile.name = value.strip();
                });
                nameBox.setValue(profile.name);
                this.elements.add(nameBox);
            }
        }

        private static class ProfileOptions
        extends Entry {
            MainOptionList list;
            Profile profile;

            ProfileOptions(int x, int width, int height, MainOptionList list, Profile profile, int index, boolean inGame) {
                this.list = list;
                this.profile = profile;
                boolean spDefault = index == Config.get().getSpDefault();
                boolean mpDefault = index == Config.get().getMpDefault();
                int smallWidgetWidth = list.smallWidgetWidth;
                int mainButtonWidth = width - smallWidgetWidth * 5 - 20;
                int mainButtonX = x;
                if (inGame) {
                    if (index == 0) {
                        ImageButton linkButton = new ImageButton(x, 0, smallWidgetWidth, height, LINK_SPRITES, button -> {
                            profile.forceAddLink(CommandKeys.lastConnection);
                            list.init();
                        });
                        if (profile.getLinks().contains(CommandKeys.lastConnection)) {
                            linkButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.linked.tooltip", new Object[0])));
                            linkButton.active = false;
                        } else {
                            linkButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.link.tooltip", new Object[0])));
                        }
                        linkButton.setTooltipDelay(Duration.ofMillis(500L));
                        this.elements.add(linkButton);
                    } else {
                        Button activateButton = Button.builder((Component)Component.literal((String)"\u2191"), button -> {
                            Config.get().activateProfile(index);
                            list.init();
                        }).pos(x, 0).size(smallWidgetWidth, height).build();
                        activateButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.activate.tooltip", new Object[0])));
                        activateButton.setTooltipDelay(Duration.ofMillis(500L));
                        this.elements.add(activateButton);
                    }
                    mainButtonWidth -= smallWidgetWidth + 4;
                    mainButtonX += smallWidgetWidth + 4;
                }
                MutableComponent name = Component.literal((String)profile.getDisplayName());
                int numLinks = profile.getLinks().size();
                if (numLinks != 0) {
                    name.append(" ");
                    if (numLinks == 1) {
                        name.append((Component)Localization.localized("option", "main.profiles.links.one", new Object[0]).withStyle(ChatFormatting.GRAY));
                    } else {
                        name.append((Component)Localization.localized("option", "main.profiles.links.many", numLinks).withStyle(ChatFormatting.GRAY));
                    }
                }
                this.elements.add(Button.builder((Component)name, button -> list.openProfileOptions(profile)).tooltip(Tooltip.create((Component)Localization.localized("option", "main.profile.edit.tooltip", new Object[0]))).pos(mainButtonX, 0).size(mainButtonWidth, height).build());
                int movingX = x + width - smallWidgetWidth * 5 - 16;
                ImageButton configureButton = new ImageButton(movingX, 0, smallWidgetWidth, height, OPTION_SPRITES, button -> {
                    list.editingProfile = list.editingProfile == null ? profile : (!list.editingProfile.equals(profile) ? profile : null);
                    list.init();
                }, (Component)Component.empty());
                configureButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profile.details.tooltip", new Object[0])));
                configureButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(configureButton);
                Button setAsSpDefaultButton = Button.builder((Component)Localization.localized("option", "main.profiles.default.singleplayer.set", new Object[0]), button -> {
                    Config.get().setSpDefault(index);
                    list.init();
                }).pos(movingX += smallWidgetWidth + 4, 0).size(smallWidgetWidth, height).build();
                if (spDefault) {
                    setAsSpDefaultButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.default.singleplayer.tooltip", new Object[0])));
                    setAsSpDefaultButton.setMessage((Component)setAsSpDefaultButton.getMessage().copy().withStyle(ChatFormatting.GREEN));
                } else {
                    setAsSpDefaultButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.default.singleplayer.set.tooltip", new Object[0])));
                }
                setAsSpDefaultButton.setTooltipDelay(Duration.ofMillis(500L));
                setAsSpDefaultButton.active = !spDefault;
                this.elements.add(setAsSpDefaultButton);
                Button setAsMpDefaultButton = Button.builder((Component)Localization.localized("option", "main.profiles.default.multiplayer.set", new Object[0]), button -> {
                    Config.get().setMpDefault(index);
                    list.init();
                }).pos(movingX += smallWidgetWidth + 4, 0).size(smallWidgetWidth, height).build();
                if (mpDefault) {
                    setAsMpDefaultButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.default.multiplayer.tooltip", new Object[0])));
                    setAsMpDefaultButton.setMessage((Component)setAsMpDefaultButton.getMessage().copy().withStyle(ChatFormatting.GREEN));
                } else {
                    setAsMpDefaultButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.default.multiplayer.set.tooltip", new Object[0])));
                }
                setAsMpDefaultButton.setTooltipDelay(Duration.ofMillis(500L));
                setAsMpDefaultButton.active = !mpDefault;
                this.elements.add(setAsMpDefaultButton);
                ImageButton copyButton = new ImageButton(movingX += smallWidgetWidth + 4, 0, smallWidgetWidth, height, COPY_SPRITES, button -> {
                    Config.get().addCopyProfile(profile);
                    list.init();
                }, (Component)Component.empty());
                copyButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.copy.tooltip", new Object[0])));
                copyButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(copyButton);
                Button deleteButton = Button.builder((Component)Component.literal((String)"\u274c"), button -> {
                    Config.get().removeProfile(index);
                    list.init();
                }).pos(movingX += smallWidgetWidth + 4, 0).size(smallWidgetWidth, height).build();
                if (spDefault || mpDefault) {
                    deleteButton.active = false;
                    deleteButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.delete.disabled.tooltip", new Object[0])));
                } else {
                    deleteButton.setMessage((Component)deleteButton.getMessage().copy().withStyle(ChatFormatting.RED));
                    deleteButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "main.profiles.delete.tooltip", new Object[0])));
                }
                deleteButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(deleteButton);
            }
        }
    }
}

