/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionList
extends ContainerObjectSelectionList<Entry> {
    protected OptionScreen screen;
    protected final Minecraft mc;
    protected final int entryWidth;
    protected final int entryHeight;
    protected final int entrySpacing;
    protected int rowWidth;
    protected int dynWideEntryWidth;
    protected int dynEntryWidth;
    protected int entryX;
    protected int dynWideEntryX;
    protected int dynEntryX;
    protected int smallWidgetWidth;
    protected int tinyWidgetWidth;

    public OptionList(Minecraft mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, width, height, y, entryHeight + entrySpacing);
        this.mc = mc;
        this.entryWidth = entryWidth;
        this.entryHeight = entryHeight;
        this.entrySpacing = entrySpacing;
        this.updateElementBounds();
    }

    protected void updateElementBounds() {
        this.dynWideEntryWidth = Math.max(this.entryWidth, (int)((float)this.width / 100.0f * 70.0f));
        this.dynEntryWidth = Math.max(this.entryWidth, (int)((float)this.width / 100.0f * 50.0f));
        this.entryX = this.width / 2 - this.entryWidth / 2;
        this.dynWideEntryX = this.width / 2 - this.dynWideEntryWidth / 2;
        this.dynEntryX = this.width / 2 - this.dynEntryWidth / 2;
        this.rowWidth = Math.max(this.entryWidth, this.dynWideEntryWidth) + 40 + 48;
        this.smallWidgetWidth = Math.max(16, this.entryHeight);
        this.tinyWidgetWidth = 16;
    }

    protected void init() {
        double scrollAmount = this.scrollAmount();
        this.clearEntries();
        this.setFocused(null);
        this.addEntries();
        this.setScrollAmount(scrollAmount);
    }

    public void setScreen(OptionScreen screen) {
        this.screen = screen;
    }

    public void addEntry(int index, Entry entry) {
        this.children().add(index, entry);
    }

    public void addSpacedEntry(Entry entry) {
        super.addEntry((AbstractSelectionList.Entry)entry);
        super.addEntry((AbstractSelectionList.Entry)new Entry.Space(entry));
    }

    public void addSpacedEntry(int index, Entry entry) {
        this.addEntry(index, entry);
        this.addEntry(index + 1, new Entry.Space(entry));
    }

    protected abstract void addEntries();

    public void updateSizeAndPosition(int width, int height, int y) {
        super.updateSizeAndPosition(width, height, y);
        this.updateElementBounds();
        this.init();
    }

    public int getRowWidth() {
        return this.rowWidth;
    }

    protected int scrollBarX() {
        return this.width / 2 + this.rowWidth / 2;
    }

    public abstract boolean keyPressed(InputConstants.Key var1);

    public abstract boolean keyReleased(InputConstants.Key var1);

    public abstract boolean mouseClicked(InputConstants.Key var1);

    public abstract boolean mouseReleased(InputConstants.Key var1);

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public static final int SPACE = 4;
        public static final int SPACE_SMALL = 2;
        public static final int SPACE_TINY = 1;
        public static final WidgetSprites COPY_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/copy_button"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/copy_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/copy_button_highlighted"));
        public static final WidgetSprites OPTION_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/options_button"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/options_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/options_button_highlighted"));
        public static final WidgetSprites LINK_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/link_button"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/link_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/link_button_highlighted"));
        public static final WidgetSprites SEND_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/send_button"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/send_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"commandkeys", (String)"widget/send_button_highlighted"));
        public final List<AbstractWidget> elements = new ArrayList<AbstractWidget>();

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.elements;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.elements;
        }

        public void render(@NotNull GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.elements.forEach(button -> {
                button.setY(y);
                button.render(graphics, mouseX, mouseY, tickDelta);
            });
        }

        public static class Space
        extends Entry {
            private final Entry entry;

            public Space(Entry entry) {
                this.entry = entry;
            }

            public boolean isDragging() {
                return this.entry.isDragging();
            }

            public void setDragging(boolean dragging) {
                this.entry.setDragging(dragging);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.entry.mouseClicked(mouseX, mouseY, button);
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                return this.entry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
            }

            public void setFocused(GuiEventListener listener) {
                this.entry.setFocused(listener);
            }

            public GuiEventListener getFocused() {
                return this.entry.getFocused();
            }

            public ComponentPath focusPathAtIndex(@NotNull FocusNavigationEvent event, int i) {
                if (this.entry.children().isEmpty()) {
                    return null;
                }
                ComponentPath $$2 = this.entry.children().get(Math.min(i, this.entry.children().size() - 1)).nextFocusPath(event);
                return ComponentPath.path((ContainerEventHandler)this.entry, (ComponentPath)$$2);
            }
        }

        public static class ActionButton
        extends Entry {
            private final Button button;

            public ActionButton(int x, int width, int height, Component message, @Nullable Tooltip tooltip, int tooltipDelay, Button.OnPress onPress) {
                this.button = Button.builder((Component)message, (Button.OnPress)onPress).pos(x, 0).size(width, height).build();
                if (tooltip != null) {
                    this.button.setTooltip(tooltip);
                }
                if (tooltipDelay >= 0) {
                    this.button.setTooltipDelay(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(this.button);
            }

            public void setBounds(int x, int width, int height) {
                this.button.setPosition(x, 0);
                this.button.setSize(width, height);
            }
        }

        public static class Text
        extends Entry {
            public Text(int x, int width, int height, Component message, @Nullable Tooltip tooltip, int tooltipDelay) {
                Object widget = Minecraft.getInstance().font.width(message.getString()) <= width ? new StringWidget(x, 0, width, height, message, Minecraft.getInstance().font) : new MultiLineTextWidget(x, 0, message, Minecraft.getInstance().font).setMaxWidth(width).setCentered(true);
                if (tooltip != null) {
                    widget.setTooltip(tooltip);
                }
                if (tooltipDelay >= 0) {
                    widget.setTooltipDelay(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(widget);
            }
        }
    }
}

