/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.EditScreen;
import dev.terminalmc.commandkeys.gui.screen.MainOptionScreen;
import dev.terminalmc.commandkeys.mixin.accessor.ChatScreenAccessor;
import dev.terminalmc.commandkeys.util.Localization;
import dev.terminalmc.commandkeys.util.ModLogger;
import dev.terminalmc.commandkeys.util.PlaceholderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class CommandKeys {
    public static final String MOD_ID = "commandkeys";
    public static final String MOD_NAME = "CommandKeys";
    public static final ModLogger LOG = new ModLogger("CommandKeys");
    public static final Component PREFIX = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"CommandKeys").m_130940_(ChatFormatting.DARK_AQUA)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_130940_(ChatFormatting.GRAY);
    public static final KeyMapping CONFIG_KEY = new KeyMapping(Localization.translationKey("key", "main.edit"), InputConstants.Type.KEYSYM, 75, Localization.translationKey("key", "main"));
    public static final List<KeyMapping> KEYBINDS = List.of(CONFIG_KEY);
    public static boolean hasResetConfig = false;
    public static String lastConnection = "";
    @Nullable
    public static InputConstants.Key ratelimitedKey = null;
    private static final List<TickCounter> rateLimiter = new ArrayList<TickCounter>();

    public static void init() {
        Config.getAndSave();
    }

    public static void afterClientTick(Minecraft mc) {
        while (CONFIG_KEY.m_90859_()) {
            mc.m_91152_((Screen)new MainOptionScreen(mc.f_91080_, true));
        }
        rateLimiter.removeIf(tc -> tc.tick() > Config.get().getRatelimitTicks());
        if (mc.f_91074_ != null && mc.f_91073_ != null && !mc.m_91104_()) {
            Config.get().activeProfile().getMacros().forEach(Macro::tick);
        }
        if (hasResetConfig && mc.f_91080_ instanceof TitleScreen) {
            hasResetConfig = false;
            mc.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.UNSECURE_SERVER_WARNING, (Component)Localization.localized("toast", "reset.title", new Object[0]), (Component)Localization.localized("toast", "reset.message", Component.m_237113_((String)"commandkeys.unreadable.json").m_130940_(ChatFormatting.GOLD))));
        }
    }

    public static void onConfigSaved(Config config) {
    }

    public static Profile profile() {
        return Config.get().activeProfile();
    }

    public static Screen getConfigScreen(Screen lastScreen) {
        return new MainOptionScreen(lastScreen, CommandKeys.inGame());
    }

    public static boolean inGame() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && player.f_108617_.m_104910_().m_129536_();
    }

    public static boolean inSingleplayer() {
        return Minecraft.m_91087_().m_91092_() != null;
    }

    public static boolean canTrigger(InputConstants.Key key, boolean sendMessage) {
        if ((!CommandKeys.inSingleplayer() || Config.get().ratelimitSp) && rateLimiter.size() >= Config.get().getRatelimitCount()) {
            if (sendMessage && ratelimitedKey != key) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)PREFIX.m_6881_().m_7220_((Component)Localization.localized("message", "blocked.ratelimit", key.m_84875_().m_6881_().m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)String.valueOf(Config.get().getRatelimitCount())).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)String.valueOf(Config.get().getRatelimitTicks())).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.RED)));
                ratelimitedKey = key;
            }
            if (Config.getAndSave().ratelimitStrict) {
                rateLimiter.add(new TickCounter());
            }
            return false;
        }
        rateLimiter.add(new TickCounter());
        return true;
    }

    public static void send(String message, boolean addToHistory, boolean showHudMsg) {
        CommandKeys.send(message, false, false, addToHistory, showHudMsg);
    }

    public static void type(String message) {
        CommandKeys.send(message, true, false, false, false);
    }

    public static void edit(String message) {
        CommandKeys.send(message, false, true, false, false);
    }

    public static void send(String message, boolean type, boolean edit, boolean addToHistory, boolean showHudMsg) {
        ratelimitedKey = null;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!mc.f_91074_.f_108617_.m_6198_()) {
            return;
        }
        Pair<String, Integer> result = PlaceholderUtil.replace(message);
        message = (String)result.getFirst();
        int faults = (Integer)result.getSecond();
        if (faults == 0) {
            if (edit) {
                String finalMessage = message;
                mc.m_91152_((Screen)new EditScreen(str -> CommandKeys.send(type, finalMessage.replaceAll("%edit%", (String)str), addToHistory, showHudMsg)));
            } else {
                CommandKeys.send(type, message, addToHistory, showHudMsg);
            }
        } else {
            MutableComponent msg = PREFIX.m_6881_();
            msg.m_7220_((Component)Localization.localized("message", "placeholderFault", Component.m_237113_((String)message).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.RED));
            mc.f_91065_.m_93076_().m_93785_((Component)msg);
        }
    }

    private static void send(boolean type, String message, boolean addToHistory, boolean showHudMsg) {
        Minecraft mc = Minecraft.m_91087_();
        if (type) {
            EditBox input;
            ChatScreen screen = new ChatScreen(message);
            mc.m_91152_((Screen)screen);
            int index = message.indexOf("%edit%");
            if (index != -1 && (input = ((ChatScreenAccessor)screen).commandkeys$getInput()) != null) {
                input.m_94196_(index + "%edit%".length());
                input.m_94208_(index + "%edit%".length());
                input.m_94196_(index);
            }
        } else if (message.length() > Config.get().getLengthLimitLength()) {
            MutableComponent msg = PREFIX.m_6881_();
            msg.m_7220_((Component)Localization.localized("message", "blocked.lengthlimit", Component.m_237113_((String)String.valueOf(message.length())).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)String.valueOf(Config.get().getLengthLimitLength())).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.RED));
            mc.f_91065_.m_93076_().m_93785_((Component)msg);
        } else {
            if (message.startsWith("/")) {
                mc.f_91074_.f_108617_.m_246623_(message.substring(1));
            } else {
                mc.f_91074_.f_108617_.m_246175_(message);
            }
            if (addToHistory) {
                mc.f_91065_.m_93076_().m_93783_(message);
            }
            if (showHudMsg) {
                mc.f_91065_.m_93063_((Component)Component.m_237113_((String)message).m_130940_(ChatFormatting.GRAY), false);
            }
        }
    }

    private static class TickCounter {
        int time = 0;

        private TickCounter() {
        }

        int tick() {
            return this.time++;
        }
    }
}

