/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.platform.Services;
import dev.terminalmc.commandkeys.util.JsonUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    public static final int VERSION = 6;
    public final int version = 6;
    private static final Path CONFIG_DIR = Services.PLATFORM.getConfigDir();
    public static final String FILE_NAME = "commandkeys.json";
    public static final String UNREADABLE_FILE_NAME = "commandkeys.unreadable.json";
    public static final String OLD_FILE_NAME = "commandkeys.old.json";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Config.class, (Object)new Deserializer()).registerTypeAdapter(Profile.class, (Object)new Profile.Deserializer()).registerTypeAdapter(Macro.class, (Object)new Macro.Deserializer()).registerTypeAdapter(Keybind.class, (Object)new Keybind.Deserializer()).registerTypeAdapter(Message.class, (Object)new Message.Deserializer()).setPrettyPrinting().create();
    private final List<Profile> profiles;
    private static final Supplier<List<Profile>> profilesDefault = () -> new ArrayList<Profile>(List.of(new Profile("Default Profile")));
    private int spDefault;
    private int mpDefault;
    public static final int defaultIndexDefault = 0;
    public Macro.ConflictStrategy defaultConflictStrategy;
    public Macro.SendMode defaultSendMode;
    public Macro.ActivationType defaultActivationType;
    private int ratelimitCount;
    public static final int ratelimitCountDefault = 4;
    private int ratelimitTicks;
    public static final int ratelimitTicksDefault = 20;
    public boolean ratelimitStrict;
    public static final boolean ratelimitStrictDefault = false;
    public boolean ratelimitSp;
    public static final boolean ratelimitSpDefault = false;
    private int lengthLimitLength;
    public static final int lengthLimitLengthDefault = 256;
    private static Config instance = null;

    public Config() {
        this(profilesDefault.get(), 0, 0, Macro.conflictStrategyDefault, Macro.sendModeDefault, Macro.activationTypeDefault, 4, 20, false, false, 256);
    }

    private Config(List<Profile> profiles, int spDefault, int mpDefault, Macro.ConflictStrategy defaultConflictStrategy, Macro.SendMode defaultSendMode, Macro.ActivationType defaultActivationType, int ratelimitCount, int ratelimitTicks, boolean ratelimitStrict, boolean ratelimitSp, int lengthLimitLength) {
        this.profiles = profiles;
        this.spDefault = spDefault;
        this.mpDefault = mpDefault;
        this.defaultConflictStrategy = defaultConflictStrategy;
        this.defaultSendMode = defaultSendMode;
        this.defaultActivationType = defaultActivationType;
        this.ratelimitCount = ratelimitCount;
        this.ratelimitTicks = ratelimitTicks;
        this.ratelimitStrict = ratelimitStrict;
        this.ratelimitSp = ratelimitSp;
        this.lengthLimitLength = lengthLimitLength;
    }

    public int getSpDefault() {
        return this.spDefault;
    }

    public void setSpDefault(int index) {
        if (index < 0 || index >= this.profiles.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        this.spDefault = index;
    }

    public int getMpDefault() {
        return this.mpDefault;
    }

    public void setMpDefault(int index) {
        if (this.spDefault < 0 || this.spDefault >= this.profiles.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        this.mpDefault = index;
    }

    public int getRatelimitCount() {
        return this.ratelimitCount;
    }

    public void setRatelimitCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException();
        }
        this.ratelimitCount = count;
    }

    public int getRatelimitTicks() {
        return this.ratelimitTicks;
    }

    public void setRatelimitTicks(int ticks) {
        if (ticks < 1) {
            throw new IllegalArgumentException();
        }
        this.ratelimitTicks = ticks;
    }

    public int getLengthLimitLength() {
        return this.lengthLimitLength;
    }

    public void setLengthLimitLength(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        this.lengthLimitLength = length;
    }

    public Profile activeProfile() {
        return this.profiles.get(0);
    }

    public void activateProfile(int index) {
        this.profiles.get(0).getMacros().forEach(macro -> {
            if (!macro.resumeRepeatingStatus) {
                macro.deactivate();
            }
        });
        if (index != 0) {
            this.profiles.add(0, this.profiles.remove(index));
            if (index == this.spDefault) {
                this.spDefault = 0;
            } else if (index > this.spDefault) {
                ++this.spDefault;
            }
            if (index == this.mpDefault) {
                this.mpDefault = 0;
            } else if (index > this.mpDefault) {
                ++this.mpDefault;
            }
        }
    }

    public void activateSpProfile(String levelId) {
        Profile profile = Profile.LINK_PROFILE_MAP.getOrDefault(levelId, null);
        if (profile != null) {
            this.activateProfile(this.profiles.indexOf(profile));
        } else {
            this.activateProfile(this.spDefault);
        }
    }

    public void activateMpProfile(String address) {
        Profile profile = Profile.LINK_PROFILE_MAP.getOrDefault(address, null);
        if (profile != null) {
            this.activateProfile(this.profiles.indexOf(profile));
        } else {
            this.activateProfile(this.mpDefault);
        }
    }

    public List<Profile> getProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public void addCopyProfile(Profile profile) {
        Profile copy = new Profile(profile);
        this.profiles.add(copy);
    }

    public Profile addNewProfile() {
        Profile profile = new Profile();
        this.profiles.add(profile);
        return profile;
    }

    public void removeProfile(int index) {
        Profile profile = this.profiles.remove(index);
        profile.getLinks().forEach(Profile.LINK_PROFILE_MAP::remove);
        if (index < this.spDefault) {
            --this.spDefault;
        }
        if (index < this.mpDefault) {
            --this.mpDefault;
        }
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    public static Config reload() {
        instance = null;
        Profile.LINK_PROFILE_MAP.clear();
        return Config.get();
    }

    @NotNull
    public static Config load() {
        Path file = CONFIG_DIR.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0])) {
            JsonUtil.reset();
            config = Config.load(file, GSON);
            if (config == null) {
                Config.backup(UNREADABLE_FILE_NAME);
                CommandKeys.LOG.warn("Resetting config", new Object[0]);
                CommandKeys.hasResetConfig = true;
            } else if (JsonUtil.hasChanged) {
                Config.backup(OLD_FILE_NAME);
            }
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CommandKeys.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup(String path) {
        try {
            CommandKeys.LOG.warn("Copying {} to {}", FILE_NAME, path);
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(path);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            CommandKeys.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            CommandKeys.onConfigSaved(instance);
        }
        catch (IOException e) {
            CommandKeys.LOG.error("Unable to save config", e);
        }
    }

    private Config validate() {
        this.profiles.forEach(Profile::validate);
        if (this.profiles.isEmpty()) {
            this.profiles.addAll((Collection<Profile>)profilesDefault.get());
        }
        if (this.spDefault < 0 || this.spDefault >= this.profiles.size()) {
            this.spDefault = 0;
        }
        if (this.mpDefault < 0 || this.mpDefault >= this.profiles.size()) {
            this.mpDefault = 0;
        }
        if (this.ratelimitCount < 1) {
            this.ratelimitCount = 4;
        }
        if (this.ratelimitTicks < 1) {
            this.ratelimitTicks = 20;
        }
        if (this.lengthLimitLength < 1) {
            this.lengthLimitLength = 256;
        }
        return this;
    }

    public static class Deserializer
    implements JsonDeserializer<Config> {
        public Config deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.has("version") ? obj.get("version").getAsInt() : 0;
            boolean silent = version != 6;
            List<Profile> profiles = JsonUtil.getOrDefault(ctx, obj, "profiles", Profile.class, profilesDefault.get(), silent);
            int spDefault = JsonUtil.getOrDefault(obj, "spDefault", 0, silent);
            int mpDefault = JsonUtil.getOrDefault(obj, "mpDefault", 0, silent);
            Macro.ConflictStrategy defaultConflictStrategy = JsonUtil.getOrDefault(obj, "defaultConflictStrategy", Macro.ConflictStrategy.class, Macro.conflictStrategyDefault, silent);
            Macro.SendMode defaultSendMode = JsonUtil.getOrDefault(obj, "defaultSendMode", Macro.SendMode.class, Macro.sendModeDefault, silent);
            Macro.ActivationType defaultActivationType = JsonUtil.getOrDefault(obj, "defaultActivationType", Macro.ActivationType.class, Macro.activationTypeDefault, silent);
            int ratelimitCount = JsonUtil.getOrDefault(obj, "ratelimitCount", 4, silent);
            int ratelimitTicks = JsonUtil.getOrDefault(obj, "ratelimitTicks", 20, silent);
            boolean ratelimitStrict = JsonUtil.getOrDefault(obj, "ratelimitStrict", false, silent);
            boolean ratelimitSp = JsonUtil.getOrDefault(obj, "ratelimitSp", false, silent);
            int lengthLimitLength = JsonUtil.getOrDefault(obj, "lengthLimitLength", 256, silent);
            return new Config(profiles, spDefault, mpDefault, defaultConflictStrategy, defaultSendMode, defaultActivationType, ratelimitCount, ratelimitTicks, ratelimitStrict, ratelimitSp, lengthLimitLength).validate();
        }
    }
}

