/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;

public class Keybind {
    public static final int VERSION = 0;
    public final int version = 0;
    private String keyName;
    private transient InputConstants.Key key;
    private String limitKeyName;
    private transient InputConstants.Key limitKey;

    public Keybind() {
        this(InputConstants.f_84822_, InputConstants.f_84822_);
    }

    Keybind(InputConstants.Key key, InputConstants.Key limitKey) {
        this.key = key;
        this.keyName = key.m_84874_();
        this.limitKey = limitKey;
        this.limitKeyName = limitKey.m_84874_();
    }

    Keybind(Keybind keybind) {
        this.key = keybind.key;
        this.keyName = keybind.keyName;
        this.limitKey = keybind.limitKey;
        this.limitKeyName = keybind.limitKeyName;
    }

    public InputConstants.Key getKey() {
        return this.key;
    }

    void setKey(InputConstants.Key key) {
        this.key = key;
        this.keyName = key.m_84874_();
    }

    public InputConstants.Key getLimitKey() {
        return this.limitKey;
    }

    void setLimitKey(InputConstants.Key limitKey) {
        this.limitKey = limitKey;
        this.limitKeyName = limitKey.m_84874_();
    }

    public boolean isKeyDown() {
        return Keybind.isKeyDown(this.key);
    }

    public boolean isLimitKeyDown() {
        return Keybind.isKeyDown(this.limitKey);
    }

    public static boolean isKeyDown(InputConstants.Key key) {
        if (key.equals((Object)InputConstants.f_84822_)) {
            return false;
        }
        if (key.m_84868_().equals((Object)InputConstants.Type.MOUSE)) {
            return GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_()) == 1;
        }
        return GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_()) == 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Keybind)) {
            return false;
        }
        Keybind keybind = (Keybind)other;
        return this.key.equals((Object)keybind.key) && this.limitKey.equals((Object)keybind.limitKey);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.limitKey);
    }

    Keybind validate() {
        if (this.key.equals((Object)InputConstants.f_84822_) && !this.limitKey.equals((Object)InputConstants.f_84822_)) {
            this.limitKey = InputConstants.f_84822_;
        }
        this.keyName = this.key.m_84874_();
        this.limitKeyName = this.limitKey.m_84874_();
        return this;
    }

    public static class Deserializer
    implements JsonDeserializer<Keybind> {
        public Keybind deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 0;
            InputConstants.Key key = JsonUtil.getOrDefault(obj, "keyName", InputConstants.f_84822_, silent);
            InputConstants.Key limitKey = JsonUtil.getOrDefault(obj, "limitKeyName", InputConstants.f_84822_, silent);
            return new Keybind(key, limitKey).validate();
        }
    }
}

