/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Profile {
    public static final int VERSION = 4;
    public final int version = 4;
    public static final Map<String, Profile> LINK_PROFILE_MAP = new HashMap<String, Profile>();
    public final transient Multimap<InputConstants.Key, Keybind> keybindMap = LinkedHashMultimap.create();
    public final transient Multimap<Keybind, Macro> macroMap = LinkedHashMultimap.create();
    public String name;
    public static final String nameDefault = "";
    private final List<String> links;
    public static final Supplier<List<String>> linksDefault = ArrayList::new;
    private Control addToHistory;
    public static final Control addToHistoryDefault = Control.OFF;
    private Control showHudMessage;
    public static final Control showHudMessageDefault = Control.OFF;
    private Control resumeRepeating;
    public static final Control resumeRepeatingDefault = Control.OFF;
    private Control useRatelimit;
    public static final Control useRatelimitDefault = Control.ON;
    private final List<Macro> macros;
    public static final Supplier<List<Macro>> macrosDefault = ArrayList::new;

    public Profile() {
        this(nameDefault);
    }

    public Profile(String name) {
        this(name, linksDefault.get(), addToHistoryDefault, showHudMessageDefault, resumeRepeatingDefault, useRatelimitDefault, macrosDefault.get());
    }

    private Profile(String name, List<String> links, Control addToHistory, Control showHudMessage, Control resumeRepeating, Control useRatelimit, List<Macro> macros) {
        this.name = name;
        this.links = links;
        this.addToHistory = addToHistory;
        this.showHudMessage = showHudMessage;
        this.resumeRepeating = resumeRepeating;
        this.useRatelimit = useRatelimit;
        this.macros = macros;
        this.links.removeIf(link -> LINK_PROFILE_MAP.putIfAbsent((String)link, this) != null);
    }

    Profile(Profile profile) {
        this.name = profile.getDisplayName() + " (Copy)";
        this.links = linksDefault.get();
        this.addToHistory = profile.addToHistory;
        this.showHudMessage = profile.showHudMessage;
        this.resumeRepeating = profile.resumeRepeating;
        this.useRatelimit = profile.useRatelimit;
        this.macros = profile.macros.stream().map(Macro::new).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getDisplayName() {
        String name = this.name;
        if (name.isBlank()) {
            name = this.getLinks().stream().findFirst().orElse(nameDefault);
        }
        if (name.isBlank()) {
            name = "[Unnamed]";
        }
        return name;
    }

    public List<String> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void forceAddLink(String link) {
        if (LINK_PROFILE_MAP.containsKey(link)) {
            LINK_PROFILE_MAP.get(link).removeLink(link);
        }
        this.links.add(link);
        LINK_PROFILE_MAP.put(link, this);
    }

    public void removeLink(String link) {
        this.links.remove(link);
        LINK_PROFILE_MAP.remove(link);
    }

    public Control getAddToHistory() {
        return this.addToHistory;
    }

    public void setAddToHistory(Control addToHistory) {
        this.addToHistory = addToHistory;
        this.macros.forEach(macro -> this.setAddToHistory((Macro)macro, macro.addToHistory));
    }

    public void setAddToHistory(Macro macro, boolean value) {
        macro.addToHistory = value;
        macro.addToHistoryStatus = switch (this.addToHistory) {
            default -> throw new IncompatibleClassChangeError();
            case Control.ON -> true;
            case Control.OFF -> false;
            case Control.DEFER -> macro.addToHistory;
        };
    }

    public Control getShowHudMessage() {
        return this.showHudMessage;
    }

    public void setShowHudMessage(Control showHudMessage) {
        this.showHudMessage = showHudMessage;
        this.macros.forEach(macro -> this.setShowHudMessage((Macro)macro, macro.showHudMessage));
    }

    public void setShowHudMessage(Macro macro, boolean value) {
        macro.showHudMessage = value;
        macro.showHudMessageStatus = switch (this.showHudMessage) {
            default -> throw new IncompatibleClassChangeError();
            case Control.ON -> true;
            case Control.OFF -> false;
            case Control.DEFER -> macro.showHudMessage;
        };
    }

    public Control getResumeRepeating() {
        return this.resumeRepeating;
    }

    public void setResumeRepeating(Control resumeRepeating) {
        this.resumeRepeating = resumeRepeating;
        this.macros.forEach(macro -> this.setResumeRepeating((Macro)macro, macro.resumeRepeating));
    }

    public void setResumeRepeating(Macro macro, boolean value) {
        macro.resumeRepeating = value;
        macro.resumeRepeatingStatus = switch (this.resumeRepeating) {
            default -> throw new IncompatibleClassChangeError();
            case Control.ON -> true;
            case Control.OFF -> false;
            case Control.DEFER -> macro.resumeRepeating;
        };
    }

    public Control getUseRatelimit() {
        return this.useRatelimit;
    }

    public void setUseRatelimit(Control useRatelimit) {
        this.useRatelimit = useRatelimit;
        this.macros.forEach(macro -> this.setUseRatelimit((Macro)macro, macro.useRatelimit));
    }

    public void setUseRatelimit(Macro macro, boolean value) {
        macro.useRatelimit = value;
        macro.useRatelimitStatus = switch (this.useRatelimit) {
            default -> throw new IncompatibleClassChangeError();
            case Control.ON -> true;
            case Control.OFF -> false;
            case Control.DEFER -> macro.useRatelimit;
        };
    }

    public List<Macro> getMacros() {
        return Collections.unmodifiableList(this.macros);
    }

    public void addMacro(Macro macro) {
        this.macros.add(macro);
        this.addToMaps(macro);
    }

    public void removeMacro(Macro macro) {
        this.macros.remove(macro);
        this.rebuildMaps();
    }

    public boolean moveMacro(int sourceIndex, int destIndex) {
        if (sourceIndex != destIndex) {
            this.macros.add(destIndex, this.macros.remove(sourceIndex));
            this.rebuildMaps();
            return true;
        }
        return false;
    }

    public void addToMaps(Macro macro) {
        this.keybindMap.put((Object)macro.keybind.getKey(), (Object)macro.keybind);
        this.macroMap.put((Object)macro.keybind, (Object)macro);
        if (macro.usesAltKeybind()) {
            this.keybindMap.put((Object)macro.altKeybind.getKey(), (Object)macro.altKeybind);
            this.macroMap.put((Object)macro.altKeybind, (Object)macro);
        }
    }

    public void rebuildMaps() {
        this.keybindMap.clear();
        this.macroMap.clear();
        for (Macro macro : this.macros) {
            this.addToMaps(macro);
        }
    }

    public void setConflictStrategy(Macro macro, Macro.ConflictStrategy conflictStrategy) {
        if (conflictStrategy.equals((Object)macro.conflictStrategy)) {
            return;
        }
        macro.deactivateAndCancel();
        macro.conflictStrategy = conflictStrategy;
    }

    public void setSendMode(Macro macro, Macro.SendMode sendMode) {
        if (sendMode.equals((Object)macro.sendMode)) {
            return;
        }
        macro.deactivateAndCancel();
        macro.sendMode = sendMode;
        this.rebuildMaps();
    }

    public void setActivationType(Macro macro, Macro.ActivationType activationType) {
        if (activationType.equals((Object)macro.activationType)) {
            return;
        }
        macro.deactivateAndCancel();
        macro.activationType = activationType;
    }

    public void setKey(Macro macro, Keybind keybind, InputConstants.Key key) {
        if (key.equals((Object)keybind.getKey())) {
            return;
        }
        if (keybind == macro.keybind || keybind == macro.altKeybind) {
            macro.deactivateAndCancel();
            keybind.setKey(key);
            this.rebuildMaps();
        }
    }

    public void setLimitKey(Macro macro, Keybind keybind, InputConstants.Key limitKey) {
        if (limitKey.equals((Object)keybind.getLimitKey())) {
            return;
        }
        if (keybind == macro.keybind || keybind == macro.altKeybind) {
            macro.deactivateAndCancel();
            keybind.setLimitKey(limitKey);
            this.rebuildMaps();
        }
    }

    Profile validate() {
        this.macros.forEach(Macro::validate);
        this.macros.removeIf(macro -> macro.messages.isEmpty());
        this.setAddToHistory(this.addToHistory);
        this.setShowHudMessage(this.showHudMessage);
        this.setResumeRepeating(this.resumeRepeating);
        this.setUseRatelimit(this.useRatelimit);
        this.rebuildMaps();
        return this;
    }

    public static enum Control {
        ON,
        OFF,
        DEFER;

    }

    public static class Deserializer
    implements JsonDeserializer<Profile> {
        public Profile deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.has("version") ? obj.get("version").getAsInt() : 0;
            boolean silent = version != 4;
            String name = JsonUtil.getOrDefault(obj, "name", Profile.nameDefault, silent);
            List<String> links = version >= 3 ? JsonUtil.getOrDefault(obj, "links", linksDefault.get(), silent) : JsonUtil.getOrDefault(obj, "addresses", linksDefault.get(), true);
            Control addToHistory = JsonUtil.getOrDefault(obj, "addToHistory", Control.class, addToHistoryDefault, silent);
            Control showHudMessage = JsonUtil.getOrDefault(obj, "showHudMessage", Control.class, showHudMessageDefault, silent);
            Control resumeRepeating = JsonUtil.getOrDefault(obj, "resumeRepeating", Control.class, resumeRepeatingDefault, silent);
            Control useRatelimit = JsonUtil.getOrDefault(obj, "useRatelimit", Control.class, useRatelimitDefault, silent);
            List<Macro> macros = version >= 2 ? JsonUtil.getOrDefault(ctx, obj, "macros", Macro.class, macrosDefault.get(), silent) : JsonUtil.getOrDefault(ctx, obj, "commandKeys", Macro.class, macrosDefault.get(), true);
            return new Profile(name, links, addToHistory, showHudMessage, resumeRepeating, useRatelimit, macros).validate();
        }
    }
}

