/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class OptionScreen
extends OptionsSubScreen {
    public static final int HEADER_MARGIN = 32;
    public static final int FOOTER_MARGIN = 32;
    public static final int BASE_ROW_WIDTH = 320;
    public static final int SCROLL_BAR_MARGIN = 20;
    public static final int ELEMENT_SPACING = 4;
    public static final int ELEMENT_SPACING_NARROW = 2;
    public static final int ELEMENT_SPACING_FINE = 1;
    public static final int LIST_ENTRY_HEIGHT = 20;
    public static final int LIST_ENTRY_SPACING = 5;
    public static final int HANGING_WIDGET_MARGIN = 24;
    public static final int BASE_LIST_ENTRY_WIDTH = 232;
    protected OptionList list;

    public OptionScreen(Screen lastScreen, Component title, OptionList list) {
        super(lastScreen, Minecraft.m_91087_().f_91066_, title);
        this.list = list;
        this.list.setScreen(this);
    }

    protected void m_7856_() {
        this.m_169413_();
        this.m_264131_();
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.setInitialFocus();
    }

    public void m_6574_(@NotNull Minecraft mc, int width, int height) {
        this.f_96543_ = width;
        this.f_96544_ = height;
        this.m_7856_();
    }

    protected void addTitle() {
        Font font = Minecraft.m_91087_().f_91062_;
        int w = font.m_92852_((FormattedText)this.f_96539_);
        Objects.requireNonNull(font);
        int h = 9;
        int x = this.f_96543_ / 2 - w / 2;
        int y = Math.max(0, 16 - h / 2);
        this.m_142416_((GuiEventListener)new StringWidget(x, y, w, h, this.f_96539_, font).m_267769_());
    }

    protected void addContents() {
        this.list.m_93437_(this.f_96543_, this.f_96544_ - 32 - 32, 32, this.f_96544_ - 32);
        this.m_142416_((GuiEventListener)this.list);
    }

    protected void addFooter() {
        int w = 232;
        int h = 20;
        int x = this.f_96543_ / 2 - w / 2;
        int y = Math.min(this.f_96544_ - h, this.f_96544_ - 16 - h / 2);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252794_(x, y).m_253046_(w, h).m_253136_());
    }

    protected void m_264131_() {
        ComponentPath path = this.m_264435_();
        if (path != null) {
            path.m_264432_(false);
        }
    }

    protected void setInitialFocus() {
        FocusNavigationEvent.TabNavigation nav;
        ComponentPath path;
        if (Minecraft.m_91087_().m_264529_().m_264505_() && (path = super.m_264064_((FocusNavigationEvent)(nav = new FocusNavigationEvent.TabNavigation(true)))) != null) {
            this.m_264158_(path);
        }
    }

    public void m_7379_() {
        Screen screen = this.f_96281_;
        if (screen instanceof OptionScreen) {
            OptionScreen screen2 = (OptionScreen)screen;
            screen2.m_6574_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
        super.m_7379_();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280039_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public Screen getLastScreen() {
        return this.f_96281_;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.list.keyPressed(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.list.keyReleased(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int delta) {
        if (this.list.mouseClicked(InputConstants.Type.MOUSE.m_84895_(delta))) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, delta);
    }

    public boolean m_6348_(double mouseX, double mouseY, int delta) {
        if (this.list.mouseReleased(InputConstants.Type.MOUSE.m_84895_(delta))) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, delta);
    }
}

