/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.field;

import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.mixin.accessor.MultiLineEditBoxAccessor;
import dev.terminalmc.commandkeys.mixin.accessor.MultilineTextFieldAccessor;
import dev.terminalmc.commandkeys.mixin.accessor.StringViewAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLineTextField
extends MultiLineEditBox {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = 0xE0E0E0;
    public static final int TEXT_COLOR_ERROR = 0xFF5555;
    public final List<@NotNull TextField.Validator> validators = new ArrayList<TextField.Validator>();
    public boolean lenient = true;
    private int normalTextColor;
    private int currentTextColor = this.normalTextColor = 0xE0E0E0;
    @Nullable
    private Tooltip normalTooltip;
    @Nullable
    private Tooltip errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private long lastClickTime;
    private int chainedClicks;

    public MultiLineTextField(int x, int y, int width, int height) {
        this(Minecraft.m_91087_().f_91062_, x, y, width, height, (Component)Component.m_237119_(), (Component)Component.m_237119_(), null);
    }

    public MultiLineTextField(int x, int y, int width, int height, Component placeholder) {
        this(Minecraft.m_91087_().f_91062_, x, y, width, height, placeholder, (Component)Component.m_237119_(), null);
    }

    public MultiLineTextField(Font font, int x, int y, int width, int height, Component placeholder, Component message, @Nullable TextField.Validator validator) {
        super(font, x, y, width, height, placeholder, message);
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public MultiLineTextField withValidator(@NotNull TextField.Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public void m_239273_(@NotNull Consumer<String> responder) {
        super.m_239273_(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (TextField.Validator v : this.validators) {
            Optional<Component> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = Tooltip.m_257550_((Component)error.get());
            super.m_257544_(this.errorTooltip);
            this.currentTextColor = 0xFF5555;
            return false;
        }
        this.errorTooltip = null;
        this.currentTextColor = this.normalTextColor;
        super.m_257544_(this.normalTooltip);
        return true;
    }

    public void m_257544_(@Nullable Tooltip tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.m_257544_(tooltip);
        }
    }

    public int getTextColor() {
        return this.currentTextColor;
    }

    public void setTextColor(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            this.currentTextColor = color;
        }
    }

    public void m_93674_(int width) {
        super.m_93674_(width);
        ((MultilineTextFieldAccessor)((MultiLineEditBoxAccessor)((Object)this)).commandkeys$getTextField()).commandkeys$setWidth(width);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            long time = Util.m_137550_();
            if (this.lastClickTime + 250L > time) {
                MultilineTextField field = ((MultiLineEditBoxAccessor)((Object)this)).commandkeys$getTextField();
                MultilineTextFieldAccessor fieldAcc = (MultilineTextFieldAccessor)field;
                switch (++this.chainedClicks) {
                    case 1: {
                        field.m_239797_(Whence.ABSOLUTE, ((StringViewAccessor)field.m_239361_()).commandkeys$getBeginIndex());
                        int pos = fieldAcc.commandkeys$getCursor();
                        field.m_239797_(Whence.ABSOLUTE, ((StringViewAccessor)field.m_239637_()).commandkeys$getBeginIndex());
                        fieldAcc.commandkeys$setSelectCursor(pos);
                        break;
                    }
                    case 2: 
                    case 3: {
                        fieldAcc.commandkeys$setCursor(this.m_239249_().length());
                        fieldAcc.commandkeys$setSelectCursor(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        fieldAcc.commandkeys$setSelectCursor(fieldAcc.commandkeys$getCursor());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            return true;
        }
        return false;
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1 && this.history.size() > this.historyIndex + 1) {
                this.history.subList(this.historyIndex + 1, this.history.size()).clear();
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!super.m_7933_(keyCode, scanCode, modifiers)) {
            if (TextField.isUndo(keyCode)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(keyCode)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.m_240159_(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.m_240159_(this.history.get(++this.historyIndex));
        }
    }
}

