/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.field;

import dev.terminalmc.commandkeys.mixin.accessor.EditBoxAccessor;
import dev.terminalmc.commandkeys.util.Localization;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextField
extends EditBox {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = 0xE0E0E0;
    public static final int TEXT_COLOR_ERROR = 0xFF5555;
    public static final int TEXT_COLOR_HINT = 0x555555;
    public static final int TEXT_COLOR_PREVIEW = 0xAAAAAA;
    private final Font font;
    public final List<@NotNull Validator> validators = new ArrayList<Validator>();
    public boolean lenient = true;
    private int normalTextColor = 0xE0E0E0;
    @Nullable
    private Tooltip normalTooltip;
    @Nullable
    private Tooltip errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private double dragOriginX;
    private int dragOriginPos;
    private long lastClickTime;
    private int chainedClicks;

    public TextField(int x, int y, int width, int height) {
        this(Minecraft.m_91087_().f_91062_, x, y, width, height, (Component)Component.m_237119_(), null);
    }

    public TextField(int x, int y, int width, int height, @Nullable Validator validator) {
        this(Minecraft.m_91087_().f_91062_, x, y, width, height, (Component)Component.m_237119_(), validator);
    }

    public TextField(Font font, int x, int y, int width, int height, Component msg, @Nullable Validator validator) {
        super(font, x, y, width, height, msg);
        this.font = font;
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public TextField withValidator(@NotNull Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public TextField posIntValidator() {
        this.validators.add(new Validator.PosInt());
        return this;
    }

    public TextField strict() {
        this.lenient = false;
        return this;
    }

    public TextField lenient() {
        this.lenient = true;
        return this;
    }

    public void m_94151_(@NotNull Consumer<String> responder) {
        super.m_94151_(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (Validator v : this.validators) {
            Optional<Component> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = Tooltip.m_257550_((Component)error.get());
            super.m_257544_(this.errorTooltip);
            super.m_94202_(0xFF5555);
            return false;
        }
        this.errorTooltip = null;
        super.m_94202_(this.normalTextColor);
        super.m_257544_(this.normalTooltip);
        return true;
    }

    public void m_257771_(@NotNull Component hint) {
        super.m_257771_((Component)hint.m_6881_().m_130948_(Style.f_131099_.m_178520_(0x555555)));
    }

    public void m_257544_(@Nullable Tooltip tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.m_257544_(tooltip);
        }
    }

    public void m_94202_(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            super.m_94202_(color);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            long time = Util.m_137550_();
            if (this.lastClickTime + 250L > time) {
                switch (++this.chainedClicks) {
                    case 1: {
                        int pos;
                        int start = pos = this.m_94207_();
                        if (pos < 0) {
                            start = 0;
                        } else if (pos >= this.m_94155_().length() || this.m_94155_().charAt(pos) == ' ' || pos > 0 && this.m_94155_().charAt(pos - 1) != ' ') {
                            start = this.m_94184_(-1);
                        }
                        int end = this.m_94184_(1);
                        this.moveCursorTo(start, false);
                        this.moveCursorTo(end, true);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.moveCursorToEnd(false);
                        this.m_94208_(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        this.m_94208_(this.m_94207_());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            this.dragOriginX = mouseX;
            this.dragOriginPos = this.m_94207_();
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return false;
        }
        String str = this.m_94155_();
        if (mouseX < this.dragOriginX) {
            String subLeft = str.substring(0, this.dragOriginPos);
            int offsetChars = this.font.m_92837_(subLeft, Mth.m_14107_((double)(this.dragOriginX - mouseX)), true).length();
            this.moveCursorTo(this.dragOriginPos - offsetChars, true);
        } else {
            String subRight = str.substring(this.dragOriginPos);
            int offsetChars = this.font.m_92837_(subRight, Mth.m_14107_((double)(mouseX - this.dragOriginX)), false).length();
            this.moveCursorTo(this.dragOriginPos + offsetChars, true);
        }
        return true;
    }

    public void moveCursorTo(int delta, boolean select) {
        this.m_94196_(delta);
        if (!select) {
            this.m_94208_(this.m_94207_());
        }
        this.m_94174_(((EditBoxAccessor)((Object)this)).commandkeys$getValue());
    }

    public void moveCursorToEnd(boolean select) {
        this.moveCursorTo(((EditBoxAccessor)((Object)this)).commandkeys$getValue().length(), select);
    }

    private void m_94174_(String newText) {
        if (((EditBoxAccessor)((Object)this)).commandkeys$getResponder() != null) {
            ((EditBoxAccessor)((Object)this)).commandkeys$getResponder().accept(newText);
        }
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1 && this.history.size() > this.historyIndex + 1) {
                this.history.subList(this.historyIndex + 1, this.history.size()).clear();
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!super.m_7933_(keyCode, scanCode, modifiers)) {
            if (TextField.isUndo(keyCode)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(keyCode)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.m_94144_(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.m_94144_(this.history.get(++this.historyIndex));
        }
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 90 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    @FunctionalInterface
    public static interface Validator {
        public Optional<Component> validate(String var1);

        public static class PosInt
        implements Validator {
            @Override
            public Optional<Component> validate(String str) {
                try {
                    if (Integer.parseInt(str) < 0) {
                        throw new NumberFormatException();
                    }
                    return Optional.empty();
                }
                catch (NumberFormatException ignored) {
                    return Optional.of(Localization.localized("ui", "field.error.pos_int", new Object[0]).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }
}

