/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.widget.field.MultiLineTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class MacroOptionList
extends MacroBindList {
    private final Macro macro;
    private OptionList.Entry.ActionButton addMessageEntry;

    public MacroOptionList(Minecraft mc, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing, Profile profile, Macro macro) {
        super(mc, width, height, top, bottom, entryWidth, entryHeight, entrySpacing, profile, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(Entry.MessageOptions.class, macro::moveMessage)));
        this.macro = macro;
        this.addMessageEntry = new OptionList.Entry.ActionButton(this.entryX, entryWidth, entryHeight, (Component)Component.m_237113_((String)"+"), null, -1, button -> {
            macro.addMessage(new Message());
            this.init();
            this.m_93498_((AbstractSelectionList.Entry)this.addMessageEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.m_7085_((AbstractSelectionList.Entry)new Entry.DualKeybind(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, this.profile, this.macro));
        if (this.profile.getShowHudMessage().equals((Object)Profile.Control.DEFER) || this.profile.getAddToHistory().equals((Object)Profile.Control.DEFER) || this.profile.getResumeRepeating().equals((Object)Profile.Control.DEFER) || this.profile.getUseRatelimit().equals((Object)Profile.Control.DEFER)) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry.MacroControls(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this.profile, this.macro));
        }
        this.m_7085_((AbstractSelectionList.Entry)new Entry.MacroMode1(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, this.profile, this.macro));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.MacroMode2(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this.profile, this.macro));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "macro.messages", new Object[0]), null, -1));
        this.refreshMessageSubList();
        this.addMessageEntry.setBounds(this.dynEntryX, this.dynEntryWidth, this.entryHeight);
        this.m_7085_((AbstractSelectionList.Entry)this.addMessageEntry);
    }

    protected void refreshMessageSubList() {
        this.m_6702_().removeIf(entry -> entry instanceof Entry.MessageOptions);
        int start = this.m_6702_().indexOf((Object)this.addMessageEntry);
        start = start == -1 ? this.m_6702_().size() : --start;
        List<Message> messages = this.macro.getMessages();
        for (int i = messages.size() - 1; i >= 0; --i) {
            Message message = messages.get(i);
            Entry.MessageOptions msgEntry = new Entry.MessageOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.macro, message, i);
            this.m_6702_().add(start, new OptionList.Entry.Space(msgEntry));
            this.m_6702_().add(start, msgEntry);
        }
        this.m_93410_(this.m_93517_());
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class MessageOptions
        extends Entry {
            MessageOptions(int x, int width, int height, MacroOptionList list, Macro macro, Message msg, int index) {
                Font font = Minecraft.m_91087_().f_91062_;
                boolean showDelayField = macro.getStrategy() == Macro.ConflictStrategy.AVOID || macro.getMode() == Macro.SendMode.SEND && macro.spaceTicks == 0 || macro.getMode() == Macro.SendMode.REPEAT || macro.getMode() == Macro.SendMode.RANDOM || macro.getMode() == Macro.SendMode.CYCLE;
                int minDelayFieldWidth = font.m_92895_("0__") + 8;
                int msgFieldWidth = width - (showDelayField ? minDelayFieldWidth + 4 : 0);
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)"\u2191\u2193"), button -> {
                    this.m_7897_(true);
                    list.startDragging(this, null, false);
                }).m_252794_(x - list.smallWidgetWidth - 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
                MultiLineTextField messageField = new MultiLineTextField(x, 0, msgFieldWidth, height * 2);
                messageField.m_239313_(512);
                messageField.m_239273_(val -> {
                    msg.string = val.stripLeading();
                });
                messageField.m_240159_(msg.string);
                this.elements.add(messageField);
                if (showDelayField) {
                    TextField delayField = new TextField(x + width - minDelayFieldWidth, 0, minDelayFieldWidth, height).posIntValidator().strict();
                    delayField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "macro.delay.individual.tooltip" + (index == 0 ? ".first" : ".subsequent"), new Object[0])));
                    delayField.m_257427_(500);
                    delayField.m_94199_(8);
                    delayField.m_94151_(val -> {
                        int newWidth = Math.max(minDelayFieldWidth, font.m_92895_(val) + font.m_92895_("__") + 8);
                        int deltaWidth = delayField.m_5711_() - newWidth;
                        messageField.m_93674_(messageField.m_5711_() + deltaWidth);
                        delayField.m_252865_(delayField.m_252754_() + deltaWidth);
                        delayField.m_93674_(delayField.m_5711_() - deltaWidth);
                        try {
                            int delay = Integer.parseInt(val.strip());
                            if (delay < 0) {
                                throw new NumberFormatException();
                            }
                            msg.delayTicks = delay;
                            delayField.m_94202_(0xFFFFFF);
                        }
                        catch (NumberFormatException ignored) {
                            delayField.m_94202_(0xFF0000);
                        }
                    });
                    delayField.m_94144_(String.valueOf(msg.delayTicks));
                    delayField.m_94196_(0);
                    delayField.m_94208_(0);
                    this.elements.add(delayField);
                }
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.RED), button -> {
                    macro.removeMessage(index);
                    list.init();
                }).m_252794_(x + width + 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
            }
        }

        private static class MacroMode2
        extends Entry {
            MacroMode2(int x, int width, int height, Profile profile, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(CycleButton.m_168894_(Macro.ActivationType::title).m_168961_((Object[])Macro.ActivationType.values()).m_168948_((Object)macro.getActivationType()).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.activation", new Object[0]), (button, status) -> profile.setActivationType(macro, (Macro.ActivationType)((Object)status))));
                if (macro.getMode().equals((Object)Macro.SendMode.REPEAT)) {
                    TextField delayField = new TextField(x + width - buttonWidth, 0, buttonWidth, height).posIntValidator().strict();
                    delayField.m_94199_(8);
                    delayField.m_94151_(val -> {
                        macro.maxRepeats = Integer.parseInt(val.strip());
                    });
                    delayField.m_94144_(String.valueOf(macro.maxRepeats));
                    delayField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "macro.maxRepeats.tooltip", new Object[0])));
                    this.elements.add(delayField);
                }
            }
        }

        private static class MacroMode1
        extends Entry {
            private TextField delayField;

            MacroMode1(int x, int width, int height, MacroOptionList list, Profile profile, Macro macro) {
                Font font = Minecraft.m_91087_().f_91062_;
                int buttonWidth = (width - 4) / 2;
                int minDelayFieldWidth = font.m_92895_("0_") + 8;
                int modeButtonWidth = switch (macro.getMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Macro.SendMode.SEND, Macro.SendMode.REPEAT -> buttonWidth - minDelayFieldWidth;
                    case Macro.SendMode.TYPE, Macro.SendMode.RANDOM, Macro.SendMode.EDIT -> buttonWidth;
                    case Macro.SendMode.CYCLE -> buttonWidth - list.smallWidgetWidth;
                };
                this.elements.add(CycleButton.m_168894_(Macro.ConflictStrategy::title).m_168961_((Object[])Macro.ConflictStrategy.values()).m_168948_((Object)macro.getStrategy()).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.conflict", new Object[0]), (button, status) -> {
                    profile.setConflictStrategy(macro, (Macro.ConflictStrategy)((Object)status));
                    list.init();
                }));
                CycleButton modeButton = CycleButton.m_168894_(Macro.SendMode::title).m_168961_((Object[])Macro.SendMode.values()).m_168948_((Object)macro.getMode()).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(x + width - buttonWidth, 0, modeButtonWidth, height, (Component)Localization.localized("option", "macro.mode", new Object[0]), (button, status) -> {
                    profile.setSendMode(macro, (Macro.SendMode)((Object)status));
                    list.init();
                });
                this.elements.add(modeButton);
                if (macro.getMode().equals((Object)Macro.SendMode.CYCLE)) {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (int i = 0; i < macro.getMessages().size(); ++i) {
                        values.add(i);
                    }
                    if (values.isEmpty()) {
                        values.add(0);
                    }
                    if (macro.cycleIndex > (Integer)values.get(values.size() - 1)) {
                        macro.cycleIndex = 0;
                    }
                    this.elements.add(CycleButton.m_168894_(status -> Component.m_237113_((String)status.toString())).m_232502_(values).m_168948_((Object)macro.cycleIndex).m_168929_().m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.cycleIndex.tooltip", new Object[0]))).m_168936_(x + width - list.smallWidgetWidth, 0, list.smallWidgetWidth, height, (Component)Component.m_237119_(), (button, status) -> {
                        macro.cycleIndex = status;
                    }));
                } else if (macro.getMode().equals((Object)Macro.SendMode.SEND) || macro.getMode().equals((Object)Macro.SendMode.REPEAT)) {
                    this.delayField = new TextField(x + width - minDelayFieldWidth, 0, minDelayFieldWidth, height).posIntValidator().strict();
                    this.delayField.m_94199_(8);
                    this.delayField.m_94151_(arg_0 -> this.lambda$new$7(minDelayFieldWidth, font, (AbstractButton)modeButton, macro, list, arg_0));
                    this.delayField.m_94144_(String.valueOf(macro.spaceTicks));
                    this.delayField.m_94196_(0);
                    this.delayField.m_94208_(0);
                    this.delayField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "macro.delay.tooltip" + (macro.getMode().equals((Object)Macro.SendMode.REPEAT) ? ".repeat" : ""), new Object[0])));
                    this.elements.add(this.delayField);
                }
            }

            private /* synthetic */ void lambda$new$7(int minDelayFieldWidth, Font font, AbstractButton modeButton, Macro macro, MacroOptionList list, String val) {
                int newWidth = Math.max(minDelayFieldWidth, font.m_92895_(val) + font.m_92895_("_") + 8);
                int deltaWidth = this.delayField.m_5711_() - newWidth;
                modeButton.m_93674_(modeButton.m_5711_() + deltaWidth);
                this.delayField.m_252865_(this.delayField.m_252754_() + deltaWidth);
                this.delayField.m_93674_(this.delayField.m_5711_() - deltaWidth);
                int space = Integer.parseInt(val.strip());
                int oldSpace = macro.spaceTicks;
                macro.spaceTicks = space;
                if (macro.getMode() == Macro.SendMode.SEND && (space == 0 && oldSpace != 0 || space != 0 && oldSpace == 0)) {
                    list.refreshMessageSubList();
                }
            }
        }

        private static class MacroControls
        extends Entry {
            MacroControls(int x, int width, int height, Profile profile, Macro macro) {
                int buttonWidth = (width - 6) / 4;
                int movingX = x;
                boolean hudActive = profile.getShowHudMessage().equals((Object)Profile.Control.DEFER);
                CycleButton hudButton = CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)(hudActive ? macro.getShowHudMessage() : macro.getShowHudMessageStatus())).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.hud.tooltip", new Object[0]))).m_168936_(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.hud", new Object[0]), (button, status) -> profile.setShowHudMessage(macro, (boolean)status));
                hudButton.m_257427_(500);
                hudButton.f_93623_ = hudActive;
                this.elements.add(hudButton);
                boolean historyActive = profile.getAddToHistory().equals((Object)Profile.Control.DEFER);
                CycleButton historyButton = CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)(historyActive ? macro.getAddToHistory() : macro.getAddToHistoryStatus())).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.history.tooltip", new Object[0]))).m_168936_(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.history", new Object[0]), (button, status) -> profile.setAddToHistory(macro, (boolean)status));
                historyButton.m_257427_(500);
                historyButton.f_93623_ = historyActive;
                this.elements.add(historyButton);
                movingX = x + width - buttonWidth * 2 - 2;
                boolean resumeActive = profile.getResumeRepeating().equals((Object)Profile.Control.DEFER);
                CycleButton resumeButton = CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)(resumeActive ? macro.getResumeRepeating() : macro.getResumeRepeatingStatus())).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.resume.tooltip", new Object[0]))).m_168936_(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.resume", new Object[0]), (button, status) -> profile.setResumeRepeating(macro, (boolean)status));
                resumeButton.m_257427_(500);
                resumeButton.f_93623_ = resumeActive;
                this.elements.add(resumeButton);
                boolean ratelimitActive = profile.getUseRatelimit().equals((Object)Profile.Control.DEFER);
                CycleButton ratelimitButton = CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)(ratelimitActive ? macro.getUseRatelimit() : macro.getUseRatelimitStatus())).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.ratelimit.tooltip", new Object[0]))).m_168936_(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.ratelimit", new Object[0]), (button, status) -> profile.setUseRatelimit(macro, (boolean)status));
                ratelimitButton.m_257427_(500);
                ratelimitButton.f_93623_ = ratelimitActive;
                this.elements.add(ratelimitButton);
            }
        }

        private static class DualKeybind
        extends Entry {
            DualKeybind(int x, int width, int height, MacroOptionList list, Profile profile, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                KeybindUtil.KeybindInfo info = new KeybindUtil.KeybindInfo(profile, macro, macro.getKeybind());
                this.elements.add(Button.m_253074_((Component)info.conflictLabel, button -> {
                    list.setSelected(macro, macro.getKeybind());
                    button.m_93666_((Component)Component.m_237113_((String)"> ").m_7220_((Component)info.label.m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.UNDERLINE)).m_130946_(" <").m_130940_(ChatFormatting.YELLOW));
                }).m_257505_(Tooltip.m_257550_((Component)info.tooltip)).m_252794_(x, 0).m_253046_(buttonWidth, height).m_253136_());
                KeybindUtil.KeybindInfo altInfo = new KeybindUtil.KeybindInfo(profile, macro, macro.getAltKeybind());
                this.elements.add(Button.m_253074_((Component)altInfo.conflictLabel, button -> {
                    list.setSelected(macro, macro.getAltKeybind());
                    button.m_93666_((Component)Component.m_237113_((String)"> ").m_7220_((Component)altInfo.label.m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.UNDERLINE)).m_130946_(" <").m_130940_(ChatFormatting.YELLOW));
                }).m_257505_(Tooltip.m_257550_((Component)(altInfo.tooltip.getString().isBlank() ? Localization.localized("option", "macro.bind.alt.tooltip", new Object[0]) : altInfo.tooltip))).m_252794_(x + width - buttonWidth, 0).m_253046_(buttonWidth, height).m_253136_());
            }
        }
    }
}

