/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import dev.terminalmc.commandkeys.gui.widget.field.FakeTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.gui.widget.list.ProfileOptionList;
import dev.terminalmc.commandkeys.util.Localization;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class MainOptionList
extends OptionList {
    @Nullable
    private Profile editingProfile;

    public MainOptionList(Minecraft mc, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpace, @Nullable Profile editingProfile) {
        super(mc, width, height, top, bottom, entryWidth, entryHeight, entrySpace);
        this.editingProfile = editingProfile;
    }

    @Override
    protected void addEntries() {
        boolean inGame = CommandKeys.inGame();
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)(inGame ? Localization.localized("option", "main.profiles.activate", new Object[0]) : Localization.localized("option", "main.profiles", "\u2139")), inGame ? null : Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
        int i = 0;
        for (Profile profile : Config.get().getProfiles()) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry.ProfileOptions(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, profile, i, inGame));
            if (profile.equals(this.editingProfile)) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry.ProfileName(this.dynEntryX, this.dynEntryWidth, this.entryHeight, profile));
                for (String address : profile.getLinks()) {
                    this.m_7085_((AbstractSelectionList.Entry)new Entry.ProfileLink(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, profile, address));
                }
            }
            if (i++ != 0 || !inGame) continue;
            this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.profiles.other", "\u2139"), Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
        }
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.ActionButton(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Component.m_237113_((String)"+"), null, -1, button -> {
            this.editingProfile = Config.get().addNewProfile();
            this.init();
        }));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.default", "\u2139"), Tooltip.m_257550_((Component)Localization.localized("option", "main.default.tooltip", new Object[0])), 500));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.DefaultOptions1(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.DefaultOptions2(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.ratelimit", "\u2139"), Tooltip.m_257550_((Component)Localization.localized("option", "main.ratelimit.tooltip", new Object[0])), 500));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.Ratelimit(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "main.lengthlimit", "\u2139"), Tooltip.m_257550_((Component)Localization.localized("option", "main.lengthlimit.tooltip", new Object[0])), 500));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.LengthLimit(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
    }

    public void openProfileOptions(Profile profile) {
        this.mc.m_91152_((Screen)new OptionScreen((Screen)this.screen, (Component)Localization.localized("option", "profile", profile.getDisplayName()), new ProfileOptionList(this.mc, this.f_93388_, this.f_93389_, this.f_93390_, this.f_93391_, this.entryWidth, this.entryHeight, this.entrySpacing, profile)));
    }

    @Override
    public boolean keyPressed(InputConstants.Key key) {
        return false;
    }

    @Override
    public boolean keyReleased(InputConstants.Key key) {
        return false;
    }

    @Override
    public boolean mouseClicked(InputConstants.Key key) {
        return false;
    }

    @Override
    public boolean mouseReleased(InputConstants.Key key) {
        return false;
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class LengthLimit
        extends Entry {
            LengthLimit(int x, int width, int height) {
                TextField lengthField = new TextField(x, 0, width, height);
                lengthField.posIntValidator().strict();
                lengthField.m_94199_(6);
                lengthField.m_94151_(val -> {
                    try {
                        int space = Integer.parseInt(val.strip());
                        if (space < 1) {
                            throw new NumberFormatException();
                        }
                        Config.get().setLengthLimitLength(space);
                        lengthField.m_94202_(0xFFFFFF);
                    }
                    catch (NumberFormatException ignored) {
                        lengthField.m_94202_(0xFF0000);
                    }
                });
                lengthField.m_94144_(String.valueOf(Config.get().getLengthLimitLength()));
                lengthField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.lengthlimit.length.tooltip", new Object[0]).m_130946_("\n").m_7220_((Component)Localization.localized("option", "main.lengthlimit.length.tooltip.warning", new Object[0]).m_130940_(ChatFormatting.RED))));
                this.elements.add(lengthField);
            }
        }

        private static class Ratelimit
        extends Entry {
            Ratelimit(int x, int width, int height) {
                int buttonWidth = (width - 8) / 3;
                int fieldWidth = (buttonWidth - 4) / 2;
                int movingX = x;
                TextField countField = new TextField(movingX, 0, fieldWidth, height);
                countField.posIntValidator().strict();
                countField.m_94199_(6);
                countField.m_94151_(val -> Config.get().setRatelimitCount(Integer.parseInt(val.strip())));
                countField.m_94144_(String.valueOf(Config.get().getRatelimitCount()));
                countField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.ratelimit.count.tooltip", new Object[0])));
                this.elements.add(countField);
                TextField ticksField = new TextField(movingX += fieldWidth + 4, 0, fieldWidth, height);
                ticksField.posIntValidator().strict();
                ticksField.m_94199_(6);
                ticksField.m_94151_(val -> {
                    try {
                        int space = Integer.parseInt(val.strip());
                        if (space < 1) {
                            throw new NumberFormatException();
                        }
                        Config.get().setRatelimitTicks(space);
                        ticksField.m_94202_(0xFFFFFF);
                    }
                    catch (NumberFormatException ignored) {
                        ticksField.m_94202_(0xFF0000);
                    }
                });
                ticksField.m_94144_(String.valueOf(Config.get().getRatelimitTicks()));
                ticksField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.ratelimit.ticks.tooltip", new Object[0])));
                this.elements.add(ticksField);
                movingX = x + width - buttonWidth * 2 - 4;
                CycleButton strictButton = CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)Config.get().ratelimitStrict).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "main.ratelimit.strict.tooltip", new Object[0]))).m_168936_(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "main.ratelimit.strict", new Object[0]), (button, status) -> {
                    Config.get().ratelimitStrict = status;
                });
                strictButton.m_257427_(500);
                this.elements.add(strictButton);
                movingX = x + width - buttonWidth;
                CycleButton spButton = CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)Config.get().ratelimitSp).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "main.ratelimit.sp.tooltip", new Object[0]))).m_168936_(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "main.ratelimit.sp", new Object[0]), (button, status) -> {
                    Config.get().ratelimitSp = status;
                });
                spButton.m_257427_(500);
                this.elements.add(spButton);
            }
        }

        private static class DefaultOptions2
        extends Entry {
            DefaultOptions2(int x, int width, int height) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(CycleButton.m_168894_(Macro.ActivationType::title).m_168961_((Object[])Macro.ActivationType.values()).m_168948_((Object)Config.get().defaultActivationType).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.activation", new Object[0]), (button, status) -> {
                    Config.get().defaultActivationType = status;
                }));
            }
        }

        private static class DefaultOptions1
        extends Entry {
            DefaultOptions1(int x, int width, int height) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(CycleButton.m_168894_(Macro.ConflictStrategy::title).m_168961_((Object[])Macro.ConflictStrategy.values()).m_168948_((Object)Config.get().defaultConflictStrategy).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(x, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.conflict", new Object[0]), (button, status) -> {
                    Config.get().defaultConflictStrategy = status;
                }));
                this.elements.add(CycleButton.m_168894_(Macro.SendMode::title).m_168961_((Object[])Macro.SendMode.values()).m_168948_((Object)Config.get().defaultSendMode).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(x + width - buttonWidth, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.mode", new Object[0]), (button, status) -> {
                    Config.get().defaultSendMode = status;
                }));
            }
        }

        private static class ProfileLink
        extends Entry {
            ProfileLink(int x, int width, int height, MainOptionList list, Profile profile, String address) {
                int labelWidth = 50;
                int linkFieldWidth = width - labelWidth - list.smallWidgetWidth - 4;
                Button label = Button.m_253074_((Component)Localization.localized("option", "main.profiles.link", new Object[0]), button -> {}).m_252794_(x, 0).m_253046_(labelWidth, height).m_253136_();
                label.f_93623_ = false;
                this.elements.add(label);
                FakeTextField linkField = new FakeTextField(x + labelWidth, 0, linkFieldWidth, height, () -> {});
                linkField.m_94199_(64);
                linkField.m_94144_(address);
                linkField.f_93623_ = false;
                this.elements.add(linkField);
                Button removeButton = Button.m_253074_((Component)Component.m_237113_((String)"\u274c"), button -> {
                    profile.removeLink(address);
                    list.init();
                }).m_252794_(x + width - list.smallWidgetWidth, 0).m_253046_(list.smallWidgetWidth, height).m_253136_();
                removeButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profile.link.remove.tooltip", new Object[0])));
                removeButton.m_257427_(500);
                this.elements.add(removeButton);
            }
        }

        private static class ProfileName
        extends Entry {
            ProfileName(int x, int width, int height, Profile profile) {
                int labelWidth = 50;
                int nameBoxWidth = width - labelWidth - 4;
                Button label = Button.m_253074_((Component)Localization.localized("option", "main.profile.name", new Object[0]), button -> {}).m_252794_(x, 0).m_253046_(labelWidth, height).m_253136_();
                label.f_93623_ = false;
                this.elements.add(label);
                TextField nameBox = new TextField(x + labelWidth, 0, nameBoxWidth, height);
                nameBox.m_94199_(64);
                nameBox.m_94151_(value -> {
                    profile.name = value.strip();
                });
                nameBox.m_94144_(profile.name);
                this.elements.add(nameBox);
            }
        }

        private static class ProfileOptions
        extends Entry {
            MainOptionList list;
            Profile profile;

            ProfileOptions(int x, int width, int height, MainOptionList list, Profile profile, int index, boolean inGame) {
                this.list = list;
                this.profile = profile;
                boolean spDefault = index == Config.get().getSpDefault();
                boolean mpDefault = index == Config.get().getMpDefault();
                int smallWidgetWidth = list.smallWidgetWidth;
                int mainButtonWidth = width - smallWidgetWidth * 5 - 20;
                int mainButtonX = x;
                if (inGame) {
                    if (index == 0) {
                        ImageButton linkButton = new ImageButton(x, 0, smallWidgetWidth, height, 0, 0, 20, LINK_ICON, 32, 64, button -> {
                            profile.forceAddLink(CommandKeys.lastConnection);
                            list.init();
                        });
                        if (profile.getLinks().contains(CommandKeys.lastConnection)) {
                            linkButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.linked.tooltip", new Object[0])));
                            linkButton.f_93623_ = false;
                        } else {
                            linkButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.link.tooltip", new Object[0])));
                        }
                        linkButton.m_257427_(500);
                        this.elements.add(linkButton);
                    } else {
                        Button activateButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2191"), button -> {
                            Config.get().activateProfile(index);
                            list.init();
                        }).m_252794_(x, 0).m_253046_(smallWidgetWidth, height).m_253136_();
                        activateButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.activate.tooltip", new Object[0])));
                        activateButton.m_257427_(500);
                        this.elements.add(activateButton);
                    }
                    mainButtonWidth -= smallWidgetWidth + 4;
                    mainButtonX += smallWidgetWidth + 4;
                }
                MutableComponent name = Component.m_237113_((String)profile.getDisplayName());
                int numLinks = profile.getLinks().size();
                if (numLinks != 0) {
                    name.m_130946_(" ");
                    if (numLinks == 1) {
                        name.m_7220_((Component)Localization.localized("option", "main.profiles.links.one", new Object[0]).m_130940_(ChatFormatting.GRAY));
                    } else {
                        name.m_7220_((Component)Localization.localized("option", "main.profiles.links.many", numLinks).m_130940_(ChatFormatting.GRAY));
                    }
                }
                this.elements.add(Button.m_253074_((Component)name, button -> list.openProfileOptions(profile)).m_257505_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profile.edit.tooltip", new Object[0]))).m_252794_(mainButtonX, 0).m_253046_(mainButtonWidth, height).m_253136_());
                int movingX = x + width - smallWidgetWidth * 5 - 16;
                ImageButton configureButton = new ImageButton(movingX, 0, smallWidgetWidth, height, 0, 0, 20, OPTIONS_ICON, 32, 64, button -> {
                    list.editingProfile = list.editingProfile == null ? profile : (!list.editingProfile.equals(profile) ? profile : null);
                    list.init();
                }, (Component)Component.m_237119_());
                configureButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profile.details.tooltip", new Object[0])));
                configureButton.m_257427_(500);
                this.elements.add(configureButton);
                Button setAsSpDefaultButton = Button.m_253074_((Component)Localization.localized("option", "main.profiles.default.singleplayer.set", new Object[0]), button -> {
                    Config.get().setSpDefault(index);
                    list.init();
                }).m_252794_(movingX += smallWidgetWidth + 4, 0).m_253046_(smallWidgetWidth, height).m_253136_();
                if (spDefault) {
                    setAsSpDefaultButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.default.singleplayer.tooltip", new Object[0])));
                    setAsSpDefaultButton.m_93666_((Component)setAsSpDefaultButton.m_6035_().m_6881_().m_130940_(ChatFormatting.GREEN));
                } else {
                    setAsSpDefaultButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.default.singleplayer.set.tooltip", new Object[0])));
                }
                setAsSpDefaultButton.m_257427_(500);
                setAsSpDefaultButton.f_93623_ = !spDefault;
                this.elements.add(setAsSpDefaultButton);
                Button setAsMpDefaultButton = Button.m_253074_((Component)Localization.localized("option", "main.profiles.default.multiplayer.set", new Object[0]), button -> {
                    Config.get().setMpDefault(index);
                    list.init();
                }).m_252794_(movingX += smallWidgetWidth + 4, 0).m_253046_(smallWidgetWidth, height).m_253136_();
                if (mpDefault) {
                    setAsMpDefaultButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.default.multiplayer.tooltip", new Object[0])));
                    setAsMpDefaultButton.m_93666_((Component)setAsMpDefaultButton.m_6035_().m_6881_().m_130940_(ChatFormatting.GREEN));
                } else {
                    setAsMpDefaultButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.default.multiplayer.set.tooltip", new Object[0])));
                }
                setAsMpDefaultButton.m_257427_(500);
                setAsMpDefaultButton.f_93623_ = !mpDefault;
                this.elements.add(setAsMpDefaultButton);
                ImageButton copyButton = new ImageButton(movingX += smallWidgetWidth + 4, 0, smallWidgetWidth, height, 0, 0, 20, COPY_ICON, 32, 64, button -> {
                    Config.get().addCopyProfile(profile);
                    list.init();
                }, (Component)Component.m_237119_());
                copyButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.copy.tooltip", new Object[0])));
                copyButton.m_257427_(500);
                this.elements.add(copyButton);
                Button deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"\u274c"), button -> {
                    Config.get().removeProfile(index);
                    list.init();
                }).m_252794_(movingX += smallWidgetWidth + 4, 0).m_253046_(smallWidgetWidth, height).m_253136_();
                if (spDefault || mpDefault) {
                    deleteButton.f_93623_ = false;
                    deleteButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.delete.disabled.tooltip", new Object[0])));
                } else {
                    deleteButton.m_93666_((Component)deleteButton.m_6035_().m_6881_().m_130940_(ChatFormatting.RED));
                    deleteButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "main.profiles.delete.tooltip", new Object[0])));
                }
                deleteButton.m_257427_(500);
                this.elements.add(deleteButton);
            }
        }
    }
}

