/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import dev.terminalmc.commandkeys.mixin.accessor.AbstractWidgetAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionList
extends ContainerObjectSelectionList<Entry> {
    protected OptionScreen screen;
    protected final Minecraft mc;
    protected final int entryWidth;
    protected final int entryHeight;
    protected final int entrySpacing;
    protected int rowWidth;
    protected int dynWideEntryWidth;
    protected int dynEntryWidth;
    protected int entryX;
    protected int dynWideEntryX;
    protected int dynEntryX;
    protected int smallWidgetWidth;
    protected int tinyWidgetWidth;

    public OptionList(Minecraft mc, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, width, height, top, bottom, entryHeight + entrySpacing);
        this.mc = mc;
        this.entryWidth = entryWidth;
        this.entryHeight = entryHeight;
        this.entrySpacing = entrySpacing;
        this.updateElementBounds();
    }

    protected void updateElementBounds() {
        this.dynWideEntryWidth = Math.max(this.entryWidth, (int)((float)this.f_93388_ / 100.0f * 70.0f));
        this.dynEntryWidth = Math.max(this.entryWidth, (int)((float)this.f_93388_ / 100.0f * 50.0f));
        this.entryX = this.f_93388_ / 2 - this.entryWidth / 2;
        this.dynWideEntryX = this.f_93388_ / 2 - this.dynWideEntryWidth / 2;
        this.dynEntryX = this.f_93388_ / 2 - this.dynEntryWidth / 2;
        this.rowWidth = Math.max(this.entryWidth, this.dynWideEntryWidth) + 40 + 48;
        this.smallWidgetWidth = Math.max(16, this.entryHeight);
        this.tinyWidgetWidth = 16;
    }

    protected void init() {
        double scrollAmount = this.m_93517_();
        this.m_93516_();
        this.m_7522_(null);
        this.addEntries();
        this.m_93410_(scrollAmount);
    }

    public void setScreen(OptionScreen screen) {
        this.screen = screen;
    }

    public void addEntry(int index, Entry entry) {
        this.m_6702_().add(index, entry);
    }

    public void addSpacedEntry(Entry entry) {
        super.m_7085_((AbstractSelectionList.Entry)entry);
        super.m_7085_((AbstractSelectionList.Entry)new Entry.Space(entry));
    }

    public void addSpacedEntry(int index, Entry entry) {
        this.addEntry(index, entry);
        this.addEntry(index + 1, new Entry.Space(entry));
    }

    protected abstract void addEntries();

    public void m_93437_(int width, int height, int top, int bottom) {
        super.m_93437_(width, height, top, bottom);
        this.updateElementBounds();
        this.init();
    }

    public int m_5759_() {
        return this.rowWidth;
    }

    protected int m_5756_() {
        return this.f_93388_ / 2 + this.rowWidth / 2;
    }

    public abstract boolean keyPressed(InputConstants.Key var1);

    public abstract boolean keyReleased(InputConstants.Key var1);

    public abstract boolean mouseClicked(InputConstants.Key var1);

    public abstract boolean mouseReleased(InputConstants.Key var1);

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public static final int SPACE = 4;
        public static final int SPACE_SMALL = 2;
        public static final int SPACE_TINY = 1;
        public static final ResourceLocation COPY_ICON = new ResourceLocation("commandkeys", "textures/gui/sprites/widget/copy_button.png");
        public static final ResourceLocation OPTIONS_ICON = new ResourceLocation("commandkeys", "textures/gui/sprites/widget/options_button.png");
        public static final ResourceLocation LINK_ICON = new ResourceLocation("commandkeys", "textures/gui/sprites/widget/link_button.png");
        public static final ResourceLocation SEND_ICON = new ResourceLocation("commandkeys", "textures/gui/sprites/widget/send_button.png");
        public final List<AbstractWidget> elements = new ArrayList<AbstractWidget>();

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.elements;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return this.elements;
        }

        public void m_6311_(@NotNull GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.elements.forEach(button -> {
                button.m_253211_(y);
                button.m_88315_(graphics, mouseX, mouseY, tickDelta);
            });
        }

        public static class Space
        extends Entry {
            private final Entry entry;

            public Space(Entry entry) {
                this.entry = entry;
            }

            public boolean m_7282_() {
                return this.entry.m_7282_();
            }

            public void m_7897_(boolean dragging) {
                this.entry.m_7897_(dragging);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.entry.m_6375_(mouseX, mouseY, button);
            }

            public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                return this.entry.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
            }

            public void m_7522_(GuiEventListener listener) {
                this.entry.m_7522_(listener);
            }

            public GuiEventListener m_7222_() {
                return this.entry.m_7222_();
            }

            public ComponentPath m_264176_(@NotNull FocusNavigationEvent event, int i) {
                if (this.entry.m_6702_().isEmpty()) {
                    return null;
                }
                ComponentPath $$2 = this.entry.m_6702_().get(Math.min(i, this.entry.m_6702_().size() - 1)).m_264064_(event);
                return ComponentPath.m_264334_((ContainerEventHandler)this.entry, (ComponentPath)$$2);
            }
        }

        public static class ActionButton
        extends Entry {
            private final Button button;

            public ActionButton(int x, int width, int height, Component message, @Nullable Tooltip tooltip, int tooltipDelay, Button.OnPress onPress) {
                this.button = Button.m_253074_((Component)message, (Button.OnPress)onPress).m_252794_(x, 0).m_253046_(width, height).m_253136_();
                if (tooltip != null) {
                    this.button.m_257544_(tooltip);
                }
                if (tooltipDelay >= 0) {
                    this.button.m_257427_(tooltipDelay);
                }
                this.elements.add(this.button);
            }

            public void setBounds(int x, int width, int height) {
                this.button.m_264152_(x, 0);
                this.button.m_93674_(width);
                ((AbstractWidgetAccessor)this.button).commandkeys$setHeight(height);
            }
        }

        public static class Text
        extends Entry {
            public Text(int x, int width, int height, Component message, @Nullable Tooltip tooltip, int tooltipDelay) {
                Object widget = Minecraft.m_91087_().f_91062_.m_92895_(message.getString()) <= width ? new StringWidget(x, 0, width, height, message, Minecraft.m_91087_().f_91062_) : new MultiLineTextWidget(x, 0, message, Minecraft.m_91087_().f_91062_).m_269098_(width).m_269484_(true);
                if (tooltip != null) {
                    widget.m_257544_(tooltip);
                }
                if (tooltipDelay >= 0) {
                    widget.m_257427_(tooltipDelay);
                }
                this.elements.add(widget);
            }
        }
    }
}

