/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import dev.terminalmc.commandkeys.gui.widget.field.FakeTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.MacroOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.MainOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ProfileOptionList
extends MacroBindList {
    private OptionList.Entry.ActionButton addMacroEntry;

    public ProfileOptionList(Minecraft mc, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpace, @NotNull Profile profile) {
        super(mc, width, height, top, bottom, entryWidth, entryHeight, entrySpace, profile, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(Entry.MacroOptions.class, profile::moveMacro)));
        this.addMacroEntry = new OptionList.Entry.ActionButton(this.dynWideEntryX, this.dynWideEntryWidth, entryHeight, (Component)Component.m_237113_((String)"+"), null, -1, button -> {
            profile.addMacro(new Macro());
            this.init();
            this.m_93498_((AbstractSelectionList.Entry)this.addMacroEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.m_7085_((AbstractSelectionList.Entry)new Entry.ScreenSwitch(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.ProfileControls(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "profile.keys", "\u2139"), Tooltip.m_257550_((Component)Localization.localized("option", "profile.keys.tooltip", new Object[0])), 500));
        this.refreshMacroSubList();
        this.addMacroEntry.setBounds(this.dynEntryX, this.dynEntryWidth, this.entryHeight);
        this.m_7085_((AbstractSelectionList.Entry)this.addMacroEntry);
    }

    protected void refreshMacroSubList() {
        this.m_6702_().removeIf(entry -> entry instanceof Entry.MacroOptions);
        int start = this.m_6702_().indexOf((Object)this.addMacroEntry);
        start = start == -1 ? this.m_6702_().size() : --start;
        List<Macro> macros = this.profile.getMacros();
        for (int i = macros.size() - 1; i >= 0; --i) {
            Macro macro = macros.get(i);
            List<Message> messages = macro.getMessages();
            if (messages.isEmpty()) {
                macro.addMessage(new Message());
            }
            this.m_6702_().add(start, new Entry.MacroOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.profile, macro));
        }
        this.m_93410_(this.m_93517_());
    }

    public void openMainOptions() {
        this.mc.m_91152_((Screen)new OptionScreen((Screen)this.screen, (Component)Localization.localized("option", "main", new Object[0]), new MainOptionList(this.mc, this.f_93388_, this.f_93389_, this.f_93390_, this.f_93391_, this.entryWidth, this.entryHeight, this.entrySpacing, null)));
    }

    public void openMacroOptions(Macro macro) {
        this.mc.m_91152_((Screen)new OptionScreen((Screen)this.screen, (Component)Localization.localized("option", "macro", new Object[0]), new MacroOptionList(this.mc, this.f_93388_, this.f_93389_, this.f_93390_, this.f_93391_, this.entryWidth, this.entryHeight, this.entrySpacing, this.profile, macro)));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class MacroOptions
        extends Entry {
            MacroOptions(int x, int width, int height, ProfileOptionList list, Profile profile, Macro macro) {
                Font font = Minecraft.m_91087_().f_91062_;
                List<Message> messages = macro.getMessages();
                boolean editableField = messages.size() == 1;
                int keyButtonWidth = Mth.m_14045_((int)(font.m_92895_("> Right Control + W <") + 4), (int)90, (int)130);
                KeybindUtil.KeybindInfo keybindInfo = new KeybindUtil.KeybindInfo(profile, macro, macro.getKeybind());
                int nominalWidth = font.m_92895_("> " + keybindInfo.label.getString() + " <") + 4;
                if (nominalWidth > keyButtonWidth) {
                    keyButtonWidth = Mth.m_14045_((int)nominalWidth, (int)90, (int)130);
                }
                int messageFieldWidth = width - keyButtonWidth - (list.smallWidgetWidth * 2 + 4);
                int modeButtonWidth = 0;
                if (messageFieldWidth > 280) {
                    modeButtonWidth = 40;
                    messageFieldWidth -= modeButtonWidth * 3 + 2;
                }
                int movingX = x;
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)"\u2191\u2193"), button -> {
                    this.m_7897_(true);
                    list.startDragging(this, null, false);
                }).m_252794_(x - list.smallWidgetWidth - 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
                this.elements.add(Button.m_253074_((Component)keybindInfo.conflictLabel, button -> {
                    list.setSelected(macro, macro.getKeybind());
                    button.m_93666_((Component)Component.m_237113_((String)"> ").m_7220_((Component)keybindInfo.label.m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.UNDERLINE)).m_130946_(" <").m_130940_(ChatFormatting.YELLOW));
                }).m_257505_(Tooltip.m_257550_((Component)keybindInfo.tooltip)).m_252794_(movingX, 0).m_253046_(keyButtonWidth, height).m_253136_());
                ImageButton sendButton = new ImageButton(movingX += keyButtonWidth, 0, list.smallWidgetWidth, height, 0, 0, 20, SEND_ICON, 32, 64, button -> {
                    list.screen.m_7379_();
                    Minecraft.m_91087_().m_91152_(null);
                    macro.trigger(null, false);
                });
                sendButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "profile.trigger.tooltip", new Object[0])));
                sendButton.m_257427_(500);
                sendButton.f_93623_ = CommandKeys.inGame();
                this.elements.add(sendButton);
                TextField messageField = editableField ? new TextField(movingX, 0, messageFieldWidth, height) : new FakeTextField(movingX += list.smallWidgetWidth + 2, 0, messageFieldWidth, height, () -> list.openMacroOptions(macro));
                messageField.m_94199_(512);
                if (editableField) {
                    messageField.m_94151_(val -> macro.setMessage(0, val.stripLeading()));
                }
                messageField.m_94144_(editableField ? messages.get((int)0).string : this.getEditButtonLabel(macro, messageFieldWidth - 10));
                this.elements.add(messageField);
                ImageButton editButton = new ImageButton(movingX += messageFieldWidth + 2, 0, list.smallWidgetWidth, height, 0, 0, 20, OPTIONS_ICON, 32, 64, button -> {
                    list.openMacroOptions(macro);
                    list.init();
                });
                editButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "profile.key.edit", new Object[0])));
                editButton.m_257427_(500);
                this.elements.add(editButton);
                movingX += list.smallWidgetWidth + 2;
                if (modeButtonWidth != 0) {
                    this.elements.add(CycleButton.m_168894_(Macro.ConflictStrategy::title).m_168929_().m_168961_((Object[])Macro.ConflictStrategy.values()).m_168948_((Object)macro.getStrategy()).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(movingX, 0, modeButtonWidth, height, (Component)Component.m_237119_(), (button, status) -> {
                        profile.setConflictStrategy(macro, (Macro.ConflictStrategy)((Object)status));
                        list.init();
                    }));
                    this.elements.add(CycleButton.m_168894_(Macro.SendMode::title).m_168929_().m_168961_((Object[])Macro.SendMode.values()).m_168948_((Object)macro.getMode()).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(movingX += modeButtonWidth, 0, modeButtonWidth, height, (Component)Component.m_237119_(), (button, status) -> {
                        profile.setSendMode(macro, (Macro.SendMode)((Object)status));
                        list.init();
                    }));
                    this.elements.add(CycleButton.m_168894_(Macro.ActivationType::title).m_168929_().m_168961_((Object[])Macro.ActivationType.values()).m_168948_((Object)macro.getActivationType()).m_232498_(status -> Tooltip.m_257550_((Component)status.tooltip())).m_168936_(movingX += modeButtonWidth, 0, modeButtonWidth, height, (Component)Component.m_237119_(), (button, status) -> {
                        profile.setActivationType(macro, (Macro.ActivationType)((Object)status));
                        list.init();
                    }));
                }
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.RED), button -> {
                    list.profile.removeMacro(macro);
                    list.init();
                }).m_252794_(x + width + 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
            }

            private String getEditButtonLabel(Macro macro, int maxWidth) {
                Font font = Minecraft.m_91087_().f_91062_;
                ArrayList<String> strings = new ArrayList<String>();
                for (Message msg : macro.getMessages()) {
                    strings.add(msg.string);
                }
                int excess = strings.size() - 1;
                String tag = String.format(" [+%d]", excess);
                String trimTag = String.format("... [+%d]", excess);
                String first = (String)strings.get(0);
                if (first.isBlank()) {
                    return trimTag;
                }
                String label = first + tag;
                int i = first.length();
                while (font.m_92895_(label) > maxWidth) {
                    label = first.substring(0, i--) + trimTag;
                }
                return label;
            }
        }

        private static class ProfileControls
        extends Entry {
            ProfileControls(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 6) / 4;
                int movingX = x;
                CycleButton hudButton = CycleButton.m_168894_(this::getLabel).m_168961_((Object[])Profile.Control.values()).m_168948_((Object)list.profile.getShowHudMessage()).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.hud.tooltip", new Object[0]).m_130946_("\n").m_7220_((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).m_168936_(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.hud", new Object[0]), (button, status) -> list.profile.setShowHudMessage((Profile.Control)((Object)status)));
                hudButton.m_257427_(500);
                this.elements.add(hudButton);
                CycleButton historyButton = CycleButton.m_168894_(this::getLabel).m_168961_((Object[])Profile.Control.values()).m_168948_((Object)list.profile.getAddToHistory()).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.history.tooltip", new Object[0]).m_130946_("\n").m_7220_((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).m_168936_(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.history", new Object[0]), (button, status) -> list.profile.setAddToHistory((Profile.Control)((Object)status)));
                historyButton.m_257427_(500);
                this.elements.add(historyButton);
                movingX = x + width - buttonWidth * 2 - 2;
                CycleButton resumeButton = CycleButton.m_168894_(this::getLabel).m_168961_((Object[])Profile.Control.values()).m_168948_((Object)list.profile.getResumeRepeating()).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.resume.tooltip", new Object[0]).m_130946_("\n").m_7220_((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).m_168936_(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.resume", new Object[0]), (button, status) -> list.profile.setResumeRepeating((Profile.Control)((Object)status)));
                resumeButton.m_257427_(500);
                this.elements.add(resumeButton);
                CycleButton ratelimitButton = CycleButton.m_168894_(this::getLabel).m_168961_((Object[])Profile.Control.values()).m_168948_((Object)list.profile.getUseRatelimit()).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "macro.control.ratelimit.tooltip", new Object[0]).m_130946_("\n").m_7220_((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).m_168936_(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.ratelimit", new Object[0]), (button, status) -> list.profile.setUseRatelimit((Profile.Control)((Object)status)));
                ratelimitButton.m_257427_(500);
                this.elements.add(ratelimitButton);
            }

            private Component getLabel(Profile.Control control) {
                return switch (control) {
                    default -> throw new IncompatibleClassChangeError();
                    case Profile.Control.ON -> CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN);
                    case Profile.Control.OFF -> CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED);
                    case Profile.Control.DEFER -> Localization.localized("option", "profile.control.defer", new Object[0]).m_130940_(ChatFormatting.GOLD);
                };
            }
        }

        private static class ScreenSwitch
        extends Entry {
            ScreenSwitch(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(Button.m_253074_((Component)Localization.localized("option", "profile.switch", new Object[0]), button -> list.openMainOptions()).m_252794_(x, 0).m_253046_(buttonWidth, height).m_253136_());
                this.elements.add(Button.m_253074_((Component)Localization.localized("option", "profile.controls", new Object[0]), button -> list.openMinecraftControlsScreen()).m_252794_(x + width - buttonWidth, 0).m_253046_(buttonWidth, height).m_253136_());
            }
        }
    }
}

