/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.CommandKeys;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    public static final String LOG_STR = "Unable to deserialize key '{}' with type '{}': {}. Using default value.";
    public static boolean hasChanged = false;

    public static void reset() {
        hasChanged = false;
    }

    @Nullable
    public static JsonPrimitive getAsJsonPrimitiveOrNull(JsonObject obj, String key, Class<?> cls, boolean silent) {
        if (!obj.has(key)) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Key not found");
            }
            hasChanged = true;
            return null;
        }
        JsonElement element = obj.get(key);
        if (!element.isJsonPrimitive()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not JsonPrimitive");
            }
            hasChanged = true;
            return null;
        }
        return element.getAsJsonPrimitive();
    }

    @Nullable
    public static JsonObject getAsJsonObjectOrNull(JsonObject obj, String key, Class<?> cls, boolean silent) {
        if (!obj.has(key)) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Key not found");
            }
            hasChanged = true;
            return null;
        }
        JsonElement element = obj.get(key);
        if (!element.isJsonObject()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not JsonObject");
            }
            hasChanged = true;
            return null;
        }
        return element.getAsJsonObject();
    }

    @Nullable
    public static JsonArray getAsJsonArrayOrNull(JsonObject obj, String key, Class<?> cls, boolean silent) {
        if (!obj.has(key)) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Key not found");
            }
            hasChanged = true;
            return null;
        }
        JsonElement element = obj.get(key);
        if (!element.isJsonArray()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not JsonArray");
            }
            hasChanged = true;
            return null;
        }
        return element.getAsJsonArray();
    }

    public static String getOrDefault(JsonObject obj, String key, String def, boolean silent) {
        Class<String> cls = String.class;
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, cls, silent);
        if (element == null) {
            return def;
        }
        if (!element.getAsJsonPrimitive().isString()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not String");
            }
            hasChanged = true;
            return def;
        }
        return element.getAsString();
    }

    public static int getOrDefault(JsonObject obj, String key, int def, boolean silent) {
        Class<Integer> cls = Integer.class;
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, cls, silent);
        if (element == null) {
            return def;
        }
        if (!element.getAsJsonPrimitive().isNumber()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not Number");
            }
            hasChanged = true;
            return def;
        }
        return element.getAsInt();
    }

    public static float getOrDefault(JsonObject obj, String key, float def, boolean silent) {
        Class<Integer> cls = Integer.class;
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, cls, silent);
        if (element == null) {
            return def;
        }
        if (!element.getAsJsonPrimitive().isNumber()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not Number");
            }
            hasChanged = true;
            return def;
        }
        return element.getAsFloat();
    }

    public static boolean getOrDefault(JsonObject obj, String key, boolean def, boolean silent) {
        Class<Boolean> cls = Boolean.class;
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, cls, silent);
        if (element == null) {
            return def;
        }
        if (!element.getAsJsonPrimitive().isBoolean()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not Boolean");
            }
            hasChanged = true;
            return def;
        }
        return element.getAsBoolean();
    }

    public static <T extends Enum<T>> T getOrDefault(JsonObject obj, String key, Class<T> cls, T def, boolean silent) {
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, cls, silent);
        if (element == null) {
            return def;
        }
        if (!element.getAsJsonPrimitive().isString()) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + String.valueOf(element) + "' is not String");
            }
            hasChanged = true;
            return def;
        }
        String value = element.getAsString();
        for (Enum enumVal : (Enum[])cls.getEnumConstants()) {
            if (!enumVal.name().equals(value)) continue;
            return (T)enumVal;
        }
        if (!silent) {
            CommandKeys.LOG.error(LOG_STR, key, cls.getName(), "Value '" + value + "' is not in Enum Constants");
        }
        hasChanged = true;
        return def;
    }

    public static InputConstants.Key getOrDefault(JsonObject obj, String key, InputConstants.Key def, boolean silent) {
        String keyName = JsonUtil.getOrDefault(obj, key, (String)null, silent);
        if (keyName == null) {
            return def;
        }
        try {
            return InputConstants.m_84851_((String)keyName);
        }
        catch (IllegalArgumentException e) {
            if (!silent) {
                CommandKeys.LOG.error(LOG_STR, key, String.class.getName(), "Value '" + keyName + "' is not the name of an InputConstants.Key");
            }
            hasChanged = true;
            return def;
        }
    }

    public static <T> T getOrDefault(JsonDeserializationContext ctx, JsonObject obj, String key, Class<T> cls, T def, boolean silent) {
        JsonObject element = JsonUtil.getAsJsonObjectOrNull(obj, key, cls, silent);
        if (element == null) {
            return def;
        }
        return (T)ctx.deserialize((JsonElement)element, cls);
    }

    public static List<String> getOrDefault(JsonObject obj, String key, List<String> def, boolean silent) {
        JsonArray array = JsonUtil.getAsJsonArrayOrNull(obj, key, String.class, silent);
        if (array == null) {
            return def;
        }
        return array.asList().stream().filter(je -> je.isJsonPrimitive() && je.getAsJsonPrimitive().isString()).map(JsonElement::getAsString).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> List<T> getOrDefault(JsonDeserializationContext ctx, JsonObject obj, String key, Class<T> cls, List<T> def, boolean silent) {
        JsonArray array = JsonUtil.getAsJsonArrayOrNull(obj, key, cls, silent);
        if (array == null) {
            return def;
        }
        return array.asList().stream().filter(JsonElement::isJsonObject).map(je -> ctx.deserialize(je, (Type)cls)).toList().stream().filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }
}

