/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.util;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.mixin.accessor.KeyMappingAccessor;
import dev.terminalmc.commandkeys.util.Localization;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class KeybindUtil {
    public static int handleKeys(InputConstants.Key key, InputConstants.Key limitKey) {
        if (key.equals((Object)InputConstants.f_84822_)) {
            return 0;
        }
        if (!CommandKeys.profile().keybindMap.containsKey((Object)key)) {
            return 0;
        }
        int i = 0;
        Collection keybinds = CommandKeys.profile().keybindMap.get((Object)key);
        for (Keybind keybind : keybinds) {
            if (!keybind.getLimitKey().equals((Object)limitKey)) continue;
            for (Macro macro : CommandKeys.profile().macroMap.get((Object)keybind)) {
                macro.trigger(keybind, false);
                ++i;
            }
        }
        return i;
    }

    public static int handleKey(InputConstants.Key key) {
        int cancel = 0;
        if (Minecraft.m_91087_().f_91080_ == null && CommandKeys.profile().keybindMap.containsKey((Object)key)) {
            Collection keybinds = CommandKeys.profile().keybindMap.get((Object)key);
            Keybind triggerKb = null;
            List<Macro> macros = null;
            for (Keybind kb : keybinds) {
                if (kb.isLimitKeyDown()) {
                    triggerKb = kb;
                    macros = CommandKeys.profile().macroMap.get((Object)triggerKb).stream().filter(macro -> !macro.getStrategy().equals((Object)Macro.ConflictStrategy.AVOID)).toList();
                    if (macros.isEmpty()) continue;
                    break;
                }
                if (!kb.getLimitKey().equals((Object)InputConstants.f_84822_)) continue;
                triggerKb = kb;
            }
            if (macros == null || macros.isEmpty()) {
                if (triggerKb == null) {
                    return cancel;
                }
                macros = CommandKeys.profile().macroMap.get(triggerKb).stream().filter(macro -> !macro.getStrategy().equals((Object)Macro.ConflictStrategy.AVOID)).toList();
                if (macros.isEmpty()) {
                    return cancel;
                }
            }
            boolean ratelimited = false;
            for (Macro macro2 : macros) {
                boolean send = true;
                switch (macro2.getStrategy()) {
                    case SUBMIT: {
                        send = KeybindUtil.getConflict(key) == null;
                        break;
                    }
                    case VETO: {
                        cancel = 2;
                    }
                }
                if (!send) continue;
                boolean rl = macro2.trigger(triggerKb, ratelimited);
                if (!rl && cancel == 0 && (macro2.getMode().equals((Object)Macro.SendMode.TYPE) || macro2.getMode().equals((Object)Macro.SendMode.EDIT))) {
                    cancel = 1;
                }
                ratelimited |= rl;
            }
        }
        return cancel;
    }

    @Nullable
    public static KeyMapping getConflict(InputConstants.Key key) {
        for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!((KeyMappingAccessor)keyMapping).commandkeys$getKey().equals((Object)key)) continue;
            return keyMapping;
        }
        return null;
    }

    public static class KeybindInfo {
        private final Profile profile;
        private final Macro macro;
        public MutableComponent label;
        public MutableComponent conflictLabel;
        public MutableComponent tooltip = Component.m_237119_();
        private boolean internalConflict = false;
        private boolean mcConflict = false;

        public KeybindInfo(Profile profile, Macro macro, Keybind keybind) {
            this.profile = profile;
            this.macro = macro;
            this.label = keybind.getLimitKey().equals((Object)InputConstants.f_84822_) ? keybind.getKey().m_84875_().m_6881_() : keybind.getLimitKey().m_84875_().m_6881_().m_130946_(" + ").m_7220_(keybind.getKey().m_84875_());
            this.checkConflict(keybind.getLimitKey(), null);
            this.checkConflict(keybind.getKey(), keybind);
            this.createConflictLabel();
        }

        private void checkConflict(InputConstants.Key key, Keybind keybind) {
            KeyMapping keyMapping;
            if (key.equals((Object)InputConstants.f_84822_)) {
                return;
            }
            if (this.profile.keybindMap.get((Object)key).size() > 1) {
                if (this.internalConflict || this.mcConflict) {
                    this.tooltip.m_130946_("\n");
                }
                this.tooltip.m_7220_((Component)Localization.localized("option", "macro.bind.tooltip.conflict.internal", key.m_84875_().m_6881_().m_130940_(ChatFormatting.GOLD))).m_130940_(ChatFormatting.WHITE);
                this.internalConflict = true;
            } else if (keybind != null && this.profile.macroMap.get((Object)keybind).size() > 1) {
                if (this.internalConflict || this.mcConflict) {
                    this.tooltip.m_130946_("\n");
                }
                this.tooltip.m_7220_((Component)Localization.localized("option", "macro.bind.tooltip.conflict.internal", key.m_84875_().m_6881_().m_130940_(ChatFormatting.GOLD))).m_130940_(ChatFormatting.WHITE);
                this.internalConflict = true;
            }
            if (!this.macro.getStrategy().equals((Object)Macro.ConflictStrategy.AVOID) && (keyMapping = KeybindUtil.getConflict(key)) != null) {
                if (this.internalConflict || this.mcConflict) {
                    this.tooltip.m_130946_("\n");
                }
                this.tooltip.m_7220_((Component)Localization.localized("option", "macro.bind.tooltip.conflict.external", key.m_84875_().m_6881_().m_130940_(ChatFormatting.RED), Component.m_237115_((String)keyMapping.m_90860_()).m_130940_(ChatFormatting.GRAY))).m_130940_(ChatFormatting.WHITE);
                this.mcConflict = true;
            }
        }

        public void createConflictLabel() {
            if (this.mcConflict) {
                this.conflictLabel = Component.m_237113_((String)"[ ").m_7220_((Component)this.label.m_130940_(ChatFormatting.WHITE)).m_130946_(" ]").m_130940_(ChatFormatting.RED);
                this.tooltip.m_130946_("\n");
                this.tooltip.m_7220_((Component)Localization.localized("option", "macro.bind.tooltip.conflictStrategy", this.macro.getStrategy().tooltip()));
            } else {
                this.conflictLabel = this.internalConflict ? Component.m_237113_((String)"[ ").m_7220_((Component)this.label.m_130940_(ChatFormatting.WHITE)).m_130946_(" ]").m_130940_(ChatFormatting.GOLD) : this.label;
            }
        }
    }
}

