/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.commandkeys.util.JsonUtil;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

public class Message {
    public static final int VERSION = 1;
    public final int version = 1;
    public String string;
    public int delayTicks;

    public Message() {
        this("", 0);
    }

    Message(String string, int delayTicks) {
        this.string = string;
        this.delayTicks = delayTicks;
    }

    Message(Message message) {
        this.string = message.string;
        this.delayTicks = message.delayTicks;
    }

    Message validate() {
        if (this.string == null) {
            this.string = "";
        }
        if (this.delayTicks < 0) {
            this.delayTicks = 0;
        }
        return this;
    }

    public static class Deserializer
    implements JsonDeserializer<Message> {
        @Nullable
        public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 1;
            String string = JsonUtil.getOrDefault(obj, "string", "", silent);
            int delayTicks = JsonUtil.getOrDefault(obj, "delayTicks", 0, silent);
            return new Message(string, delayTicks).validate();
        }
    }
}

