/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import dev.terminalmc.commandkeys.gui.widget.field.FakeTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.MacroOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.MainOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ProfileOptionList
extends MacroBindList {
    private OptionList.Entry.ActionButton addMacroEntry;

    public ProfileOptionList(class_310 mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpace, @NotNull Profile profile) {
        super(mc, width, height, y, entryWidth, entryHeight, entrySpace, profile, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(Entry.MacroOptions.class, profile::moveMacro)));
        this.addMacroEntry = new OptionList.Entry.ActionButton(this.dynWideEntryX, this.dynWideEntryWidth, entryHeight, (class_2561)class_2561.method_43470((String)"+"), null, -1, button -> {
            profile.addMacro(new Macro());
            this.init();
            this.method_25328((class_350.class_351)this.addMacroEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.method_25321((class_350.class_351)new Entry.ScreenSwitch(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.method_25321((class_350.class_351)new Entry.ProfileControls(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "profile.keys", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "profile.keys.tooltip", new Object[0])), 500));
        this.refreshMacroSubList();
        this.addMacroEntry.setBounds(this.dynEntryX, this.dynEntryWidth, this.entryHeight);
        this.method_25321((class_350.class_351)this.addMacroEntry);
    }

    protected void refreshMacroSubList() {
        this.method_25396().removeIf(entry -> entry instanceof Entry.MacroOptions);
        int start = this.method_25396().indexOf((Object)this.addMacroEntry);
        start = start == -1 ? this.method_25396().size() : --start;
        List<Macro> macros = this.profile.getMacros();
        for (int i = macros.size() - 1; i >= 0; --i) {
            Macro macro = macros.get(i);
            List<Message> messages = macro.getMessages();
            if (messages.isEmpty()) {
                macro.addMessage(new Message());
            }
            this.method_25396().add(start, new Entry.MacroOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.profile, macro));
        }
        this.method_60322();
    }

    public void openMainOptions() {
        this.mc.method_1507((class_437)new OptionScreen((class_437)this.screen, (class_2561)Localization.localized("option", "main", new Object[0]), new MainOptionList(this.mc, this.field_22758, this.field_22759, this.method_46427(), this.entryWidth, this.entryHeight, this.entrySpacing, null)));
    }

    public void openMacroOptions(Macro macro) {
        this.mc.method_1507((class_437)new OptionScreen((class_437)this.screen, (class_2561)Localization.localized("option", "macro", new Object[0]), new MacroOptionList(this.mc, this.field_22758, this.field_22759, this.method_46427(), this.entryWidth, this.entryHeight, this.entrySpacing, this.profile, macro)));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class MacroOptions
        extends Entry {
            MacroOptions(int x, int width, int height, ProfileOptionList list, Profile profile, Macro macro) {
                class_327 font = class_310.method_1551().field_1772;
                List<Message> messages = macro.getMessages();
                boolean editableField = messages.size() == 1;
                int keyButtonWidth = Math.clamp((long)(font.method_1727("> Right Control + W <") + 4), 90, 130);
                KeybindUtil.KeybindInfo keybindInfo = new KeybindUtil.KeybindInfo(profile, macro, macro.getKeybind());
                int nominalWidth = font.method_1727("> " + keybindInfo.label.getString() + " <") + 4;
                if (nominalWidth > keyButtonWidth) {
                    keyButtonWidth = Math.clamp((long)nominalWidth, 90, 130);
                }
                int messageFieldWidth = width - keyButtonWidth - (list.smallWidgetWidth * 2 + 4);
                int modeButtonWidth = 0;
                if (messageFieldWidth > 280) {
                    modeButtonWidth = 40;
                    messageFieldWidth -= modeButtonWidth * 3 + 2;
                }
                int movingX = x;
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191\u2193"), button -> {
                    this.method_25398(true);
                    list.startDragging(this, null, false);
                }).method_46433(x - list.smallWidgetWidth - 4, 0).method_46437(list.smallWidgetWidth, height).method_46431());
                this.elements.add(class_4185.method_46430((class_2561)keybindInfo.conflictLabel, button -> {
                    list.setSelected(macro, macro.getKeybind());
                    button.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)keybindInfo.label.method_27692(class_124.field_1068).method_27692(class_124.field_1073)).method_27693(" <").method_27692(class_124.field_1054));
                }).method_46436(class_7919.method_47407((class_2561)keybindInfo.tooltip)).method_46433(movingX, 0).method_46437(keyButtonWidth, height).method_46431());
                class_344 sendButton = new class_344(movingX += keyButtonWidth, 0, list.smallWidgetWidth, height, SEND_SPRITES, button -> {
                    list.screen.method_25419();
                    class_310.method_1551().method_1507(null);
                    macro.trigger(null, false);
                });
                sendButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "profile.trigger.tooltip", new Object[0])));
                sendButton.method_47402(Duration.ofMillis(500L));
                sendButton.field_22763 = CommandKeys.inGame();
                this.elements.add(sendButton);
                TextField messageField = editableField ? new TextField(movingX, 0, messageFieldWidth, height) : new FakeTextField(movingX += list.smallWidgetWidth + 2, 0, messageFieldWidth, height, () -> list.openMacroOptions(macro));
                messageField.method_1880(512);
                if (editableField) {
                    messageField.method_1863(val -> macro.setMessage(0, val.stripLeading()));
                }
                messageField.method_1852(editableField ? messages.getFirst().string : this.getEditButtonLabel(macro, messageFieldWidth - 10));
                this.elements.add(messageField);
                class_344 editButton = new class_344(movingX += messageFieldWidth + 2, 0, list.smallWidgetWidth, height, OPTION_SPRITES, button -> {
                    list.openMacroOptions(macro);
                    list.init();
                });
                editButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "profile.key.edit", new Object[0])));
                editButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(editButton);
                movingX += list.smallWidgetWidth + 2;
                if (modeButtonWidth != 0) {
                    this.elements.add(class_5676.method_32606(Macro.ConflictStrategy::title).method_32616().method_32624((Object[])Macro.ConflictStrategy.values()).method_32619((Object)macro.getStrategy()).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(movingX, 0, modeButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        profile.setConflictStrategy(macro, (Macro.ConflictStrategy)((Object)status));
                        list.init();
                    }));
                    this.elements.add(class_5676.method_32606(Macro.SendMode::title).method_32616().method_32624((Object[])Macro.SendMode.values()).method_32619((Object)macro.getMode()).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(movingX += modeButtonWidth, 0, modeButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        profile.setSendMode(macro, (Macro.SendMode)((Object)status));
                        list.init();
                    }));
                    this.elements.add(class_5676.method_32606(Macro.ActivationType::title).method_32616().method_32624((Object[])Macro.ActivationType.values()).method_32619((Object)macro.getActivationType()).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(movingX += modeButtonWidth, 0, modeButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        profile.setActivationType(macro, (Macro.ActivationType)((Object)status));
                        list.init();
                    }));
                }
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061), button -> {
                    list.profile.removeMacro(macro);
                    list.init();
                }).method_46433(x + width + 4, 0).method_46437(list.smallWidgetWidth, height).method_46431());
            }

            private String getEditButtonLabel(Macro macro, int maxWidth) {
                class_327 font = class_310.method_1551().field_1772;
                ArrayList<String> strings = new ArrayList<String>();
                for (Message msg : macro.getMessages()) {
                    strings.add(msg.string);
                }
                int excess = strings.size() - 1;
                String tag = String.format(" [+%d]", excess);
                String trimTag = String.format("... [+%d]", excess);
                String first = (String)strings.getFirst();
                if (first.isBlank()) {
                    return trimTag;
                }
                String label = first + tag;
                int i = first.length();
                while (font.method_1727(label) > maxWidth) {
                    label = first.substring(0, i--) + trimTag;
                }
                return label;
            }
        }

        private static class ProfileControls
        extends Entry {
            ProfileControls(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 6) / 4;
                int movingX = x;
                class_5676 hudButton = class_5676.method_32606(this::getLabel).method_32624((Object[])Profile.Control.values()).method_32619((Object)list.profile.getShowHudMessage()).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.hud.tooltip", new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).method_32617(movingX, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.hud", new Object[0]), (button, status) -> list.profile.setShowHudMessage((Profile.Control)((Object)status)));
                hudButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(hudButton);
                class_5676 historyButton = class_5676.method_32606(this::getLabel).method_32624((Object[])Profile.Control.values()).method_32619((Object)list.profile.getAddToHistory()).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.history.tooltip", new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).method_32617(movingX += buttonWidth + 2, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.history", new Object[0]), (button, status) -> list.profile.setAddToHistory((Profile.Control)((Object)status)));
                historyButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(historyButton);
                movingX = x + width - buttonWidth * 2 - 2;
                class_5676 resumeButton = class_5676.method_32606(this::getLabel).method_32624((Object[])Profile.Control.values()).method_32619((Object)list.profile.getResumeRepeating()).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.resume.tooltip", new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).method_32617(movingX, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.resume", new Object[0]), (button, status) -> list.profile.setResumeRepeating((Profile.Control)((Object)status)));
                resumeButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(resumeButton);
                class_5676 ratelimitButton = class_5676.method_32606(this::getLabel).method_32624((Object[])Profile.Control.values()).method_32619((Object)list.profile.getUseRatelimit()).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.ratelimit.tooltip", new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).method_32617(movingX += buttonWidth + 2, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.ratelimit", new Object[0]), (button, status) -> list.profile.setUseRatelimit((Profile.Control)((Object)status)));
                ratelimitButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(ratelimitButton);
            }

            private class_2561 getLabel(Profile.Control control) {
                return switch (control) {
                    default -> throw new MatchException(null, null);
                    case Profile.Control.ON -> class_5244.field_24332.method_27661().method_27692(class_124.field_1060);
                    case Profile.Control.OFF -> class_5244.field_24333.method_27661().method_27692(class_124.field_1061);
                    case Profile.Control.DEFER -> Localization.localized("option", "profile.control.defer", new Object[0]).method_27692(class_124.field_1065);
                };
            }
        }

        private static class ScreenSwitch
        extends Entry {
            ScreenSwitch(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(class_4185.method_46430((class_2561)Localization.localized("option", "profile.switch", new Object[0]), button -> list.openMainOptions()).method_46433(x, 0).method_46437(buttonWidth, height).method_46431());
                this.elements.add(class_4185.method_46430((class_2561)Localization.localized("option", "profile.controls", new Object[0]), button -> list.openMinecraftControlsScreen()).method_46433(x + width - buttonWidth, 0).method_46437(buttonWidth, height).method_46431());
            }
        }
    }
}

