/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.util;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.mixin.accessor.ChatComponentAccessor;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8623;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderUtil {
    private static int faults;
    @Nullable
    private static class_2338 playerBlockPos;
    @Nullable
    private static class_2338 lookBlockPos;
    @Nullable
    private static class_243 lookAngle;
    @Nullable
    private static String pmSenderName;
    private static final SimplePlaceholder[] SIMPLE_PLACEHOLDERS;
    private static final Placeholder[] REGEX_PLACEHOLDERS;

    public static Pair<String, Integer> replace(String message) {
        if (!message.contains("%")) {
            return new Pair((Object)message, (Object)0);
        }
        PlaceholderUtil.reset();
        for (SimplePlaceholder simplePlaceholder : SIMPLE_PLACEHOLDERS) {
            message = simplePlaceholder.process(message);
        }
        for (Record record : REGEX_PLACEHOLDERS) {
            message = ((Placeholder)record).process(message);
        }
        return new Pair((Object)message, (Object)faults);
    }

    private static void reset() {
        faults = 0;
        playerBlockPos = null;
        lookBlockPos = null;
        lookAngle = null;
        pmSenderName = null;
    }

    private static String fault() {
        ++faults;
        return "?";
    }

    private static String getRecentChat(@NotNull String[] pattern) {
        try {
            Pattern regex = Pattern.compile(pattern[0]);
            int i = 0;
            for (class_303 guiMsg : ((ChatComponentAccessor)class_310.method_1551().field_1705.method_1743()).commandkeys$getAllMessages()) {
                if (++i > 50) break;
                Matcher matcher = regex.matcher(guiMsg.comp_893().getString());
                if (!matcher.find()) continue;
                try {
                    return matcher.group(1);
                }
                catch (IndexOutOfBoundsException e) {
                    CommandKeys.LOG.error("Recent chat placeholder failed: Group 1 not available: " + String.valueOf(e), new Object[0]);
                    return PlaceholderUtil.fault();
                }
            }
            CommandKeys.LOG.warn("Recent chat placeholder failed: No message found: Checked " + i, new Object[0]);
        }
        catch (PatternSyntaxException e) {
            CommandKeys.LOG.error("Recent chat placeholder failed: Invalid regex: " + String.valueOf(e), new Object[0]);
        }
        return PlaceholderUtil.fault();
    }

    private static String getClipboard(String @Nullable [] pattern) {
        String clipboard = class_310.method_1551().field_1774.method_1460();
        if (clipboard.isEmpty()) {
            CommandKeys.LOG.warn("Clipboard placeholder failed: No data", new Object[0]);
            return PlaceholderUtil.fault();
        }
        if (pattern != null) {
            try {
                if (!Pattern.compile(pattern[0]).matcher(clipboard).find()) {
                    CommandKeys.LOG.warn("Clipboard placeholder failed: Non-matching regex", new Object[0]);
                    return PlaceholderUtil.fault();
                }
            }
            catch (PatternSyntaxException e) {
                CommandKeys.LOG.warn("Clipboard placeholder failed: Invalid regex: " + String.valueOf(e), new Object[0]);
                return PlaceholderUtil.fault();
            }
        }
        return clipboard;
    }

    private static String getLastMessage() {
        String lastMsg = (String)class_310.method_1551().field_1705.method_1743().method_1809().peekLast();
        if (lastMsg == null) {
            return PlaceholderUtil.fault();
        }
        return lastMsg;
    }

    private static String getLastCommand() {
        Collection collection = class_310.method_1551().method_52700().method_52696();
        if (collection instanceof class_8623) {
            class_8623 deque = (class_8623)collection;
            String lastCmd = (String)deque.peekLast();
            if (lastCmd != null) {
                return lastCmd;
            }
        } else {
            CommandKeys.LOG.error("Command history not ArrayListDeque", new Object[0]);
        }
        return PlaceholderUtil.fault();
    }

    private static String getPlayerName() {
        return class_310.method_1551().field_1724.method_5477().getString();
    }

    private static String getPmSenderName() {
        if (pmSenderName != null) {
            return pmSenderName;
        }
        int i = 0;
        for (class_303 guiMsg : ((ChatComponentAccessor)class_310.method_1551().field_1705.method_1743()).commandkeys$getAllMessages()) {
            class_2588 tc;
            if (++i > 50) break;
            class_2561 msg = guiMsg.comp_893();
            class_7417 class_74172 = msg.method_10851();
            if (!(class_74172 instanceof class_2588) || !(tc = (class_2588)class_74172).method_11022().contains("commands.message.display.incoming")) continue;
            pmSenderName = ((class_5250)tc.method_11023()[0]).getString();
            break;
        }
        if (pmSenderName == null) {
            CommandKeys.LOG.warn("PmSenderName placeholder failed: No message found: Checked " + i, new Object[0]);
            return PlaceholderUtil.fault();
        }
        return pmSenderName;
    }

    private static class_2338 updatePlayerBlockPos() {
        if (playerBlockPos == null) {
            playerBlockPos = class_310.method_1551().field_1724.method_24515();
        }
        return playerBlockPos;
    }

    private static class_2338 updateLookBlockPos() {
        if (lookBlockPos == null) {
            class_310 mc = class_310.method_1551();
            class_239 result = mc.field_1724.method_5745(Math.max(384.0, (mc.field_1769.method_34812() + 1.0) * 16.0), 0.0f, false);
            if (result.method_17783().equals((Object)class_239.class_240.field_1332)) {
                lookBlockPos = ((class_3965)result).method_17777();
            }
        }
        return lookBlockPos;
    }

    private static class_243 updateLookAngle() {
        if (lookAngle == null) {
            lookAngle = class_310.method_1551().field_1724.method_5720();
        }
        return lookAngle;
    }

    private static String getPlayerBlockPos(String[] args) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null || PlaceholderUtil.updateLookAngle() == null) {
            return PlaceholderUtil.fault();
        }
        int offset = Integer.parseInt(args[1]);
        class_243 playerPos = playerBlockPos.method_61082();
        if (offset != 0) {
            playerPos = PlaceholderUtil.offsetCardinalDirection(playerPos, lookAngle, args[0], offset);
        }
        return String.format("%d %d %d", class_3532.method_15357((double)playerPos.field_1352), class_3532.method_15357((double)playerPos.field_1351), class_3532.method_15357((double)playerPos.field_1350));
    }

    private static String getPlayerBlockX(String[] offset) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(class_3532.method_15375((float)playerBlockPos.method_10263()) + Integer.parseInt(offset[0]));
    }

    private static String getPlayerBlockY(String[] offset) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(class_3532.method_15375((float)playerBlockPos.method_10264()) + Integer.parseInt(offset[0]));
    }

    private static String getPlayerBlockZ(String[] offset) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(class_3532.method_15375((float)playerBlockPos.method_10260()) + Integer.parseInt(offset[0]));
    }

    private static String getLookBlockPos(String[] args) {
        if (PlaceholderUtil.updateLookBlockPos() == null || PlaceholderUtil.updateLookAngle() == null) {
            return PlaceholderUtil.fault();
        }
        int offset = Integer.parseInt(args[1]);
        class_243 playerPos = lookBlockPos.method_61082();
        if (offset != 0) {
            playerPos = PlaceholderUtil.offsetCardinalDirection(playerPos, lookAngle, args[0], offset);
        }
        return String.format("%d %d %d", class_3532.method_15357((double)playerPos.field_1352), class_3532.method_15357((double)playerPos.field_1351), class_3532.method_15357((double)playerPos.field_1350));
    }

    private static String getLookBlockX(String[] offset) {
        if (PlaceholderUtil.updateLookBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(class_3532.method_15375((float)lookBlockPos.method_10263()) + Integer.parseInt(offset[0]));
    }

    private static String getLookBlockY(String[] offset) {
        if (PlaceholderUtil.updateLookBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(class_3532.method_15375((float)lookBlockPos.method_10264()) + Integer.parseInt(offset[0]));
    }

    private static String getLookBlockZ(String[] offset) {
        if (PlaceholderUtil.updateLookBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(class_3532.method_15375((float)lookBlockPos.method_10260()) + Integer.parseInt(offset[0]));
    }

    private static class_243 offsetCardinalDirection(class_243 pos, class_243 facingAngle, String offsetDir, int offset) {
        if (Math.abs(facingAngle.field_1352) >= Math.abs(facingAngle.field_1350)) {
            if (facingAngle.field_1352 >= 0.0) {
                return switch (offsetDir) {
                    case "F" -> new class_243(pos.field_1352 + (double)offset, pos.field_1351, pos.field_1350);
                    case "B" -> new class_243(pos.field_1352 - (double)offset, pos.field_1351, pos.field_1350);
                    case "L" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 - (double)offset);
                    case "R" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 + (double)offset);
                    default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
                };
            }
            return switch (offsetDir) {
                case "F" -> new class_243(pos.field_1352 - (double)offset, pos.field_1351, pos.field_1350);
                case "B" -> new class_243(pos.field_1352 + (double)offset, pos.field_1351, pos.field_1350);
                case "L" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 + (double)offset);
                case "R" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 - (double)offset);
                default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
            };
        }
        if (facingAngle.field_1350 >= 0.0) {
            return switch (offsetDir) {
                case "F" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 + (double)offset);
                case "B" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 - (double)offset);
                case "L" -> new class_243(pos.field_1352 + (double)offset, pos.field_1351, pos.field_1350);
                case "R" -> new class_243(pos.field_1352 - (double)offset, pos.field_1351, pos.field_1350);
                default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
            };
        }
        return switch (offsetDir) {
            case "F" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 - (double)offset);
            case "B" -> new class_243(pos.field_1352, pos.field_1351, pos.field_1350 + (double)offset);
            case "L" -> new class_243(pos.field_1352 - (double)offset, pos.field_1351, pos.field_1350);
            case "R" -> new class_243(pos.field_1352 + (double)offset, pos.field_1351, pos.field_1350);
            default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
        };
    }

    static {
        SIMPLE_PLACEHOLDERS = new SimplePlaceholder[]{new SimplePlaceholder("%lastsent%", PlaceholderUtil::getLastMessage), new SimplePlaceholder("%lastcmd%", PlaceholderUtil::getLastCommand), new SimplePlaceholder("%clipboard%", () -> PlaceholderUtil.getClipboard(null)), new SimplePlaceholder("%myname%", PlaceholderUtil::getPlayerName), new SimplePlaceholder("%pmsender%", PlaceholderUtil::getPmSenderName), new SimplePlaceholder("%pos%", () -> PlaceholderUtil.getPlayerBlockPos(new String[]{"0", "0"})), new SimplePlaceholder("%x%", () -> PlaceholderUtil.getPlayerBlockX(new String[]{"0"})), new SimplePlaceholder("%y%", () -> PlaceholderUtil.getPlayerBlockY(new String[]{"0"})), new SimplePlaceholder("%z%", () -> PlaceholderUtil.getPlayerBlockZ(new String[]{"0"})), new SimplePlaceholder("%lpos%", () -> PlaceholderUtil.getLookBlockPos(new String[]{"0", "0"})), new SimplePlaceholder("%lx%", () -> PlaceholderUtil.getLookBlockX(new String[]{"0"})), new SimplePlaceholder("%ly%", () -> PlaceholderUtil.getLookBlockY(new String[]{"0"})), new SimplePlaceholder("%lz%", () -> PlaceholderUtil.getLookBlockZ(new String[]{"0"}))};
        REGEX_PLACEHOLDERS = new Placeholder[]{new Placeholder(Pattern.compile("%#(.*)%"), 1, PlaceholderUtil::getRecentChat), new Placeholder(Pattern.compile("%clipboard#(.*)%"), 1, PlaceholderUtil::getClipboard), new Placeholder(Pattern.compile("%pos([FBLR])(\\d+)%"), 2, PlaceholderUtil::getPlayerBlockPos), new Placeholder(Pattern.compile("%x([+-]\\d+)%"), 1, PlaceholderUtil::getPlayerBlockX), new Placeholder(Pattern.compile("%y([+-]\\d+)%"), 1, PlaceholderUtil::getPlayerBlockY), new Placeholder(Pattern.compile("%z([+-]\\d+)%"), 1, PlaceholderUtil::getPlayerBlockZ), new Placeholder(Pattern.compile("%lpos([FBLR])(\\d+)%"), 2, PlaceholderUtil::getLookBlockPos), new Placeholder(Pattern.compile("%lx([+-]\\d+)%"), 1, PlaceholderUtil::getLookBlockX), new Placeholder(Pattern.compile("%ly([+-]\\d+)%"), 1, PlaceholderUtil::getLookBlockY), new Placeholder(Pattern.compile("%lz([+-]\\d+)%"), 1, PlaceholderUtil::getLookBlockZ)};
    }

    private record SimplePlaceholder(String string, Supplier<String> supplier) {
        public String process(String message) {
            if (!message.contains(this.string)) {
                return message;
            }
            String replacement = this.supplier.get();
            return message.replaceAll(this.string, replacement);
        }
    }

    private record Placeholder(Pattern pattern, int groups, Function<String[], String> operator) {
        public String process(String message) {
            Matcher matcher = this.pattern.matcher(message);
            while (matcher.find()) {
                String[] args = new String[this.groups];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = matcher.group(i + 1);
                }
                message = matcher.replaceFirst(this.operator.apply(args));
            }
            return message;
        }
    }
}

