/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.field;

import dev.terminalmc.commandkeys.util.Localization;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextField
extends EditBox {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = -2039584;
    public static final int TEXT_COLOR_ERROR = -43691;
    public static final int TEXT_COLOR_HINT = -11184811;
    public static final int TEXT_COLOR_PREVIEW = -5592406;
    private final Font font;
    public final List<@NotNull Validator> validators = new ArrayList<Validator>();
    public boolean lenient = true;
    private int normalTextColor = -2039584;
    @Nullable
    private Tooltip normalTooltip;
    @Nullable
    private Tooltip errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private double dragOriginX;
    private int dragOriginPos;
    private long lastClickTime;
    private int chainedClicks;

    public TextField(int x, int y, int width, int height) {
        this(Minecraft.getInstance().font, x, y, width, height, (Component)Component.empty(), null);
    }

    public TextField(int x, int y, int width, int height, @Nullable Validator validator) {
        this(Minecraft.getInstance().font, x, y, width, height, (Component)Component.empty(), validator);
    }

    public TextField(Font font, int x, int y, int width, int height, Component msg, @Nullable Validator validator) {
        super(font, x, y, width, height, msg);
        this.font = font;
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public TextField withValidator(@NotNull Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public TextField posIntValidator() {
        this.validators.add(new Validator.PosInt());
        return this;
    }

    public TextField strict() {
        this.lenient = false;
        return this;
    }

    public TextField lenient() {
        this.lenient = true;
        return this;
    }

    public void setResponder(@NotNull Consumer<String> responder) {
        super.setResponder(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (Validator v : this.validators) {
            Optional<Component> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = Tooltip.create((Component)error.get());
            super.setTooltip(this.errorTooltip);
            super.setTextColor(-43691);
            return false;
        }
        this.errorTooltip = null;
        super.setTextColor(this.normalTextColor);
        super.setTooltip(this.normalTooltip);
        return true;
    }

    public void setHint(@NotNull Component hint) {
        super.setHint((Component)hint.copy().withColor(-11184811));
    }

    public void setTooltip(@Nullable Tooltip tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.setTooltip(tooltip);
        }
    }

    public void setTextColor(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            super.setTextColor(color);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (super.mouseClicked(event, doubleClick)) {
            long time = Util.getMillis();
            if (this.lastClickTime + 250L > time) {
                switch (++this.chainedClicks) {
                    case 1: {
                        int pos;
                        int start = pos = this.getCursorPosition();
                        if (pos < 0) {
                            start = 0;
                        } else if (pos >= this.getValue().length() || this.getValue().charAt(pos) == ' ' || pos > 0 && this.getValue().charAt(pos - 1) != ' ') {
                            start = this.getWordPosition(-1);
                        }
                        int end = this.getWordPosition(1);
                        this.moveCursorTo(start, false);
                        this.moveCursorTo(end, true);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.moveCursorToEnd(false);
                        this.setHighlightPos(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        this.setHighlightPos(this.getCursorPosition());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            this.dragOriginX = event.x();
            this.dragOriginPos = this.getCursorPosition();
            return true;
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        if (event.button() != 0) {
            return false;
        }
        String str = this.getValue();
        if (event.x() < this.dragOriginX) {
            String subLeft = str.substring(0, this.dragOriginPos);
            int offsetChars = this.font.plainSubstrByWidth(subLeft, Mth.floor((double)(this.dragOriginX - event.x())), true).length();
            this.moveCursorTo(this.dragOriginPos - offsetChars, true);
        } else {
            String subRight = str.substring(this.dragOriginPos);
            int offsetChars = this.font.plainSubstrByWidth(subRight, Mth.floor((double)(event.x() - this.dragOriginX)), false).length();
            this.moveCursorTo(this.dragOriginPos + offsetChars, true);
        }
        return true;
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                    this.history.removeLast();
                }
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean keyPressed(KeyEvent event) {
        if (!super.keyPressed(event)) {
            if (TextField.isUndo(event)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(event)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.setValue(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.setValue(this.history.get(++this.historyIndex));
        }
    }

    public static boolean isUndo(KeyEvent event) {
        return event.key() == 90 && event.hasControlDown() && !event.hasShiftDown() && !event.hasAltDown();
    }

    public static boolean isRedo(KeyEvent event) {
        return event.key() == 89 && event.hasControlDown() && !event.hasShiftDown() && !event.hasAltDown();
    }

    @FunctionalInterface
    public static interface Validator {
        public Optional<Component> validate(String var1);

        public static class PosInt
        implements Validator {
            @Override
            public Optional<Component> validate(String str) {
                try {
                    if (Integer.parseInt(str) < 0) {
                        throw new NumberFormatException();
                    }
                    return Optional.empty();
                }
                catch (NumberFormatException ignored) {
                    return Optional.of(Localization.localized("ui", "field.error.pos_int", new Object[0]).withStyle(ChatFormatting.RED));
                }
            }
        }
    }
}

