/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.widget.list.DragReorderList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.mixin.accessor.KeyMappingAccessor;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MacroBindList
extends DragReorderList {
    @NotNull
    protected Profile profile;
    @Nullable
    private Macro macro;
    @Nullable
    private Keybind keybind;
    @Nullable
    private InputConstants.Key heldKey;
    @Nullable
    private Keybind sendKeybind;

    public MacroBindList(Minecraft mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpace, @NotNull Profile profile, Map<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>> clsFunMap) {
        super(mc, width, height, y, entryWidth, entryHeight, entrySpace, clsFunMap);
        this.profile = profile;
    }

    @Override
    public void init() {
        super.init();
        this.macro = null;
        this.keybind = null;
        this.heldKey = null;
        this.sendKeybind = null;
    }

    protected void setSelected(@NotNull Macro macro, @NotNull Keybind keybind) {
        if (!this.profile.getMacros().contains(macro)) {
            throw new IllegalArgumentException("Specified macro does not exist in profile.");
        }
        if (!macro.ownsKeybind(keybind)) {
            throw new IllegalArgumentException("Specified keybind not used by specified macro.");
        }
        this.macro = macro;
        this.keybind = keybind;
    }

    @Override
    public boolean keyPressed(InputConstants.Key key) {
        if (this.macro != null && this.keybind != null) {
            if (key.getValue() != 256) {
                if (this.heldKey == null) {
                    this.heldKey = key;
                } else if (key != this.heldKey) {
                    this.profile.setKey(this.macro, this.keybind, key);
                    this.profile.setLimitKey(this.macro, this.keybind, this.heldKey);
                    this.init();
                }
                return false;
            }
            this.profile.setKey(this.macro, this.keybind, InputConstants.UNKNOWN);
            this.profile.setLimitKey(this.macro, this.keybind, InputConstants.UNKNOWN);
            this.init();
            return true;
        }
        if (this.getSelected() == null && CommandKeys.inGame() && !key.equals((Object)((KeyMappingAccessor)CommandKeys.CONFIG_KEY).commandkeys$getKey())) {
            Collection keybinds = this.profile.keybindMap.get((Object)key);
            Keybind limitedKb = null;
            Keybind monoKb = null;
            for (Keybind kb : keybinds) {
                if (kb.isLimitKeyDown()) {
                    limitedKb = kb;
                    break;
                }
                if (!kb.getLimitKey().equals((Object)InputConstants.UNKNOWN)) continue;
                monoKb = kb;
            }
            this.sendKeybind = limitedKb != null ? limitedKb : monoKb;
        }
        return false;
    }

    @Override
    public boolean keyReleased(InputConstants.Key key) {
        if (this.macro != null && this.keybind != null) {
            if (this.heldKey == key) {
                this.profile.setKey(this.macro, this.keybind, key);
                this.profile.setLimitKey(this.macro, this.keybind, InputConstants.UNKNOWN);
                this.init();
                return true;
            }
        } else if (this.sendKeybind != null && this.sendKeybind.getKey().equals((Object)key)) {
            Collection macros = this.profile.macroMap.get((Object)this.sendKeybind);
            if (!macros.isEmpty()) {
                this.screen.onClose();
                this.minecraft.setScreen(null);
                macros.forEach(macro -> macro.trigger(this.sendKeybind, false));
                return true;
            }
            this.sendKeybind = null;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(InputConstants.Key key) {
        return this.keyPressed(key);
    }

    @Override
    public boolean mouseReleased(InputConstants.Key key) {
        return this.keyReleased(key);
    }

    public void openMinecraftControlsScreen() {
        this.minecraft.setScreen((Screen)new KeyBindsScreen((Screen)this.screen, this.minecraft.options));
    }
}

