/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.util;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.mixin.accessor.ChatComponentAccessor;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.ArrayListDeque;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderUtil {
    private static int faults;
    @Nullable
    private static BlockPos playerBlockPos;
    @Nullable
    private static BlockPos lookBlockPos;
    @Nullable
    private static Vec3 lookAngle;
    @Nullable
    private static String pmSenderName;
    private static final SimplePlaceholder[] SIMPLE_PLACEHOLDERS;
    private static final Placeholder[] REGEX_PLACEHOLDERS;

    public static Pair<String, Integer> replace(String message) {
        if (!message.contains("%")) {
            return new Pair((Object)message, (Object)0);
        }
        PlaceholderUtil.reset();
        for (SimplePlaceholder simplePlaceholder : SIMPLE_PLACEHOLDERS) {
            message = simplePlaceholder.process(message);
        }
        for (Record record : REGEX_PLACEHOLDERS) {
            message = ((Placeholder)record).process(message);
        }
        return new Pair((Object)message, (Object)faults);
    }

    private static void reset() {
        faults = 0;
        playerBlockPos = null;
        lookBlockPos = null;
        lookAngle = null;
        pmSenderName = null;
    }

    private static String fault() {
        ++faults;
        return "?";
    }

    private static String getRecentChat(@NotNull String[] pattern) {
        try {
            Pattern regex = Pattern.compile(pattern[0]);
            int i = 0;
            for (GuiMessage guiMsg : ((ChatComponentAccessor)Minecraft.getInstance().gui.getChat()).commandkeys$getAllMessages()) {
                if (++i > 50) break;
                Matcher matcher = regex.matcher(guiMsg.content().getString());
                if (!matcher.find()) continue;
                try {
                    return matcher.group(1);
                }
                catch (IndexOutOfBoundsException e) {
                    CommandKeys.LOG.error("Recent chat placeholder failed: Group 1 not available: " + String.valueOf(e), new Object[0]);
                    return PlaceholderUtil.fault();
                }
            }
            CommandKeys.LOG.warn("Recent chat placeholder failed: No message found: Checked " + i, new Object[0]);
        }
        catch (PatternSyntaxException e) {
            CommandKeys.LOG.error("Recent chat placeholder failed: Invalid regex: " + String.valueOf(e), new Object[0]);
        }
        return PlaceholderUtil.fault();
    }

    private static String getClipboard(String @Nullable [] pattern) {
        String clipboard = Minecraft.getInstance().keyboardHandler.getClipboard();
        if (clipboard.isEmpty()) {
            CommandKeys.LOG.warn("Clipboard placeholder failed: No data", new Object[0]);
            return PlaceholderUtil.fault();
        }
        if (pattern != null) {
            try {
                if (!Pattern.compile(pattern[0]).matcher(clipboard).find()) {
                    CommandKeys.LOG.warn("Clipboard placeholder failed: Non-matching regex", new Object[0]);
                    return PlaceholderUtil.fault();
                }
            }
            catch (PatternSyntaxException e) {
                CommandKeys.LOG.warn("Clipboard placeholder failed: Invalid regex: " + String.valueOf(e), new Object[0]);
                return PlaceholderUtil.fault();
            }
        }
        return clipboard;
    }

    private static String getLastMessage() {
        String lastMsg = (String)Minecraft.getInstance().gui.getChat().getRecentChat().peekLast();
        if (lastMsg == null) {
            return PlaceholderUtil.fault();
        }
        return lastMsg;
    }

    private static String getLastCommand() {
        Collection collection = Minecraft.getInstance().commandHistory().history();
        if (collection instanceof ArrayListDeque) {
            ArrayListDeque deque = (ArrayListDeque)collection;
            String lastCmd = (String)deque.peekLast();
            if (lastCmd != null) {
                return lastCmd;
            }
        } else {
            CommandKeys.LOG.error("Command history not ArrayListDeque", new Object[0]);
        }
        return PlaceholderUtil.fault();
    }

    private static String getPlayerName() {
        return Minecraft.getInstance().player.getName().getString();
    }

    private static String getPmSenderName() {
        if (pmSenderName != null) {
            return pmSenderName;
        }
        int i = 0;
        for (GuiMessage guiMsg : ((ChatComponentAccessor)Minecraft.getInstance().gui.getChat()).commandkeys$getAllMessages()) {
            TranslatableContents tc;
            if (++i > 50) break;
            Component msg = guiMsg.content();
            ComponentContents componentContents = msg.getContents();
            if (!(componentContents instanceof TranslatableContents) || !(tc = (TranslatableContents)componentContents).getKey().contains("commands.message.display.incoming")) continue;
            pmSenderName = ((MutableComponent)tc.getArgs()[0]).getString();
            break;
        }
        if (pmSenderName == null) {
            CommandKeys.LOG.warn("PmSenderName placeholder failed: No message found: Checked " + i, new Object[0]);
            return PlaceholderUtil.fault();
        }
        return pmSenderName;
    }

    private static BlockPos updatePlayerBlockPos() {
        if (playerBlockPos == null) {
            playerBlockPos = Minecraft.getInstance().player.blockPosition();
        }
        return playerBlockPos;
    }

    private static BlockPos updateLookBlockPos() {
        if (lookBlockPos == null) {
            Minecraft mc = Minecraft.getInstance();
            HitResult result = mc.player.pick(Math.max(384.0, (mc.levelRenderer.getLastViewDistance() + 1.0) * 16.0), 0.0f, false);
            if (result.getType().equals((Object)HitResult.Type.BLOCK)) {
                lookBlockPos = ((BlockHitResult)result).getBlockPos();
            }
        }
        return lookBlockPos;
    }

    private static Vec3 updateLookAngle() {
        if (lookAngle == null) {
            lookAngle = Minecraft.getInstance().player.getLookAngle();
        }
        return lookAngle;
    }

    private static String getPlayerBlockPos(String[] args) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null || PlaceholderUtil.updateLookAngle() == null) {
            return PlaceholderUtil.fault();
        }
        int offset = Integer.parseInt(args[1]);
        Vec3 playerPos = playerBlockPos.getBottomCenter();
        if (offset != 0) {
            playerPos = PlaceholderUtil.offsetCardinalDirection(playerPos, lookAngle, args[0], offset);
        }
        return String.format("%d %d %d", Mth.floor((double)playerPos.x), Mth.floor((double)playerPos.y), Mth.floor((double)playerPos.z));
    }

    private static String getPlayerBlockX(String[] offset) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(Mth.floor((float)playerBlockPos.getX()) + Integer.parseInt(offset[0]));
    }

    private static String getPlayerBlockY(String[] offset) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(Mth.floor((float)playerBlockPos.getY()) + Integer.parseInt(offset[0]));
    }

    private static String getPlayerBlockZ(String[] offset) {
        if (PlaceholderUtil.updatePlayerBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(Mth.floor((float)playerBlockPos.getZ()) + Integer.parseInt(offset[0]));
    }

    private static String getLookBlockPos(String[] args) {
        if (PlaceholderUtil.updateLookBlockPos() == null || PlaceholderUtil.updateLookAngle() == null) {
            return PlaceholderUtil.fault();
        }
        int offset = Integer.parseInt(args[1]);
        Vec3 playerPos = lookBlockPos.getBottomCenter();
        if (offset != 0) {
            playerPos = PlaceholderUtil.offsetCardinalDirection(playerPos, lookAngle, args[0], offset);
        }
        return String.format("%d %d %d", Mth.floor((double)playerPos.x), Mth.floor((double)playerPos.y), Mth.floor((double)playerPos.z));
    }

    private static String getLookBlockX(String[] offset) {
        if (PlaceholderUtil.updateLookBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(Mth.floor((float)lookBlockPos.getX()) + Integer.parseInt(offset[0]));
    }

    private static String getLookBlockY(String[] offset) {
        if (PlaceholderUtil.updateLookBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(Mth.floor((float)lookBlockPos.getY()) + Integer.parseInt(offset[0]));
    }

    private static String getLookBlockZ(String[] offset) {
        if (PlaceholderUtil.updateLookBlockPos() == null) {
            return PlaceholderUtil.fault();
        }
        return String.valueOf(Mth.floor((float)lookBlockPos.getZ()) + Integer.parseInt(offset[0]));
    }

    private static Vec3 offsetCardinalDirection(Vec3 pos, Vec3 facingAngle, String offsetDir, int offset) {
        if (Math.abs(facingAngle.x) >= Math.abs(facingAngle.z)) {
            if (facingAngle.x >= 0.0) {
                return switch (offsetDir) {
                    case "F" -> new Vec3(pos.x + (double)offset, pos.y, pos.z);
                    case "B" -> new Vec3(pos.x - (double)offset, pos.y, pos.z);
                    case "L" -> new Vec3(pos.x, pos.y, pos.z - (double)offset);
                    case "R" -> new Vec3(pos.x, pos.y, pos.z + (double)offset);
                    default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
                };
            }
            return switch (offsetDir) {
                case "F" -> new Vec3(pos.x - (double)offset, pos.y, pos.z);
                case "B" -> new Vec3(pos.x + (double)offset, pos.y, pos.z);
                case "L" -> new Vec3(pos.x, pos.y, pos.z + (double)offset);
                case "R" -> new Vec3(pos.x, pos.y, pos.z - (double)offset);
                default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
            };
        }
        if (facingAngle.z >= 0.0) {
            return switch (offsetDir) {
                case "F" -> new Vec3(pos.x, pos.y, pos.z + (double)offset);
                case "B" -> new Vec3(pos.x, pos.y, pos.z - (double)offset);
                case "L" -> new Vec3(pos.x + (double)offset, pos.y, pos.z);
                case "R" -> new Vec3(pos.x - (double)offset, pos.y, pos.z);
                default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
            };
        }
        return switch (offsetDir) {
            case "F" -> new Vec3(pos.x, pos.y, pos.z - (double)offset);
            case "B" -> new Vec3(pos.x, pos.y, pos.z + (double)offset);
            case "L" -> new Vec3(pos.x - (double)offset, pos.y, pos.z);
            case "R" -> new Vec3(pos.x + (double)offset, pos.y, pos.z);
            default -> throw new IllegalArgumentException("Disallowed value " + offsetDir);
        };
    }

    static {
        SIMPLE_PLACEHOLDERS = new SimplePlaceholder[]{new SimplePlaceholder("%lastsent%", PlaceholderUtil::getLastMessage), new SimplePlaceholder("%lastcmd%", PlaceholderUtil::getLastCommand), new SimplePlaceholder("%clipboard%", () -> PlaceholderUtil.getClipboard(null)), new SimplePlaceholder("%myname%", PlaceholderUtil::getPlayerName), new SimplePlaceholder("%pmsender%", PlaceholderUtil::getPmSenderName), new SimplePlaceholder("%pos%", () -> PlaceholderUtil.getPlayerBlockPos(new String[]{"0", "0"})), new SimplePlaceholder("%x%", () -> PlaceholderUtil.getPlayerBlockX(new String[]{"0"})), new SimplePlaceholder("%y%", () -> PlaceholderUtil.getPlayerBlockY(new String[]{"0"})), new SimplePlaceholder("%z%", () -> PlaceholderUtil.getPlayerBlockZ(new String[]{"0"})), new SimplePlaceholder("%lpos%", () -> PlaceholderUtil.getLookBlockPos(new String[]{"0", "0"})), new SimplePlaceholder("%lx%", () -> PlaceholderUtil.getLookBlockX(new String[]{"0"})), new SimplePlaceholder("%ly%", () -> PlaceholderUtil.getLookBlockY(new String[]{"0"})), new SimplePlaceholder("%lz%", () -> PlaceholderUtil.getLookBlockZ(new String[]{"0"}))};
        REGEX_PLACEHOLDERS = new Placeholder[]{new Placeholder(Pattern.compile("%#(.*)%"), 1, PlaceholderUtil::getRecentChat), new Placeholder(Pattern.compile("%clipboard#(.*)%"), 1, PlaceholderUtil::getClipboard), new Placeholder(Pattern.compile("%pos([FBLR])(\\d+)%"), 2, PlaceholderUtil::getPlayerBlockPos), new Placeholder(Pattern.compile("%x([+-]\\d+)%"), 1, PlaceholderUtil::getPlayerBlockX), new Placeholder(Pattern.compile("%y([+-]\\d+)%"), 1, PlaceholderUtil::getPlayerBlockY), new Placeholder(Pattern.compile("%z([+-]\\d+)%"), 1, PlaceholderUtil::getPlayerBlockZ), new Placeholder(Pattern.compile("%lpos([FBLR])(\\d+)%"), 2, PlaceholderUtil::getLookBlockPos), new Placeholder(Pattern.compile("%lx([+-]\\d+)%"), 1, PlaceholderUtil::getLookBlockX), new Placeholder(Pattern.compile("%ly([+-]\\d+)%"), 1, PlaceholderUtil::getLookBlockY), new Placeholder(Pattern.compile("%lz([+-]\\d+)%"), 1, PlaceholderUtil::getLookBlockZ)};
    }

    private record SimplePlaceholder(String string, Supplier<String> supplier) {
        public String process(String message) {
            if (!message.contains(this.string)) {
                return message;
            }
            String replacement = this.supplier.get();
            return message.replaceAll(this.string, replacement);
        }
    }

    private record Placeholder(Pattern pattern, int groups, Function<String[], String> operator) {
        public String process(String message) {
            Matcher matcher = this.pattern.matcher(message);
            while (matcher.find()) {
                String[] args = new String[this.groups];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = matcher.group(i + 1);
                }
                message = matcher.replaceFirst(this.operator.apply(args));
            }
            return message;
        }
    }
}

