/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragReorderList
extends OptionList {
    private final Map<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>> clsFunMap;
    private int dragSourceSlot = -1;
    private Class<? extends OptionList.Entry> dragClass;
    @Nullable
    private Class<? extends OptionList.Entry> trailerClass;
    boolean hasTrailer;

    public DragReorderList(class_310 mc, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing, Map<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>> clsFunMap) {
        super(mc, width, height, top, bottom, entryWidth, entryHeight, entrySpacing);
        this.clsFunMap = clsFunMap;
    }

    protected void startDragging(OptionList.Entry entry, @Nullable Class<? extends OptionList.Entry> trailerClass, boolean hasTrailer) {
        if (this.validate(entry, trailerClass, hasTrailer)) {
            this.dragSourceSlot = this.method_25396().indexOf((Object)entry);
            this.dragClass = ((Object)((Object)entry)).getClass();
            this.trailerClass = trailerClass;
            this.hasTrailer = hasTrailer;
        }
    }

    private boolean validate(OptionList.Entry entry, @Nullable Class<? extends OptionList.Entry> trailerClass, boolean hasTrailer) {
        Class<?> cls = ((Object)((Object)entry)).getClass();
        int index = this.method_25396().indexOf((Object)entry);
        if (index == -1) {
            CommandKeys.LOG.error("Cannot drag entry of type '{}'. Not present in list.", new Object[0]);
            return false;
        }
        if (cls.equals(trailerClass)) {
            CommandKeys.LOG.error("Cannot drag entry of type '{}' at index {}. Identical trailer class.", cls, index);
            return false;
        }
        if (!this.clsFunMap.containsKey(((Object)((Object)entry)).getClass())) {
            CommandKeys.LOG.error("Cannot drag entry of type '{}' at index {}. Allowed types: {}", cls, index, this.clsFunMap.keySet().stream().map(Class::getName).collect(Collectors.joining(", ")));
            return false;
        }
        if (hasTrailer) {
            if (index < this.method_25396().size()) {
                Class<?> trailerCls = ((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(index + 1))))).getClass();
                if (!trailerCls.equals(OptionList.Entry.Space.class) && !trailerCls.equals(trailerClass)) {
                    CommandKeys.LOG.error("Cannot drag entry of type '{}' at index {}. hasTrailer is true but trailer is class '{}'. Allowed trailer types: '{}', '{}'.", OptionList.Entry.Space.class, trailerClass);
                    return false;
                }
            } else {
                CommandKeys.LOG.error("Cannot drag entry of type '{}' at index {}. hasTrailer is true but entry is the last list element.", new Object[0]);
                return false;
            }
        }
        int start = this.getListStart(cls);
        int end = this.getListEnd(cls);
        for (int i = start; i <= end; ++i) {
            if (((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(i))))).getClass().equals(cls)) {
                Class<?> trailerCls = ((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(i + 1))))).getClass();
                if (!trailerCls.equals(trailerClass) && !trailerCls.equals(OptionList.Entry.Space.class)) continue;
                ++i;
                continue;
            }
            CommandKeys.LOG.error("Cannot drag entry of type '{}' at index {}. Encountered unexpected type '{}' at index {} breaking contiguous sub-list from {} to {}. Allowed trailer types: '{}', '{}'.", cls, this.method_25396().indexOf((Object)entry), ((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(i))))).getClass(), i, start, end, OptionList.Entry.Space.class, trailerClass);
            return false;
        }
        return true;
    }

    private void cancelDrag() {
        this.dragSourceSlot = -1;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (this.dragSourceSlot != -1) {
            super.method_44397(graphics, mouseX, mouseY, delta, this.dragSourceSlot, mouseX, mouseY, this.entryWidth, this.entryHeight);
            if (this.hasTrailer) {
                super.method_44397(graphics, mouseX, mouseY, delta, this.dragSourceSlot + 1, mouseX, mouseY + this.field_22741, this.entryWidth, this.entryHeight);
            }
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragSourceSlot != -1 && button == 0) {
            this.dropDragged(mouseY);
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private int getListStart(Class<? extends OptionList.Entry> cls) {
        for (int i = 0; i < this.method_25396().size(); ++i) {
            if (!((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(i))))).getClass().equals(cls)) continue;
            return i;
        }
        throw new IllegalArgumentException("getListStart could not find any element of type " + cls.getName());
    }

    private int getListEnd(Class<? extends OptionList.Entry> cls) {
        for (int i = this.method_25396().size() - 1; i >= 0; --i) {
            if (!((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(i))))).getClass().equals(cls)) continue;
            return i;
        }
        throw new IllegalArgumentException("getListEnd could not find any element of type " + cls.getName());
    }

    private int getOffset(int index) {
        int i = 0;
        int offset = 0;
        for (OptionList.Entry entry : this.method_25396()) {
            if (!((Object)((Object)entry)).getClass().equals(this.dragClass)) {
                ++offset;
            }
            if (i++ != index) continue;
            return offset;
        }
        throw new IllegalArgumentException(String.format("Index out of range for class '%s' and index %s", this.dragClass, index));
    }

    private void dropDragged(double mouseY) {
        int hoveredSlot;
        int end;
        int start = this.getListStart(this.dragClass);
        if (start == (end = this.getListEnd(this.dragClass))) {
            this.cancelDrag();
            return;
        }
        @Nullable OptionList.Entry hoveredEntry = (OptionList.Entry)this.method_25308((double)this.field_19088 + (double)this.field_22742 / 2.0, mouseY);
        if (hoveredEntry == null && (mouseY > (double)this.field_19086 || mouseY > (double)(this.field_19085 + this.field_22741 * this.method_25396().size()))) {
            hoveredEntry = (OptionList.Entry)((Object)this.method_25396().get(end));
        }
        if (hoveredEntry == null) {
            hoveredSlot = start - 1;
        } else {
            hoveredSlot = this.method_25396().indexOf((Object)hoveredEntry);
            if (hoveredSlot <= start - 1) {
                hoveredSlot = start - 1;
            } else if (hoveredSlot > end) {
                hoveredSlot = end;
            } else if (((Object)((Object)hoveredEntry)).getClass().equals(OptionList.Entry.Space.class) || ((Object)((Object)hoveredEntry)).getClass().equals(this.trailerClass)) {
                if (!((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(--hoveredSlot))))).getClass().equals(this.dragClass)) {
                    throw new IllegalStateException(String.format("Invalid list structure: trailer parent class '%s', expected '%s'", ((Object)((Object)((OptionList.Entry)((Object)this.method_25396().get(hoveredSlot))))).getClass(), this.dragClass));
                }
            } else if (!((Object)((Object)hoveredEntry)).getClass().equals(this.dragClass)) {
                throw new IllegalStateException(String.format("Invalid list structure: found class %s, expected %s or %s", ((Object)((Object)hoveredEntry)).getClass(), this.dragClass, this.trailerClass));
            }
        }
        if (hoveredSlot > this.dragSourceSlot || hoveredSlot < this.dragSourceSlot - 1) {
            int destIndex;
            int sourceIndex = this.dragSourceSlot - this.getOffset(this.dragSourceSlot);
            if (sourceIndex > (destIndex = hoveredSlot - this.getOffset(hoveredSlot))) {
                ++destIndex;
            }
            if (this.clsFunMap.get(this.dragClass).apply(sourceIndex, destIndex).booleanValue()) {
                this.init();
            }
        }
        this.cancelDrag();
    }
}

