/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.widget.list.DragReorderList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.mixin.accessor.KeyMappingAccessor;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_6599;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MacroBindList
extends DragReorderList {
    @NotNull
    protected Profile profile;
    @Nullable
    private Macro macro;
    @Nullable
    private Keybind keybind;
    @Nullable
    private class_3675.class_306 heldKey;
    @Nullable
    private Keybind sendKeybind;

    public MacroBindList(class_310 mc, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpace, @NotNull Profile profile, Map<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>> clsFunMap) {
        super(mc, width, height, top, bottom, entryWidth, entryHeight, entrySpace, clsFunMap);
        this.profile = profile;
    }

    @Override
    public void init() {
        super.init();
        this.macro = null;
        this.keybind = null;
        this.heldKey = null;
        this.sendKeybind = null;
    }

    protected void setSelected(@NotNull Macro macro, @NotNull Keybind keybind) {
        if (!this.profile.getMacros().contains(macro)) {
            throw new IllegalArgumentException("Specified macro does not exist in profile.");
        }
        if (!macro.ownsKeybind(keybind)) {
            throw new IllegalArgumentException("Specified keybind not used by specified macro.");
        }
        this.macro = macro;
        this.keybind = keybind;
    }

    @Override
    public boolean keyPressed(class_3675.class_306 key) {
        if (this.macro != null && this.keybind != null) {
            if (key.method_1444() != 256) {
                if (this.heldKey == null) {
                    this.heldKey = key;
                } else if (key != this.heldKey) {
                    this.profile.setKey(this.macro, this.keybind, key);
                    this.profile.setLimitKey(this.macro, this.keybind, this.heldKey);
                    this.init();
                }
                return false;
            }
            this.profile.setKey(this.macro, this.keybind, class_3675.field_16237);
            this.profile.setLimitKey(this.macro, this.keybind, class_3675.field_16237);
            this.init();
            return true;
        }
        if (this.method_25334() == null && CommandKeys.inGame() && !key.equals((Object)((KeyMappingAccessor)CommandKeys.CONFIG_KEY).commandkeys$getKey())) {
            Collection keybinds = this.profile.keybindMap.get((Object)key);
            Keybind limitedKb = null;
            Keybind monoKb = null;
            for (Keybind kb : keybinds) {
                if (kb.isLimitKeyDown()) {
                    limitedKb = kb;
                    break;
                }
                if (!kb.getLimitKey().equals((Object)class_3675.field_16237)) continue;
                monoKb = kb;
            }
            this.sendKeybind = limitedKb != null ? limitedKb : monoKb;
        }
        return false;
    }

    @Override
    public boolean keyReleased(class_3675.class_306 key) {
        if (this.macro != null && this.keybind != null) {
            if (this.heldKey == key) {
                this.profile.setKey(this.macro, this.keybind, key);
                this.profile.setLimitKey(this.macro, this.keybind, class_3675.field_16237);
                this.init();
                return true;
            }
        } else if (this.sendKeybind != null && this.sendKeybind.getKey().equals((Object)key)) {
            Collection macros = this.profile.macroMap.get((Object)this.sendKeybind);
            if (!macros.isEmpty()) {
                this.screen.method_25419();
                this.field_22740.method_1507(null);
                macros.forEach(macro -> macro.trigger(this.sendKeybind, false));
                return true;
            }
            this.sendKeybind = null;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(class_3675.class_306 key) {
        return this.keyPressed(key);
    }

    @Override
    public boolean mouseReleased(class_3675.class_306 key) {
        return this.keyReleased(key);
    }

    public void openMinecraftControlsScreen() {
        this.field_22740.method_1507((class_437)new class_6599((class_437)this.screen, this.field_22740.field_1690));
    }
}

