/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import dev.terminalmc.commandkeys.gui.widget.field.FakeTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.gui.widget.list.ProfileOptionList;
import dev.terminalmc.commandkeys.util.Localization;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class MainOptionList
extends OptionList {
    @Nullable
    private Profile editingProfile;

    public MainOptionList(class_310 mc, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpace, @Nullable Profile editingProfile) {
        super(mc, width, height, top, bottom, entryWidth, entryHeight, entrySpace);
        this.editingProfile = editingProfile;
    }

    @Override
    protected void addEntries() {
        boolean inGame = CommandKeys.inGame();
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)(inGame ? Localization.localized("option", "main.profiles.activate", new Object[0]) : Localization.localized("option", "main.profiles", "\u2139")), inGame ? null : class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
        int i = 0;
        for (Profile profile : Config.get().getProfiles()) {
            this.method_25321((class_350.class_351)new Entry.ProfileOptions(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, profile, i, inGame));
            if (profile.equals(this.editingProfile)) {
                this.method_25321((class_350.class_351)new Entry.ProfileName(this.dynEntryX, this.dynEntryWidth, this.entryHeight, profile));
                for (String address : profile.getLinks()) {
                    this.method_25321((class_350.class_351)new Entry.ProfileLink(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, profile, address));
                }
            }
            if (i++ != 0 || !inGame) continue;
            this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "main.profiles.other", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.tooltip", new Object[0])), 500));
        }
        this.method_25321((class_350.class_351)new OptionList.Entry.ActionButton(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)class_2561.method_43470((String)"+"), null, -1, button -> {
            this.editingProfile = Config.get().addNewProfile();
            this.init();
        }));
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "main.default", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "main.default.tooltip", new Object[0])), 500));
        this.method_25321((class_350.class_351)new Entry.DefaultOptions1(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.method_25321((class_350.class_351)new Entry.DefaultOptions2(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "main.ratelimit", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "main.ratelimit.tooltip", new Object[0])), 500));
        this.method_25321((class_350.class_351)new Entry.Ratelimit(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "main.lengthlimit", "\u2139"), class_7919.method_47407((class_2561)Localization.localized("option", "main.lengthlimit.tooltip", new Object[0])), 500));
        this.method_25321((class_350.class_351)new Entry.LengthLimit(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
    }

    public void openProfileOptions(Profile profile) {
        this.mc.method_1507((class_437)new OptionScreen((class_437)this.screen, (class_2561)Localization.localized("option", "profile", profile.getDisplayName()), new ProfileOptionList(this.mc, this.field_22742, this.field_22743, this.field_19085, this.field_19086, this.entryWidth, this.entryHeight, this.entrySpacing, profile)));
    }

    @Override
    public boolean keyPressed(class_3675.class_306 key) {
        return false;
    }

    @Override
    public boolean keyReleased(class_3675.class_306 key) {
        return false;
    }

    @Override
    public boolean mouseClicked(class_3675.class_306 key) {
        return false;
    }

    @Override
    public boolean mouseReleased(class_3675.class_306 key) {
        return false;
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class LengthLimit
        extends Entry {
            LengthLimit(int x, int width, int height) {
                TextField lengthField = new TextField(x, 0, width, height);
                lengthField.posIntValidator().strict();
                lengthField.method_1880(6);
                lengthField.method_1863(val -> {
                    try {
                        int space = Integer.parseInt(val.strip());
                        if (space < 1) {
                            throw new NumberFormatException();
                        }
                        Config.get().setLengthLimitLength(space);
                        lengthField.method_1868(0xFFFFFF);
                    }
                    catch (NumberFormatException ignored) {
                        lengthField.method_1868(0xFF0000);
                    }
                });
                lengthField.method_1852(String.valueOf(Config.get().getLengthLimitLength()));
                lengthField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.lengthlimit.length.tooltip", new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "main.lengthlimit.length.tooltip.warning", new Object[0]).method_27692(class_124.field_1061))));
                this.elements.add(lengthField);
            }
        }

        private static class Ratelimit
        extends Entry {
            Ratelimit(int x, int width, int height) {
                int buttonWidth = (width - 8) / 3;
                int fieldWidth = (buttonWidth - 4) / 2;
                int movingX = x;
                TextField countField = new TextField(movingX, 0, fieldWidth, height);
                countField.posIntValidator().strict();
                countField.method_1880(6);
                countField.method_1863(val -> Config.get().setRatelimitCount(Integer.parseInt(val.strip())));
                countField.method_1852(String.valueOf(Config.get().getRatelimitCount()));
                countField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.ratelimit.count.tooltip", new Object[0])));
                this.elements.add(countField);
                TextField ticksField = new TextField(movingX += fieldWidth + 4, 0, fieldWidth, height);
                ticksField.posIntValidator().strict();
                ticksField.method_1880(6);
                ticksField.method_1863(val -> {
                    try {
                        int space = Integer.parseInt(val.strip());
                        if (space < 1) {
                            throw new NumberFormatException();
                        }
                        Config.get().setRatelimitTicks(space);
                        ticksField.method_1868(0xFFFFFF);
                    }
                    catch (NumberFormatException ignored) {
                        ticksField.method_1868(0xFF0000);
                    }
                });
                ticksField.method_1852(String.valueOf(Config.get().getRatelimitTicks()));
                ticksField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.ratelimit.ticks.tooltip", new Object[0])));
                this.elements.add(ticksField);
                movingX = x + width - buttonWidth * 2 - 4;
                class_5676 strictButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32619((Object)Config.get().ratelimitStrict).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "main.ratelimit.strict.tooltip", new Object[0]))).method_32617(movingX, 0, buttonWidth, height, (class_2561)Localization.localized("option", "main.ratelimit.strict", new Object[0]), (button, status) -> {
                    Config.get().ratelimitStrict = status;
                });
                strictButton.method_47402(500);
                this.elements.add(strictButton);
                movingX = x + width - buttonWidth;
                class_5676 spButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32619((Object)Config.get().ratelimitSp).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "main.ratelimit.sp.tooltip", new Object[0]))).method_32617(movingX, 0, buttonWidth, height, (class_2561)Localization.localized("option", "main.ratelimit.sp", new Object[0]), (button, status) -> {
                    Config.get().ratelimitSp = status;
                });
                spButton.method_47402(500);
                this.elements.add(spButton);
            }
        }

        private static class DefaultOptions2
        extends Entry {
            DefaultOptions2(int x, int width, int height) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(class_5676.method_32606(Macro.ActivationType::title).method_32624((Object[])Macro.ActivationType.values()).method_32619((Object)Config.get().defaultActivationType).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.activation", new Object[0]), (button, status) -> {
                    Config.get().defaultActivationType = status;
                }));
            }
        }

        private static class DefaultOptions1
        extends Entry {
            DefaultOptions1(int x, int width, int height) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(class_5676.method_32606(Macro.ConflictStrategy::title).method_32624((Object[])Macro.ConflictStrategy.values()).method_32619((Object)Config.get().defaultConflictStrategy).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.conflict", new Object[0]), (button, status) -> {
                    Config.get().defaultConflictStrategy = status;
                }));
                this.elements.add(class_5676.method_32606(Macro.SendMode::title).method_32624((Object[])Macro.SendMode.values()).method_32619((Object)Config.get().defaultSendMode).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(x + width - buttonWidth, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.mode", new Object[0]), (button, status) -> {
                    Config.get().defaultSendMode = status;
                }));
            }
        }

        private static class ProfileLink
        extends Entry {
            ProfileLink(int x, int width, int height, MainOptionList list, Profile profile, String address) {
                int labelWidth = 50;
                int linkFieldWidth = width - labelWidth - list.smallWidgetWidth - 4;
                class_4185 label = class_4185.method_46430((class_2561)Localization.localized("option", "main.profiles.link", new Object[0]), button -> {}).method_46433(x, 0).method_46437(labelWidth, height).method_46431();
                label.field_22763 = false;
                this.elements.add(label);
                FakeTextField linkField = new FakeTextField(x + labelWidth, 0, linkFieldWidth, height, () -> {});
                linkField.method_1880(64);
                linkField.method_1852(address);
                linkField.field_22763 = false;
                this.elements.add(linkField);
                class_4185 removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c"), button -> {
                    profile.removeLink(address);
                    list.init();
                }).method_46433(x + width - list.smallWidgetWidth, 0).method_46437(list.smallWidgetWidth, height).method_46431();
                removeButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profile.link.remove.tooltip", new Object[0])));
                removeButton.method_47402(500);
                this.elements.add(removeButton);
            }
        }

        private static class ProfileName
        extends Entry {
            ProfileName(int x, int width, int height, Profile profile) {
                int labelWidth = 50;
                int nameBoxWidth = width - labelWidth - 4;
                class_4185 label = class_4185.method_46430((class_2561)Localization.localized("option", "main.profile.name", new Object[0]), button -> {}).method_46433(x, 0).method_46437(labelWidth, height).method_46431();
                label.field_22763 = false;
                this.elements.add(label);
                TextField nameBox = new TextField(x + labelWidth, 0, nameBoxWidth, height);
                nameBox.method_1880(64);
                nameBox.method_1863(value -> {
                    profile.name = value.strip();
                });
                nameBox.method_1852(profile.name);
                this.elements.add(nameBox);
            }
        }

        private static class ProfileOptions
        extends Entry {
            MainOptionList list;
            Profile profile;

            ProfileOptions(int x, int width, int height, MainOptionList list, Profile profile, int index, boolean inGame) {
                this.list = list;
                this.profile = profile;
                boolean spDefault = index == Config.get().getSpDefault();
                boolean mpDefault = index == Config.get().getMpDefault();
                int smallWidgetWidth = list.smallWidgetWidth;
                int mainButtonWidth = width - smallWidgetWidth * 5 - 20;
                int mainButtonX = x;
                if (inGame) {
                    if (index == 0) {
                        class_344 linkButton = new class_344(x, 0, smallWidgetWidth, height, 0, 0, 20, LINK_ICON, 32, 64, button -> {
                            profile.forceAddLink(CommandKeys.lastConnection);
                            list.init();
                        });
                        if (profile.getLinks().contains(CommandKeys.lastConnection)) {
                            linkButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.linked.tooltip", new Object[0])));
                            linkButton.field_22763 = false;
                        } else {
                            linkButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.link.tooltip", new Object[0])));
                        }
                        linkButton.method_47402(500);
                        this.elements.add(linkButton);
                    } else {
                        class_4185 activateButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> {
                            Config.get().activateProfile(index);
                            list.init();
                        }).method_46433(x, 0).method_46437(smallWidgetWidth, height).method_46431();
                        activateButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.activate.tooltip", new Object[0])));
                        activateButton.method_47402(500);
                        this.elements.add(activateButton);
                    }
                    mainButtonWidth -= smallWidgetWidth + 4;
                    mainButtonX += smallWidgetWidth + 4;
                }
                class_5250 name = class_2561.method_43470((String)profile.getDisplayName());
                int numLinks = profile.getLinks().size();
                if (numLinks != 0) {
                    name.method_27693(" ");
                    if (numLinks == 1) {
                        name.method_10852((class_2561)Localization.localized("option", "main.profiles.links.one", new Object[0]).method_27692(class_124.field_1080));
                    } else {
                        name.method_10852((class_2561)Localization.localized("option", "main.profiles.links.many", numLinks).method_27692(class_124.field_1080));
                    }
                }
                this.elements.add(class_4185.method_46430((class_2561)name, button -> list.openProfileOptions(profile)).method_46436(class_7919.method_47407((class_2561)Localization.localized("option", "main.profile.edit.tooltip", new Object[0]))).method_46433(mainButtonX, 0).method_46437(mainButtonWidth, height).method_46431());
                int movingX = x + width - smallWidgetWidth * 5 - 16;
                class_344 configureButton = new class_344(movingX, 0, smallWidgetWidth, height, 0, 0, 20, OPTIONS_ICON, 32, 64, button -> {
                    list.editingProfile = list.editingProfile == null ? profile : (!list.editingProfile.equals(profile) ? profile : null);
                    list.init();
                }, (class_2561)class_2561.method_43473());
                configureButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profile.details.tooltip", new Object[0])));
                configureButton.method_47402(500);
                this.elements.add(configureButton);
                class_4185 setAsSpDefaultButton = class_4185.method_46430((class_2561)Localization.localized("option", "main.profiles.default.singleplayer.set", new Object[0]), button -> {
                    Config.get().setSpDefault(index);
                    list.init();
                }).method_46433(movingX += smallWidgetWidth + 4, 0).method_46437(smallWidgetWidth, height).method_46431();
                if (spDefault) {
                    setAsSpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.default.singleplayer.tooltip", new Object[0])));
                    setAsSpDefaultButton.method_25355((class_2561)setAsSpDefaultButton.method_25369().method_27661().method_27692(class_124.field_1060));
                } else {
                    setAsSpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.default.singleplayer.set.tooltip", new Object[0])));
                }
                setAsSpDefaultButton.method_47402(500);
                setAsSpDefaultButton.field_22763 = !spDefault;
                this.elements.add(setAsSpDefaultButton);
                class_4185 setAsMpDefaultButton = class_4185.method_46430((class_2561)Localization.localized("option", "main.profiles.default.multiplayer.set", new Object[0]), button -> {
                    Config.get().setMpDefault(index);
                    list.init();
                }).method_46433(movingX += smallWidgetWidth + 4, 0).method_46437(smallWidgetWidth, height).method_46431();
                if (mpDefault) {
                    setAsMpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.default.multiplayer.tooltip", new Object[0])));
                    setAsMpDefaultButton.method_25355((class_2561)setAsMpDefaultButton.method_25369().method_27661().method_27692(class_124.field_1060));
                } else {
                    setAsMpDefaultButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.default.multiplayer.set.tooltip", new Object[0])));
                }
                setAsMpDefaultButton.method_47402(500);
                setAsMpDefaultButton.field_22763 = !mpDefault;
                this.elements.add(setAsMpDefaultButton);
                class_344 copyButton = new class_344(movingX += smallWidgetWidth + 4, 0, smallWidgetWidth, height, 0, 0, 20, COPY_ICON, 32, 64, button -> {
                    Config.get().addCopyProfile(profile);
                    list.init();
                }, (class_2561)class_2561.method_43473());
                copyButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.copy.tooltip", new Object[0])));
                copyButton.method_47402(500);
                this.elements.add(copyButton);
                class_4185 deleteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c"), button -> {
                    Config.get().removeProfile(index);
                    list.init();
                }).method_46433(movingX += smallWidgetWidth + 4, 0).method_46437(smallWidgetWidth, height).method_46431();
                if (spDefault || mpDefault) {
                    deleteButton.field_22763 = false;
                    deleteButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.delete.disabled.tooltip", new Object[0])));
                } else {
                    deleteButton.method_25355((class_2561)deleteButton.method_25369().method_27661().method_27692(class_124.field_1061));
                    deleteButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "main.profiles.delete.tooltip", new Object[0])));
                }
                deleteButton.method_47402(500);
                this.elements.add(deleteButton);
            }
        }
    }
}

