/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.widget.field.MultiLineTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class MacroOptionList
extends MacroBindList {
    private final Macro macro;
    private OptionList.Entry.ActionButton addMessageEntry;

    public MacroOptionList(class_310 mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Profile profile, Macro macro) {
        super(mc, width, height, y, entryWidth, entryHeight, entrySpacing, profile, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(Entry.MessageOptions.class, macro::moveMessage)));
        this.macro = macro;
        this.addMessageEntry = new OptionList.Entry.ActionButton(this.entryX, entryWidth, entryHeight, (class_2561)class_2561.method_43470((String)"+"), null, -1, button -> {
            macro.addMessage(new Message());
            this.init();
            this.method_73377((class_350.class_351)this.addMessageEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.method_25321((class_350.class_351)new Entry.DualKeybind(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, this.profile, this.macro));
        if (this.profile.getShowHudMessage().equals((Object)Profile.Control.DEFER) || this.profile.getAddToHistory().equals((Object)Profile.Control.DEFER) || this.profile.getResumeRepeating().equals((Object)Profile.Control.DEFER) || this.profile.getUseRatelimit().equals((Object)Profile.Control.DEFER)) {
            this.method_25321((class_350.class_351)new Entry.MacroControls(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this.profile, this.macro));
        }
        this.method_25321((class_350.class_351)new Entry.MacroMode1(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this, this.profile, this.macro));
        this.method_25321((class_350.class_351)new Entry.MacroMode2(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this.profile, this.macro));
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "macro.messages", new Object[0]), null, -1));
        this.refreshMessageSubList();
        this.addMessageEntry.setBounds(this.dynEntryX, this.dynEntryWidth, this.entryHeight);
        this.method_25321((class_350.class_351)this.addMessageEntry);
    }

    protected void refreshMessageSubList() {
        ArrayList<OptionList.Entry> entries = new ArrayList<OptionList.Entry>(this.method_25396());
        entries.removeIf(entry -> entry instanceof Entry.MessageOptions);
        int start = entries.indexOf((Object)this.addMessageEntry);
        start = start == -1 ? entries.size() : --start;
        List<Message> messages = this.macro.getMessages();
        for (int i = messages.size() - 1; i >= 0; --i) {
            Message message = messages.get(i);
            Entry.MessageOptions msgEntry = new Entry.MessageOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.macro, message, i);
            entries.add(start, new OptionList.Entry.Space(msgEntry));
            entries.add(start, msgEntry);
        }
        this.method_25314(entries);
        this.method_65506();
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class MessageOptions
        extends Entry {
            MessageOptions(int x, int width, int height, MacroOptionList list, Macro macro, Message msg, int index) {
                class_327 font = class_310.method_1551().field_1772;
                boolean showDelayField = macro.getStrategy() == Macro.ConflictStrategy.AVOID || macro.getMode() == Macro.SendMode.SEND && macro.spaceTicks == 0 || macro.getMode() == Macro.SendMode.REPEAT || macro.getMode() == Macro.SendMode.RANDOM || macro.getMode() == Macro.SendMode.CYCLE;
                int minDelayFieldWidth = font.method_1727("0__") + 8;
                int msgFieldWidth = width - (showDelayField ? minDelayFieldWidth + 4 : 0);
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191\u2193"), button -> {
                    this.method_25398(true);
                    list.startDragging(this, null, false);
                }).method_46433(x - list.smallWidgetWidth - 4, 0).method_46437(list.smallWidgetWidth, height).method_46431());
                MultiLineTextField messageField = new MultiLineTextField(x, 0, msgFieldWidth, height * 2);
                messageField.method_44402(512);
                messageField.method_44401(val -> {
                    msg.string = val.stripLeading();
                });
                messageField.method_44400(msg.string);
                this.elements.add(messageField);
                if (showDelayField) {
                    TextField delayField = new TextField(x + width - minDelayFieldWidth, 0, minDelayFieldWidth, height).posIntValidator().strict();
                    delayField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "macro.delay.individual.tooltip" + (index == 0 ? ".first" : ".subsequent"), new Object[0])));
                    delayField.method_47402(Duration.ofMillis(500L));
                    delayField.method_1880(8);
                    delayField.method_1863(val -> {
                        int newWidth = Math.max(minDelayFieldWidth, font.method_1727(val) + font.method_1727("__") + 8);
                        int deltaWidth = delayField.method_25368() - newWidth;
                        messageField.method_25358(messageField.method_25368() + deltaWidth);
                        delayField.method_46421(delayField.method_46426() + deltaWidth);
                        delayField.method_25358(delayField.method_25368() - deltaWidth);
                        try {
                            int delay = Integer.parseInt(val.strip());
                            if (delay < 0) {
                                throw new NumberFormatException();
                            }
                            msg.delayTicks = delay;
                            delayField.method_1868(-2039584);
                        }
                        catch (NumberFormatException ignored) {
                            delayField.method_1868(-43691);
                        }
                    });
                    delayField.method_1852(String.valueOf(msg.delayTicks));
                    delayField.method_1875(0);
                    delayField.method_1884(0);
                    this.elements.add(delayField);
                }
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061), button -> {
                    macro.removeMessage(index);
                    list.init();
                }).method_46433(x + width + 4, 0).method_46437(list.smallWidgetWidth, height).method_46431());
            }
        }

        private static class MacroMode2
        extends Entry {
            MacroMode2(int x, int width, int height, Profile profile, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(class_5676.method_32606(Macro.ActivationType::title, (Object)((Object)macro.getActivationType())).method_32624((Object[])Macro.ActivationType.values()).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.activation", new Object[0]), (button, status) -> profile.setActivationType(macro, (Macro.ActivationType)((Object)status))));
                if (macro.getMode().equals((Object)Macro.SendMode.REPEAT)) {
                    TextField delayField = new TextField(x + width - buttonWidth, 0, buttonWidth, height).posIntValidator().strict();
                    delayField.method_1880(8);
                    delayField.method_1863(val -> {
                        macro.maxRepeats = Integer.parseInt(val.strip());
                    });
                    delayField.method_1852(String.valueOf(macro.maxRepeats));
                    delayField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "macro.maxRepeats.tooltip", new Object[0])));
                    this.elements.add(delayField);
                }
            }
        }

        private static class MacroMode1
        extends Entry {
            private TextField delayField;

            MacroMode1(int x, int width, int height, MacroOptionList list, Profile profile, Macro macro) {
                class_327 font = class_310.method_1551().field_1772;
                int buttonWidth = (width - 4) / 2;
                int minDelayFieldWidth = font.method_1727("0_") + 8;
                int modeButtonWidth = switch (macro.getMode()) {
                    default -> throw new MatchException(null, null);
                    case Macro.SendMode.SEND, Macro.SendMode.REPEAT -> buttonWidth - minDelayFieldWidth;
                    case Macro.SendMode.TYPE, Macro.SendMode.RANDOM, Macro.SendMode.EDIT -> buttonWidth;
                    case Macro.SendMode.CYCLE -> buttonWidth - list.smallWidgetWidth;
                };
                this.elements.add(class_5676.method_32606(Macro.ConflictStrategy::title, (Object)((Object)macro.getStrategy())).method_32624((Object[])Macro.ConflictStrategy.values()).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.conflict", new Object[0]), (button, status) -> {
                    profile.setConflictStrategy(macro, (Macro.ConflictStrategy)((Object)status));
                    list.init();
                }));
                class_5676 modeButton = class_5676.method_32606(Macro.SendMode::title, (Object)((Object)macro.getMode())).method_32624((Object[])Macro.SendMode.values()).method_32618(status -> class_7919.method_47407((class_2561)status.tooltip())).method_32617(x + width - buttonWidth, 0, modeButtonWidth, height, (class_2561)Localization.localized("option", "macro.mode", new Object[0]), (button, status) -> {
                    profile.setSendMode(macro, (Macro.SendMode)((Object)status));
                    list.init();
                });
                this.elements.add(modeButton);
                if (macro.getMode().equals((Object)Macro.SendMode.CYCLE)) {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (int i = 0; i < macro.getMessages().size(); ++i) {
                        values.add(i);
                    }
                    if (values.isEmpty()) {
                        values.add(0);
                    }
                    if (macro.cycleIndex > (Integer)values.getLast()) {
                        macro.cycleIndex = 0;
                    }
                    this.elements.add(class_5676.method_32606(status -> class_2561.method_43470((String)status.toString()), (Object)macro.cycleIndex).method_32620(values).method_32616().method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.cycleIndex.tooltip", new Object[0]))).method_32617(x + width - list.smallWidgetWidth, 0, list.smallWidgetWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        macro.cycleIndex = status;
                    }));
                } else if (macro.getMode().equals((Object)Macro.SendMode.SEND) || macro.getMode().equals((Object)Macro.SendMode.REPEAT)) {
                    this.delayField = new TextField(x + width - minDelayFieldWidth, 0, minDelayFieldWidth, height).posIntValidator().strict();
                    this.delayField.method_1880(8);
                    this.delayField.method_1863(arg_0 -> this.lambda$new$7(minDelayFieldWidth, font, (class_4264)modeButton, macro, list, arg_0));
                    this.delayField.method_1852(String.valueOf(macro.spaceTicks));
                    this.delayField.method_1875(0);
                    this.delayField.method_1884(0);
                    this.delayField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "macro.delay.tooltip" + (macro.getMode().equals((Object)Macro.SendMode.REPEAT) ? ".repeat" : ""), new Object[0])));
                    this.elements.add(this.delayField);
                }
            }

            private /* synthetic */ void lambda$new$7(int minDelayFieldWidth, class_327 font, class_4264 modeButton, Macro macro, MacroOptionList list, String val) {
                int newWidth = Math.max(minDelayFieldWidth, font.method_1727(val) + font.method_1727("_") + 8);
                int deltaWidth = this.delayField.method_25368() - newWidth;
                modeButton.method_25358(modeButton.method_25368() + deltaWidth);
                this.delayField.method_46421(this.delayField.method_46426() + deltaWidth);
                this.delayField.method_25358(this.delayField.method_25368() - deltaWidth);
                int space = Integer.parseInt(val.strip());
                int oldSpace = macro.spaceTicks;
                macro.spaceTicks = space;
                if (macro.getMode() == Macro.SendMode.SEND && (space == 0 && oldSpace != 0 || space != 0 && oldSpace == 0)) {
                    list.refreshMessageSubList();
                }
            }
        }

        private static class MacroControls
        extends Entry {
            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            MacroControls(int x, int width, int height, Profile profile, Macro macro) {
                int buttonWidth = (width - 6) / 4;
                int movingX = x;
                boolean hudActive = profile.getShowHudMessage().equals((Object)Profile.Control.DEFER);
                @NotNull class_5676 hudButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061), (boolean)(hudActive ? macro.getShowHudMessage() : macro.getShowHudMessageStatus())).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.hud.tooltip", new Object[0]))).method_32617(movingX, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.hud", new Object[0]), (button, status) -> profile.setShowHudMessage(macro, (boolean)status));
                hudButton.method_47402(Duration.ofMillis(500L));
                hudButton.field_22763 = hudActive;
                this.elements.add(hudButton);
                boolean historyActive = profile.getAddToHistory().equals((Object)Profile.Control.DEFER);
                @NotNull class_5676 historyButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061), (boolean)(historyActive ? macro.getAddToHistory() : macro.getAddToHistoryStatus())).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.history.tooltip", new Object[0]))).method_32617(movingX += buttonWidth + 2, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.history", new Object[0]), (button, status) -> profile.setAddToHistory(macro, (boolean)status));
                historyButton.method_47402(Duration.ofMillis(500L));
                historyButton.field_22763 = historyActive;
                this.elements.add(historyButton);
                movingX = x + width - buttonWidth * 2 - 2;
                boolean resumeActive = profile.getResumeRepeating().equals((Object)Profile.Control.DEFER);
                @NotNull class_5676 resumeButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061), (boolean)(resumeActive ? macro.getResumeRepeating() : macro.getResumeRepeatingStatus())).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.resume.tooltip", new Object[0]))).method_32617(movingX, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.resume", new Object[0]), (button, status) -> profile.setResumeRepeating(macro, (boolean)status));
                resumeButton.method_47402(Duration.ofMillis(500L));
                resumeButton.field_22763 = resumeActive;
                this.elements.add(resumeButton);
                boolean ratelimitActive = profile.getUseRatelimit().equals((Object)Profile.Control.DEFER);
                @NotNull class_5676 ratelimitButton = class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061), (boolean)(ratelimitActive ? macro.getUseRatelimit() : macro.getUseRatelimitStatus())).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "macro.control.ratelimit.tooltip", new Object[0]))).method_32617(movingX += buttonWidth + 2, 0, buttonWidth, height, (class_2561)Localization.localized("option", "macro.control.ratelimit", new Object[0]), (button, status) -> profile.setUseRatelimit(macro, (boolean)status));
                ratelimitButton.method_47402(Duration.ofMillis(500L));
                ratelimitButton.field_22763 = ratelimitActive;
                this.elements.add(ratelimitButton);
            }
        }

        private static class DualKeybind
        extends Entry {
            DualKeybind(int x, int width, int height, MacroOptionList list, Profile profile, Macro macro) {
                int buttonWidth = (width - 4) / 2;
                KeybindUtil.KeybindInfo info = new KeybindUtil.KeybindInfo(profile, macro, macro.getKeybind());
                this.elements.add(class_4185.method_46430((class_2561)info.conflictLabel, button -> {
                    list.setSelected(macro, macro.getKeybind());
                    button.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)info.label.method_27692(class_124.field_1068).method_27692(class_124.field_1073)).method_27693(" <").method_27692(class_124.field_1054));
                }).method_46436(class_7919.method_47407((class_2561)info.tooltip)).method_46433(x, 0).method_46437(buttonWidth, height).method_46431());
                KeybindUtil.KeybindInfo altInfo = new KeybindUtil.KeybindInfo(profile, macro, macro.getAltKeybind());
                this.elements.add(class_4185.method_46430((class_2561)altInfo.conflictLabel, button -> {
                    list.setSelected(macro, macro.getAltKeybind());
                    button.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)altInfo.label.method_27692(class_124.field_1068).method_27692(class_124.field_1073)).method_27693(" <").method_27692(class_124.field_1054));
                }).method_46436(class_7919.method_47407((class_2561)(altInfo.tooltip.getString().isBlank() ? Localization.localized("option", "macro.bind.alt.tooltip", new Object[0]) : altInfo.tooltip))).method_46433(x + width - buttonWidth, 0).method_46437(buttonWidth, height).method_46431());
            }
        }
    }
}

