/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionList
extends class_4265<Entry> {
    protected OptionScreen screen;
    protected final class_310 mc;
    protected final int entryWidth;
    protected final int entryHeight;
    protected final int entrySpacing;
    protected int rowWidth;
    protected int dynWideEntryWidth;
    protected int dynEntryWidth;
    protected int entryX;
    protected int dynWideEntryX;
    protected int dynEntryX;
    protected int smallWidgetWidth;
    protected int tinyWidgetWidth;

    public OptionList(class_310 mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, width, height, y, entryHeight + entrySpacing);
        this.mc = mc;
        this.entryWidth = entryWidth;
        this.entryHeight = entryHeight;
        this.entrySpacing = entrySpacing;
        this.updateElementBounds();
    }

    protected void updateElementBounds() {
        this.dynWideEntryWidth = Math.max(this.entryWidth, (int)((float)this.field_22758 / 100.0f * 70.0f));
        this.dynEntryWidth = Math.max(this.entryWidth, (int)((float)this.field_22758 / 100.0f * 50.0f));
        this.entryX = this.field_22758 / 2 - this.entryWidth / 2;
        this.dynWideEntryX = this.field_22758 / 2 - this.dynWideEntryWidth / 2;
        this.dynEntryX = this.field_22758 / 2 - this.dynEntryWidth / 2;
        this.rowWidth = Math.max(this.entryWidth, this.dynWideEntryWidth) + 40 + 48;
        this.smallWidgetWidth = Math.max(16, this.entryHeight);
        this.tinyWidgetWidth = 16;
    }

    protected void init() {
        double scrollAmount = this.method_44387();
        this.method_25339();
        this.method_25395(null);
        this.addEntries();
        this.method_44382(scrollAmount);
    }

    public void setScreen(OptionScreen screen) {
        this.screen = screen;
    }

    public void addEntry(int index, Entry entry) {
        this.method_25396().add(index, entry);
    }

    public void addSpacedEntry(Entry entry) {
        super.method_25321((class_350.class_351)entry);
        super.method_25321((class_350.class_351)new Entry.Space(entry));
    }

    public void addSpacedEntry(int index, Entry entry) {
        this.addEntry(index, entry);
        this.addEntry(index + 1, new Entry.Space(entry));
    }

    protected abstract void addEntries();

    public void method_57714(int width, int height, int y) {
        super.method_57714(width, height, y);
        this.updateElementBounds();
        this.init();
    }

    public int method_25322() {
        return this.rowWidth;
    }

    protected int method_65507() {
        return this.field_22758 / 2 + this.rowWidth / 2;
    }

    public abstract boolean keyPressed(class_3675.class_306 var1);

    public abstract boolean keyReleased(class_3675.class_306 var1);

    public abstract boolean mouseClicked(class_3675.class_306 var1);

    public abstract boolean mouseReleased(class_3675.class_306 var1);

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        public static final int SPACE = 4;
        public static final int SPACE_SMALL = 2;
        public static final int SPACE_TINY = 1;
        public static final class_8666 COPY_SPRITES = new class_8666(class_2960.method_60655((String)"commandkeys", (String)"widget/copy_button"), class_2960.method_60655((String)"commandkeys", (String)"widget/copy_button_disabled"), class_2960.method_60655((String)"commandkeys", (String)"widget/copy_button_highlighted"));
        public static final class_8666 OPTION_SPRITES = new class_8666(class_2960.method_60655((String)"commandkeys", (String)"widget/options_button"), class_2960.method_60655((String)"commandkeys", (String)"widget/options_button_disabled"), class_2960.method_60655((String)"commandkeys", (String)"widget/options_button_highlighted"));
        public static final class_8666 LINK_SPRITES = new class_8666(class_2960.method_60655((String)"commandkeys", (String)"widget/link_button"), class_2960.method_60655((String)"commandkeys", (String)"widget/link_button_disabled"), class_2960.method_60655((String)"commandkeys", (String)"widget/link_button_highlighted"));
        public static final class_8666 SEND_SPRITES = new class_8666(class_2960.method_60655((String)"commandkeys", (String)"widget/send_button"), class_2960.method_60655((String)"commandkeys", (String)"widget/send_button_disabled"), class_2960.method_60655((String)"commandkeys", (String)"widget/send_button_highlighted"));
        public final List<class_339> elements = new ArrayList<class_339>();

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.elements;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.elements;
        }

        public void method_25343(@NotNull class_332 graphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.elements.forEach(button -> {
                button.method_46419(this.method_73382());
                button.method_25394(graphics, mouseX, mouseY, tickDelta);
            });
        }

        public static class Space
        extends Entry {
            private final Entry entry;

            public Space(Entry entry) {
                this.entry = entry;
            }

            public boolean method_25397() {
                return this.entry.method_25397();
            }

            public void method_25398(boolean dragging) {
                this.entry.method_25398(dragging);
            }

            public boolean method_25402(class_11909 event, boolean doubleClick) {
                return this.entry.method_25402(event, doubleClick);
            }

            public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
                return this.entry.method_25403(event, deltaX, deltaY);
            }

            public void method_25395(class_364 listener) {
                this.entry.method_25395(listener);
            }

            public class_364 method_25399() {
                return this.entry.method_25399();
            }

            public class_8016 method_48208(@NotNull class_8023 event, int i) {
                if (this.entry.method_25396().isEmpty()) {
                    return null;
                }
                class_8016 $$2 = this.entry.method_25396().get(Math.min(i, this.entry.method_25396().size() - 1)).method_48205(event);
                return class_8016.method_48192((class_4069)this.entry, (class_8016)$$2);
            }
        }

        public static class ActionButton
        extends Entry {
            private final class_4185 button;

            public ActionButton(int x, int width, int height, class_2561 message, @Nullable class_7919 tooltip, int tooltipDelay, class_4185.class_4241 onPress) {
                this.button = class_4185.method_46430((class_2561)message, (class_4185.class_4241)onPress).method_46433(x, 0).method_46437(width, height).method_46431();
                if (tooltip != null) {
                    this.button.method_47400(tooltip);
                }
                if (tooltipDelay >= 0) {
                    this.button.method_47402(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(this.button);
            }

            public void setBounds(int x, int width, int height) {
                this.button.method_48229(x, 0);
                this.button.method_55445(width, height);
            }
        }

        public static class Text
        extends Entry {
            public Text(int x, int width, int height, class_2561 message, @Nullable class_7919 tooltip, int tooltipDelay) {
                int widgetWidth = class_310.method_1551().field_1772.method_1727(message.getString());
                Object widget = widgetWidth <= width ? new class_7842(x + width / 2 - widgetWidth / 2, 0, widgetWidth, height, message, class_310.method_1551().field_1772) : new class_7940(x, 0, message, class_310.method_1551().field_1772).method_48984(width).method_48981(true);
                if (tooltip != null) {
                    widget.method_47400(tooltip);
                }
                if (tooltipDelay >= 0) {
                    widget.method_47402(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(widget);
            }
        }
    }
}

