/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.list;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.OptionScreen;
import dev.terminalmc.commandkeys.gui.widget.field.FakeTextField;
import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.gui.widget.list.MacroBindList;
import dev.terminalmc.commandkeys.gui.widget.list.MacroOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.MainOptionList;
import dev.terminalmc.commandkeys.gui.widget.list.OptionList;
import dev.terminalmc.commandkeys.util.KeybindUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ProfileOptionList
extends MacroBindList {
    private OptionList.Entry.ActionButton addMacroEntry;

    public ProfileOptionList(Minecraft mc, int width, int height, int y, int entryWidth, int entryHeight, int entrySpace, @NotNull Profile profile) {
        super(mc, width, height, y, entryWidth, entryHeight, entrySpace, profile, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(Entry.MacroOptions.class, profile::moveMacro)));
        this.addMacroEntry = new OptionList.Entry.ActionButton(this.dynWideEntryX, this.dynWideEntryWidth, entryHeight, (Component)Component.literal((String)"+"), null, -1, button -> {
            profile.addMacro(new Macro());
            this.init();
            this.ensureVisible((AbstractSelectionList.Entry)this.addMacroEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.addEntry((AbstractSelectionList.Entry)new Entry.ScreenSwitch(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.addEntry((AbstractSelectionList.Entry)new Entry.ProfileControls(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynEntryX, this.dynEntryWidth, this.entryHeight, (Component)Localization.localized("option", "profile.keys", "\u2139"), Tooltip.create((Component)Localization.localized("option", "profile.keys.tooltip", new Object[0])), 500));
        this.refreshMacroSubList();
        this.addMacroEntry.setBounds(this.dynEntryX, this.dynEntryWidth, this.entryHeight);
        this.addEntry((AbstractSelectionList.Entry)this.addMacroEntry);
    }

    protected void refreshMacroSubList() {
        this.children().removeIf(entry -> entry instanceof Entry.MacroOptions);
        int start = this.children().indexOf((Object)this.addMacroEntry);
        start = start == -1 ? this.children().size() : --start;
        List<Macro> macros = this.profile.getMacros();
        for (int i = macros.size() - 1; i >= 0; --i) {
            Macro macro = macros.get(i);
            List<Message> messages = macro.getMessages();
            if (messages.isEmpty()) {
                macro.addMessage(new Message());
            }
            this.children().add(start, new Entry.MacroOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.profile, macro));
        }
        this.clampScrollAmount();
    }

    public void openMainOptions() {
        this.mc.setScreen((Screen)new OptionScreen((Screen)this.screen, (Component)Localization.localized("option", "main", new Object[0]), new MainOptionList(this.mc, this.width, this.height, this.getY(), this.entryWidth, this.entryHeight, this.entrySpacing, null)));
    }

    public void openMacroOptions(Macro macro) {
        this.mc.setScreen((Screen)new OptionScreen((Screen)this.screen, (Component)Localization.localized("option", "macro", new Object[0]), new MacroOptionList(this.mc, this.width, this.height, this.getY(), this.entryWidth, this.entryHeight, this.entrySpacing, this.profile, macro)));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class MacroOptions
        extends Entry {
            MacroOptions(int x, int width, int height, ProfileOptionList list, Profile profile, Macro macro) {
                Font font = Minecraft.getInstance().font;
                List<Message> messages = macro.getMessages();
                boolean editableField = messages.size() == 1;
                int keyButtonWidth = Math.clamp((long)(font.width("> Right Control + W <") + 4), 90, 130);
                KeybindUtil.KeybindInfo keybindInfo = new KeybindUtil.KeybindInfo(profile, macro, macro.getKeybind());
                int nominalWidth = font.width("> " + keybindInfo.label.getString() + " <") + 4;
                if (nominalWidth > keyButtonWidth) {
                    keyButtonWidth = Math.clamp((long)nominalWidth, 90, 130);
                }
                int messageFieldWidth = width - keyButtonWidth - (list.smallWidgetWidth * 2 + 4);
                int modeButtonWidth = 0;
                if (messageFieldWidth > 280) {
                    modeButtonWidth = 40;
                    messageFieldWidth -= modeButtonWidth * 3 + 2;
                }
                int movingX = x;
                this.elements.add(Button.builder((Component)Component.literal((String)"\u2191\u2193"), button -> {
                    this.setDragging(true);
                    list.startDragging(this, null, false);
                }).pos(x - list.smallWidgetWidth - 4, 0).size(list.smallWidgetWidth, height).build());
                this.elements.add(Button.builder((Component)keybindInfo.conflictLabel, button -> {
                    list.setSelected(macro, macro.getKeybind());
                    button.setMessage((Component)Component.literal((String)"> ").append((Component)keybindInfo.label.withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.UNDERLINE)).append(" <").withStyle(ChatFormatting.YELLOW));
                }).tooltip(Tooltip.create((Component)keybindInfo.tooltip)).pos(movingX, 0).size(keyButtonWidth, height).build());
                ImageButton sendButton = new ImageButton(movingX += keyButtonWidth, 0, list.smallWidgetWidth, height, SEND_SPRITES, button -> {
                    list.screen.onClose();
                    Minecraft.getInstance().setScreen(null);
                    macro.trigger(null, false);
                });
                sendButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "profile.trigger.tooltip", new Object[0])));
                sendButton.setTooltipDelay(Duration.ofMillis(500L));
                sendButton.active = CommandKeys.inGame();
                this.elements.add(sendButton);
                TextField messageField = editableField ? new TextField(movingX, 0, messageFieldWidth, height) : new FakeTextField(movingX += list.smallWidgetWidth + 2, 0, messageFieldWidth, height, () -> list.openMacroOptions(macro));
                messageField.setMaxLength(512);
                if (editableField) {
                    messageField.setResponder(val -> macro.setMessage(0, val.stripLeading()));
                }
                messageField.setValue(editableField ? messages.getFirst().string : this.getEditButtonLabel(macro, messageFieldWidth - 10));
                this.elements.add(messageField);
                ImageButton editButton = new ImageButton(movingX += messageFieldWidth + 2, 0, list.smallWidgetWidth, height, OPTION_SPRITES, button -> {
                    list.openMacroOptions(macro);
                    list.init();
                });
                editButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "profile.key.edit", new Object[0])));
                editButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(editButton);
                movingX += list.smallWidgetWidth + 2;
                if (modeButtonWidth != 0) {
                    this.elements.add(CycleButton.builder(Macro.ConflictStrategy::title).displayOnlyValue().withValues((Object[])Macro.ConflictStrategy.values()).withInitialValue((Object)macro.getStrategy()).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(movingX, 0, modeButtonWidth, height, (Component)Component.empty(), (button, status) -> {
                        profile.setConflictStrategy(macro, (Macro.ConflictStrategy)((Object)status));
                        list.init();
                    }));
                    this.elements.add(CycleButton.builder(Macro.SendMode::title).displayOnlyValue().withValues((Object[])Macro.SendMode.values()).withInitialValue((Object)macro.getMode()).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(movingX += modeButtonWidth, 0, modeButtonWidth, height, (Component)Component.empty(), (button, status) -> {
                        profile.setSendMode(macro, (Macro.SendMode)((Object)status));
                        list.init();
                    }));
                    this.elements.add(CycleButton.builder(Macro.ActivationType::title).displayOnlyValue().withValues((Object[])Macro.ActivationType.values()).withInitialValue((Object)macro.getActivationType()).withTooltip(status -> Tooltip.create((Component)status.tooltip())).create(movingX += modeButtonWidth, 0, modeButtonWidth, height, (Component)Component.empty(), (button, status) -> {
                        profile.setActivationType(macro, (Macro.ActivationType)((Object)status));
                        list.init();
                    }));
                }
                this.elements.add(Button.builder((Component)Component.literal((String)"\u274c").withStyle(ChatFormatting.RED), button -> {
                    list.profile.removeMacro(macro);
                    list.init();
                }).pos(x + width + 4, 0).size(list.smallWidgetWidth, height).build());
            }

            private String getEditButtonLabel(Macro macro, int maxWidth) {
                Font font = Minecraft.getInstance().font;
                ArrayList<String> strings = new ArrayList<String>();
                for (Message msg : macro.getMessages()) {
                    strings.add(msg.string);
                }
                int excess = strings.size() - 1;
                String tag = String.format(" [+%d]", excess);
                String trimTag = String.format("... [+%d]", excess);
                String first = (String)strings.getFirst();
                if (first.isBlank()) {
                    return trimTag;
                }
                String label = first + tag;
                int i = first.length();
                while (font.width(label) > maxWidth) {
                    label = first.substring(0, i--) + trimTag;
                }
                return label;
            }
        }

        private static class ProfileControls
        extends Entry {
            ProfileControls(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 6) / 4;
                int movingX = x;
                CycleButton hudButton = CycleButton.builder(this::getLabel).withValues((Object[])Profile.Control.values()).withInitialValue((Object)list.profile.getShowHudMessage()).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.hud.tooltip", new Object[0]).append("\n").append((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).create(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.hud", new Object[0]), (button, status) -> list.profile.setShowHudMessage((Profile.Control)((Object)status)));
                hudButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(hudButton);
                CycleButton historyButton = CycleButton.builder(this::getLabel).withValues((Object[])Profile.Control.values()).withInitialValue((Object)list.profile.getAddToHistory()).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.history.tooltip", new Object[0]).append("\n").append((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).create(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.history", new Object[0]), (button, status) -> list.profile.setAddToHistory((Profile.Control)((Object)status)));
                historyButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(historyButton);
                movingX = x + width - buttonWidth * 2 - 2;
                CycleButton resumeButton = CycleButton.builder(this::getLabel).withValues((Object[])Profile.Control.values()).withInitialValue((Object)list.profile.getResumeRepeating()).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.resume.tooltip", new Object[0]).append("\n").append((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).create(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.resume", new Object[0]), (button, status) -> list.profile.setResumeRepeating((Profile.Control)((Object)status)));
                resumeButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(resumeButton);
                CycleButton ratelimitButton = CycleButton.builder(this::getLabel).withValues((Object[])Profile.Control.values()).withInitialValue((Object)list.profile.getUseRatelimit()).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "macro.control.ratelimit.tooltip", new Object[0]).append("\n").append((Component)Localization.localized("option", "profile.defer.tooltip", new Object[0])))).create(movingX += buttonWidth + 2, 0, buttonWidth, height, (Component)Localization.localized("option", "macro.control.ratelimit", new Object[0]), (button, status) -> list.profile.setUseRatelimit((Profile.Control)((Object)status)));
                ratelimitButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(ratelimitButton);
            }

            private Component getLabel(Profile.Control control) {
                return switch (control) {
                    default -> throw new MatchException(null, null);
                    case Profile.Control.ON -> CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN);
                    case Profile.Control.OFF -> CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED);
                    case Profile.Control.DEFER -> Localization.localized("option", "profile.control.defer", new Object[0]).withStyle(ChatFormatting.GOLD);
                };
            }
        }

        private static class ScreenSwitch
        extends Entry {
            ScreenSwitch(int x, int width, int height, ProfileOptionList list) {
                int buttonWidth = (width - 4) / 2;
                this.elements.add(Button.builder((Component)Localization.localized("option", "profile.switch", new Object[0]), button -> list.openMainOptions()).pos(x, 0).size(buttonWidth, height).build());
                this.elements.add(Button.builder((Component)Localization.localized("option", "profile.controls", new Object[0]), button -> list.openMinecraftControlsScreen()).pos(x + width - buttonWidth, 0).size(buttonWidth, height).build());
            }
        }
    }
}

