/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.gui.screen.EditScreen;
import dev.terminalmc.commandkeys.gui.screen.MainOptionScreen;
import dev.terminalmc.commandkeys.mixin.accessor.ChatScreenAccessor;
import dev.terminalmc.commandkeys.util.Localization;
import dev.terminalmc.commandkeys.util.ModLogger;
import dev.terminalmc.commandkeys.util.PlaceholderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class CommandKeys {
    public static final String MOD_ID = "commandkeys";
    public static final String MOD_NAME = "CommandKeys";
    public static final ModLogger LOG = new ModLogger("CommandKeys");
    public static final class_2561 PREFIX = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"CommandKeys").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"] ").method_27692(class_124.field_1063)).method_27692(class_124.field_1080);
    public static final class_304 CONFIG_KEY = new class_304(Localization.translationKey("key", "main.edit"), class_3675.class_307.field_1668, 75, Localization.translationKey("key", "main"));
    public static final List<class_304> KEYBINDS = List.of(CONFIG_KEY);
    public static boolean hasResetConfig = false;
    public static String lastConnection = "";
    @Nullable
    public static class_3675.class_306 ratelimitedKey = null;
    private static final List<TickCounter> rateLimiter = new ArrayList<TickCounter>();

    public static void init() {
        Config.getAndSave();
    }

    public static void afterClientTick(class_310 mc) {
        while (CONFIG_KEY.method_1436()) {
            mc.method_1507((class_437)new MainOptionScreen(mc.field_1755, true));
        }
        rateLimiter.removeIf(tc -> tc.tick() > Config.get().getRatelimitTicks());
        if (mc.field_1724 != null && mc.field_1687 != null && !mc.method_1493()) {
            Config.get().activeProfile().getMacros().forEach(Macro::tick);
        }
        if (hasResetConfig && mc.field_1755 instanceof class_442) {
            hasResetConfig = false;
            mc.method_1566().method_1999((class_368)new class_370(new class_370.class_9037(15000L), (class_2561)Localization.localized("toast", "reset.title", new Object[0]), (class_2561)Localization.localized("toast", "reset.message", class_2561.method_43470((String)"commandkeys.unreadable.json").method_27692(class_124.field_1065))));
        }
    }

    public static void onConfigSaved(Config config) {
    }

    public static Profile profile() {
        return Config.get().activeProfile();
    }

    public static class_437 getConfigScreen(class_437 lastScreen) {
        return new MainOptionScreen(lastScreen, CommandKeys.inGame());
    }

    public static boolean inGame() {
        class_746 player = class_310.method_1551().field_1724;
        return player != null && player.field_3944.method_48296().method_10758();
    }

    public static boolean inSingleplayer() {
        return class_310.method_1551().method_1576() != null;
    }

    public static boolean canTrigger(class_3675.class_306 key, boolean sendMessage) {
        if ((!CommandKeys.inSingleplayer() || Config.get().ratelimitSp) && rateLimiter.size() >= Config.get().getRatelimitCount()) {
            if (sendMessage && ratelimitedKey != key) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)PREFIX.method_27661().method_10852((class_2561)Localization.localized("message", "blocked.ratelimit", key.method_27445().method_27661().method_27692(class_124.field_1080), class_2561.method_43470((String)String.valueOf(Config.get().getRatelimitCount())).method_27692(class_124.field_1080), class_2561.method_43470((String)String.valueOf(Config.get().getRatelimitTicks())).method_27692(class_124.field_1080)).method_27692(class_124.field_1061)));
                ratelimitedKey = key;
            }
            if (Config.getAndSave().ratelimitStrict) {
                rateLimiter.add(new TickCounter());
            }
            return false;
        }
        rateLimiter.add(new TickCounter());
        return true;
    }

    public static void send(String message, boolean addToHistory, boolean showHudMsg) {
        CommandKeys.send(message, false, false, addToHistory, showHudMsg);
    }

    public static void type(String message) {
        CommandKeys.send(message, true, false, false, false);
    }

    public static void edit(String message) {
        CommandKeys.send(message, false, true, false, false);
    }

    public static void send(String message, boolean type, boolean edit, boolean addToHistory, boolean showHudMsg) {
        ratelimitedKey = null;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        if (!mc.field_1724.field_3944.method_48106()) {
            return;
        }
        Pair<String, Integer> result = PlaceholderUtil.replace(message);
        message = (String)result.getFirst();
        int faults = (Integer)result.getSecond();
        if (faults == 0) {
            if (edit) {
                String finalMessage = message;
                mc.method_1507((class_437)new EditScreen(str -> CommandKeys.send(type, finalMessage.replaceAll("%edit%", (String)str), addToHistory, showHudMsg)));
            } else {
                CommandKeys.send(type, message, addToHistory, showHudMsg);
            }
        } else {
            class_5250 msg = PREFIX.method_27661();
            msg.method_10852((class_2561)Localization.localized("message", "placeholderFault", class_2561.method_43470((String)message).method_27692(class_124.field_1080)).method_27692(class_124.field_1061));
            mc.field_1705.method_1743().method_1812((class_2561)msg);
        }
    }

    private static void send(boolean type, String message, boolean addToHistory, boolean showHudMsg) {
        class_310 mc = class_310.method_1551();
        if (type) {
            class_342 input;
            class_408 screen = new class_408(message);
            mc.method_1507((class_437)screen);
            int index = message.indexOf("%edit%");
            if (index != -1 && (input = ((ChatScreenAccessor)screen).commandkeys$getInput()) != null) {
                input.method_1883(index + "%edit%".length(), false);
                input.method_1883(index, true);
            }
        } else if (message.length() > Config.get().getLengthLimitLength()) {
            class_5250 msg = PREFIX.method_27661();
            msg.method_10852((class_2561)Localization.localized("message", "blocked.lengthlimit", class_2561.method_43470((String)String.valueOf(message.length())).method_27692(class_124.field_1080), class_2561.method_43470((String)String.valueOf(Config.get().getLengthLimitLength())).method_27692(class_124.field_1080)).method_27692(class_124.field_1061));
            mc.field_1705.method_1743().method_1812((class_2561)msg);
        } else {
            if (message.startsWith("/")) {
                mc.field_1724.field_3944.method_45730(message.substring(1));
            } else {
                mc.field_1724.field_3944.method_45729(message);
            }
            if (addToHistory) {
                mc.field_1705.method_1743().method_1803(message);
            }
            if (showHudMsg) {
                mc.field_1705.method_1758((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1080), false);
            }
        }
    }

    private static class TickCounter {
        int time = 0;

        private TickCounter() {
        }

        int tick() {
            return this.time++;
        }
    }
}

