/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.field;

import dev.terminalmc.commandkeys.gui.widget.field.TextField;
import dev.terminalmc.commandkeys.mixin.accessor.MultiLineEditBoxAccessor;
import dev.terminalmc.commandkeys.mixin.accessor.MultilineTextFieldAccessor;
import dev.terminalmc.commandkeys.mixin.accessor.StringViewAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_7529;
import net.minecraft.class_7530;
import net.minecraft.class_7533;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLineTextField
extends class_7529 {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = -2039584;
    public static final int TEXT_COLOR_ERROR = -43691;
    public final List<@NotNull TextField.Validator> validators = new ArrayList<TextField.Validator>();
    public boolean lenient = true;
    private int normalTextColor;
    private int currentTextColor = this.normalTextColor = -2039584;
    @Nullable
    private class_7919 normalTooltip;
    @Nullable
    private class_7919 errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private long lastClickTime;
    private int chainedClicks;

    public MultiLineTextField(int x, int y, int width, int height) {
        this(class_310.method_1551().field_1772, x, y, width, height, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), null);
    }

    public MultiLineTextField(int x, int y, int width, int height, class_2561 placeholder) {
        this(class_310.method_1551().field_1772, x, y, width, height, placeholder, (class_2561)class_2561.method_43473(), null);
    }

    public MultiLineTextField(class_327 font, int x, int y, int width, int height, class_2561 placeholder, class_2561 message, @Nullable TextField.Validator validator) {
        super(font, x, y, width, height, placeholder, message, -2039584, true, -3092272, true, true);
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public MultiLineTextField withValidator(@NotNull TextField.Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public void method_44401(@NotNull Consumer<String> responder) {
        super.method_44401(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (TextField.Validator v : this.validators) {
            Optional<class_2561> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = class_7919.method_47407((class_2561)error.get());
            super.method_47400(this.errorTooltip);
            this.currentTextColor = -43691;
            return false;
        }
        this.errorTooltip = null;
        this.currentTextColor = this.normalTextColor;
        super.method_47400(this.normalTooltip);
        return true;
    }

    public void method_47400(@Nullable class_7919 tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.method_47400(tooltip);
        }
    }

    public int getTextColor() {
        return this.currentTextColor;
    }

    public void setTextColor(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            this.currentTextColor = color;
        }
    }

    public void method_25358(int width) {
        super.method_25358(width);
        ((MultilineTextFieldAccessor)((MultiLineEditBoxAccessor)((Object)this)).commandkeys$getTextField()).commandkeys$setWidth(width);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            long time = class_156.method_658();
            if (this.lastClickTime + 250L > time) {
                class_7530 field = ((MultiLineEditBoxAccessor)((Object)this)).commandkeys$getTextField();
                MultilineTextFieldAccessor fieldAcc = (MultilineTextFieldAccessor)field;
                switch (++this.chainedClicks) {
                    case 1: {
                        field.method_44412(class_7533.field_39535, ((StringViewAccessor)field.method_44438()).commandkeys$getBeginIndex());
                        int pos = fieldAcc.commandkeys$getCursor();
                        field.method_44412(class_7533.field_39535, ((StringViewAccessor)field.method_44437()).commandkeys$getBeginIndex());
                        fieldAcc.commandkeys$setSelectCursor(pos);
                        break;
                    }
                    case 2: 
                    case 3: {
                        fieldAcc.commandkeys$setCursor(this.method_44405().length());
                        fieldAcc.commandkeys$setSelectCursor(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        fieldAcc.commandkeys$setSelectCursor(fieldAcc.commandkeys$getCursor());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            return true;
        }
        return false;
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                    this.history.removeLast();
                }
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!super.method_25404(keyCode, scanCode, modifiers)) {
            if (TextField.isUndo(keyCode)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(keyCode)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.method_44400(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.method_44400(this.history.get(++this.historyIndex));
        }
    }
}

