/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.gui.widget.field;

import dev.terminalmc.commandkeys.util.Localization;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextField
extends class_342 {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = 0xE0E0E0;
    public static final int TEXT_COLOR_ERROR = 0xFF5555;
    public static final int TEXT_COLOR_HINT = 0x555555;
    public static final int TEXT_COLOR_PREVIEW = 0xAAAAAA;
    private final class_327 font;
    public final List<@NotNull Validator> validators = new ArrayList<Validator>();
    public boolean lenient = true;
    private int normalTextColor = 0xE0E0E0;
    @Nullable
    private class_7919 normalTooltip;
    @Nullable
    private class_7919 errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private double dragOriginX;
    private int dragOriginPos;
    private long lastClickTime;
    private int chainedClicks;

    public TextField(int x, int y, int width, int height) {
        this(class_310.method_1551().field_1772, x, y, width, height, (class_2561)class_2561.method_43473(), null);
    }

    public TextField(int x, int y, int width, int height, @Nullable Validator validator) {
        this(class_310.method_1551().field_1772, x, y, width, height, (class_2561)class_2561.method_43473(), validator);
    }

    public TextField(class_327 font, int x, int y, int width, int height, class_2561 msg, @Nullable Validator validator) {
        super(font, x, y, width, height, msg);
        this.font = font;
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public TextField withValidator(@NotNull Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public TextField posIntValidator() {
        this.validators.add(new Validator.PosInt());
        return this;
    }

    public TextField strict() {
        this.lenient = false;
        return this;
    }

    public TextField lenient() {
        this.lenient = true;
        return this;
    }

    public void method_1863(@NotNull Consumer<String> responder) {
        super.method_1863(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (Validator v : this.validators) {
            Optional<class_2561> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = class_7919.method_47407((class_2561)error.get());
            super.method_47400(this.errorTooltip);
            super.method_1868(0xFF5555);
            return false;
        }
        this.errorTooltip = null;
        super.method_1868(this.normalTextColor);
        super.method_47400(this.normalTooltip);
        return true;
    }

    public void method_47404(@NotNull class_2561 hint) {
        super.method_47404((class_2561)hint.method_27661().method_54663(0x555555));
    }

    public void method_47400(@Nullable class_7919 tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.method_47400(tooltip);
        }
    }

    public void method_1868(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            super.method_1868(color);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            long time = class_156.method_658();
            if (this.lastClickTime + 250L > time) {
                switch (++this.chainedClicks) {
                    case 1: {
                        int pos;
                        int start = pos = this.method_1881();
                        if (pos < 0) {
                            start = 0;
                        } else if (pos >= this.method_1882().length() || this.method_1882().charAt(pos) == ' ' || pos > 0 && this.method_1882().charAt(pos - 1) != ' ') {
                            start = this.method_1853(-1);
                        }
                        int end = this.method_1853(1);
                        this.method_1883(start, false);
                        this.method_1883(end, true);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.method_1872(false);
                        this.method_1884(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        this.method_1884(this.method_1881());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            this.dragOriginX = mouseX;
            this.dragOriginPos = this.method_1881();
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return false;
        }
        String str = this.method_1882();
        if (mouseX < this.dragOriginX) {
            String subLeft = str.substring(0, this.dragOriginPos);
            int offsetChars = this.font.method_27524(subLeft, class_3532.method_15357((double)(this.dragOriginX - mouseX)), true).length();
            this.method_1883(this.dragOriginPos - offsetChars, true);
        } else {
            String subRight = str.substring(this.dragOriginPos);
            int offsetChars = this.font.method_27524(subRight, class_3532.method_15357((double)(mouseX - this.dragOriginX)), false).length();
            this.method_1883(this.dragOriginPos + offsetChars, true);
        }
        return true;
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                    this.history.removeLast();
                }
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!super.method_25404(keyCode, scanCode, modifiers)) {
            if (TextField.isUndo(keyCode)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(keyCode)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.method_1852(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.method_1852(this.history.get(++this.historyIndex));
        }
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 90 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    @FunctionalInterface
    public static interface Validator {
        public Optional<class_2561> validate(String var1);

        public static class PosInt
        implements Validator {
            @Override
            public Optional<class_2561> validate(String str) {
                try {
                    if (Integer.parseInt(str) < 0) {
                        throw new NumberFormatException();
                    }
                    return Optional.empty();
                }
                catch (NumberFormatException ignored) {
                    return Optional.of(Localization.localized("ui", "field.error.pos_int", new Object[0]).method_27692(class_124.field_1061));
                }
            }
        }
    }
}

