/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.api.biome;

import git.jbredwards.nether_api.api.audio.IMusicType;
import git.jbredwards.nether_api.api.audio.impl.VanillaMusicType;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IEndBiome {
    public void buildSurface(@Nonnull INetherAPIChunkGenerator var1, int var2, int var3, @Nonnull ChunkPrimer var4, int var5, int var6, double var7);

    default public void populate(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ) {
        chunkGenerator.populateWithVanilla(chunkX, chunkZ);
    }

    default public boolean generateIslands(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, float islandHeight) {
        return true;
    }

    default public boolean generateChorusPlants(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, float islandHeight) {
        return true;
    }

    default public boolean generateEndCity(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, int islandHeight) {
        return islandHeight >= 60;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean hasExtraXZFog(@Nonnull World world, int x, int z) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    default public Vec3d getFogColor(float celestialAngle, float partialTicks) {
        return new Vec3d(0.09411766, 0.07529412, 0.09411766);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    default public IMusicType getMusicType() {
        return new VanillaMusicType(MusicTicker.MusicType.END);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    default public IMusicType getBossMusicType() {
        return new VanillaMusicType(MusicTicker.MusicType.END_BOSS);
    }
}

