/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.api.registry;

import git.jbredwards.nether_api.api.structure.INetherAPIStructureEntry;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.common.BiomeManager;

public interface INetherAPIRegistry {
    @Nonnull
    public static final List<INetherAPIRegistry> REGISTRIES = new LinkedList<INetherAPIRegistry>();

    @Nonnull
    public ResourceLocation getRegistryName();

    public void clear();

    default public boolean isEmpty() {
        return this.getBiomeEntries().isEmpty() && this.getStructures().isEmpty();
    }

    @Nonnull
    public List<BiomeManager.BiomeEntry> getBiomeEntries();

    default public void registerBiome(@Nonnull BiomeManager.BiomeEntry biomeEntry) {
        this.registerBiome(biomeEntry.biome, biomeEntry.field_76292_a);
    }

    public void registerBiome(@Nonnull Biome var1, int var2);

    public boolean removeBiome(@Nonnull Biome var1);

    @Nonnull
    public List<INetherAPIStructureEntry> getStructures();

    public void registerStructure(@Nonnull INetherAPIStructureEntry var1);

    public void registerStructure(@Nonnull String var1, @Nonnull Function<INetherAPIChunkGenerator, MapGenStructure> var2);

    public boolean removeStructure(@Nonnull String var1);
}

