/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@FunctionalInterface
public interface ITransformer
extends IClassTransformer,
Opcodes {
    public static final boolean DEOBFUSCATED = FMLLaunchHandler.isDeobfuscatedEnvironment();

    default public int getLocalVar(@Nonnull MethodNode method, @Nonnull String name) {
        return method.localVariables == null ? -1 : method.localVariables.stream().filter(lv -> name.equals(lv.name)).mapToInt(lv -> lv.index).findFirst().orElse(-1);
    }

    @Nonnull
    default public byte[] transform(@Nonnull byte[] basicClass, @Nonnull Consumer<ClassNode> action) {
        return this.transform(basicClass, false, action);
    }

    @Nonnull
    default public byte[] transform(@Nonnull byte[] basicClass, boolean recalcFrames, @Nonnull Consumer<ClassNode> action) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, recalcFrames ? 4 : 0);
        action.accept(classNode);
        ClassWriter writer = new ClassWriter((recalcFrames ? 2 : 0) | 1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    @Nonnull
    default public byte[] transformMethod(@Nonnull byte[] basicClass, boolean recalcFrames, @Nonnull Predicate<MethodNode> condition, @Nonnull BiFunction<MethodNode, AbstractInsnNode, BreakType> action) {
        return this.transform(basicClass, recalcFrames, classNode -> this.transformMethod((ClassNode)classNode, condition, action));
    }

    @Nonnull
    default public byte[] transformMethod(@Nonnull byte[] basicClass, @Nonnull Predicate<MethodNode> condition, @Nonnull BiFunction<MethodNode, AbstractInsnNode, BreakType> action) {
        return this.transformMethod(basicClass, false, condition, action);
    }

    default public void transformMethod(@Nonnull ClassNode classNode, @Nonnull Predicate<MethodNode> condition, @Nonnull BiFunction<MethodNode, AbstractInsnNode, BreakType> action) {
        block4: for (MethodNode method : classNode.methods) {
            if (!condition.test(method)) continue;
            AbstractInsnNode[] abstractInsnNodeArray = method.instructions.toArray();
            int n = abstractInsnNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractInsnNode insn = abstractInsnNodeArray[n2];
                switch (action.apply(method, insn)) {
                    case METHODS: {
                        break block4;
                    }
                    case INSTRUCTIONS: {
                        continue block4;
                    }
                    default: {
                        ++n2;
                        break;
                    }
                }
            }
        }
    }

    @Nonnull
    default public String genHookClass() {
        return this.getClass().getName().replace('.', '/') + "$Hooks";
    }

    @Nonnull
    default public FieldInsnNode genHookField(@Nonnull String name, @Nonnull String desc) {
        return new FieldInsnNode(178, this.genHookClass(), name, desc);
    }

    @Nonnull
    default public MethodInsnNode genHookMethod(@Nonnull String name, @Nonnull String desc) {
        return new MethodInsnNode(184, this.genHookClass(), name, desc, false);
    }

    @Nonnull
    default public IntInsnNode genBlockFlags() {
        return new IntInsnNode(16, 18);
    }

    @Nonnull
    default public InsnList genHeightOffset(boolean add) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)this.genHeightMethod());
        list.add((AbstractInsnNode)new IntInsnNode(16, 8));
        list.add((AbstractInsnNode)new InsnNode(122));
        list.add((AbstractInsnNode)new IntInsnNode(16, 7));
        list.add((AbstractInsnNode)new InsnNode(120));
        if (add) {
            list.add((AbstractInsnNode)new InsnNode(96));
        }
        return list;
    }

    @Nonnull
    default public MethodInsnNode genHeightMethod() {
        return new MethodInsnNode(182, "net/minecraft/world/World", DEOBFUSCATED ? "getActualHeight" : "func_72940_L", "()I", false);
    }

    @Nonnull
    default public byte[] transformParent(@Nonnull byte[] basicClass, final @Nonnull String oldSuperName, final @Nonnull String newSuperName) {
        ClassReader reader = new ClassReader(basicClass);
        if (oldSuperName.equals(reader.getSuperName())) {
            ClassWriter writer = new ClassWriter(0);
            reader.accept(new ClassVisitor(327680, (ClassVisitor)writer){

                public void visit(int version, int access, @Nonnull String name, @Nonnull String signature, @Nonnull String superName, @Nonnull String[] interfaces) {
                    super.visit(version, access, name, signature, newSuperName, interfaces);
                }

                @Nonnull
                public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nonnull String signature, @Nonnull String[] exceptions) {
                    MethodVisitor old = super.visitMethod(access, name, desc, signature, exceptions);
                    return "<init>".equals(name) ? new MethodVisitor(this.api, old){

                        public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
                            super.visitMethodInsn(opcode, oldSuperName.equals(owner) ? newSuperName : owner, name, desc, itf);
                        }
                    } : old;
                }
            }, 0);
            return writer.toByteArray();
        }
        return basicClass;
    }

    default public void transformPlantable(@Nonnull ClassNode classNode, @Nonnull String plantType) {
        if (!classNode.interfaces.contains("net/minecraftforge/common/IPlantable")) {
            classNode.interfaces.add("net/minecraftforge/common/IPlantable");
            MethodNode plant = new MethodNode(1, "getPlant", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", null, null);
            MethodNode type = new MethodNode(1, "getPlantType", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraftforge/common/EnumPlantType;", null, null);
            classNode.methods.removeIf(method -> method.name.equals(plant.name) || method.name.equals(type.name));
            classNode.methods.add(plant);
            classNode.methods.add(type);
            GeneratorAdapter plantAdapter = new GeneratorAdapter((MethodVisitor)plant, plant.access, plant.name, plant.desc);
            plantAdapter.loadThis();
            plantAdapter.visitMethodInsn(182, classNode.name, DEOBFUSCATED ? "getDefaultState" : "func_176223_P", "()Lnet/minecraft/block/state/IBlockState;", false);
            plantAdapter.returnValue();
            GeneratorAdapter typeAdapter = new GeneratorAdapter((MethodVisitor)type, type.access, type.name, type.desc);
            typeAdapter.visitFieldInsn(178, "git/jbredwards/nether_api/api/util/PlantUtils", plantType, "Lnet/minecraftforge/common/EnumPlantType;");
            typeAdapter.returnValue();
        }
    }

    public static enum BreakType {
        CONTINUE,
        INSTRUCTIONS,
        METHODS;

    }
}

