/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded.natura;

import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBasePopulatorJson;
import com.google.common.collect.Sets;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class Transformer_NetherHeight_Natura
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        switch (transformedName) {
            case "com.progwml6.natura.world.worldgen.trees.nether.BloodwoodTreeGenerator": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("findCeiling"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 120) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHeightMethod());
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.progwml6.natura.world.worldgen.GlowshroomGenerator": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("generateNether"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("hasType")) {
                        method.instructions.remove(insn.getPrevious());
                        method.instructions.insertBefore(insn.getPrevious(), (AbstractInsnNode)this.genHookField("VALID_GLOWSHROOM_BIOMES", "Ljava/util/Set;"));
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("canGenerate", "(Ljava/util/Set;Lnet/minecraft/world/biome/Biome;)Z"));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 64) {
                        InsnList list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 4));
                        list.add(this.genHeightOffset(true));
                        method.instructions.insert(insn, list);
                    } else if (insn.getOpcode() == 17 && ((IntInsnNode)insn).operand == 128) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 4));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHeightMethod());
                        method.instructions.remove(insn);
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.progwml6.natura.world.worldgen.berry.nether.NetherBerryBushGenerator": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("generateBush"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "getY" : "func_177956_o")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("canBerryGenerate", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/World;)I"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.progwml6.natura.world.worldgen.NetherMinableGenerator": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("generateNether"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("hasType")) {
                        method.instructions.remove(insn.getPrevious());
                        method.instructions.insertBefore(insn.getPrevious(), (AbstractInsnNode)this.genHookField("VALID_MINABLE_BIOMES", "Ljava/util/Set;"));
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("canGenerate", "(Ljava/util/Set;Lnet/minecraft/world/biome/Biome;)Z"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.progwml6.natura.world.worldgen.NetherTreesGenerator": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("generateNether"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("hasType")) {
                        method.instructions.remove(insn.getPrevious());
                        method.instructions.insertBefore(insn.getPrevious(), (AbstractInsnNode)this.genHookField("VALID_TREE_BIOMES", "Ljava/util/Set;"));
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("canGenerate", "(Ljava/util/Set;Lnet/minecraft/world/biome/Biome;)Z"));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 72) {
                        InsnList list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 4));
                        list.add(this.genHeightOffset(true));
                        method.instructions.insert(insn, list);
                    } else if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 64) {
                        InsnList list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 4));
                        list.add(this.genHeightOffset(true));
                        method.instructions.insert(insn, list);
                    } else if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 80) {
                        InsnList list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 4));
                        list.add(this.genHeightOffset(true));
                        method.instructions.insert(insn, list);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.progwml6.natura.world.worldgen.VineGenerator": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("generateNether"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("hasType")) {
                        method.instructions.remove(insn.getPrevious());
                        method.instructions.insertBefore(insn.getPrevious(), (AbstractInsnNode)this.genHookField("VALID_VINE_BIOMES", "Ljava/util/Set;"));
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("canGenerate", "(Ljava/util/Set;Lnet/minecraft/world/biome/Biome;)Z"));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 108) {
                        InsnList list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 4));
                        list.add(this.genHeightOffset(true));
                        list.add((AbstractInsnNode)new InsnNode(8));
                        list.add((AbstractInsnNode)new InsnNode(96));
                        method.instructions.insert(insn, list);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "maxhyper.dynamictreesnatura.worldgen.BiomeDataBasePopulator": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("populate"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn instanceof MethodInsnNode && ((MethodInsnNode)insn).name.equals("populate")) {
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("populate", "(Lcom/ferreusveritas/dynamictrees/worldgen/BiomeDataBasePopulatorJson;Lcom/ferreusveritas/dynamictrees/worldgen/BiomeDataBase;)V"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
        }
        return basicClass;
    }

    public static final class Hooks {
        @Nonnull
        public static final Set<Biome> VALID_BERRY_BIOMES = Sets.newHashSet((Object[])new Biome[]{Biomes.field_76778_j});
        @Nonnull
        public static final Set<Biome> VALID_GLOWSHROOM_BIOMES = Sets.newHashSet((Object[])new Biome[]{Biomes.field_76778_j});
        @Nonnull
        public static final Set<Biome> VALID_MINABLE_BIOMES = Sets.newHashSet((Object[])new Biome[]{Biomes.field_76778_j});
        @Nonnull
        public static final Set<Biome> VALID_TREE_BIOMES = Sets.newHashSet((Object[])new Biome[]{Biomes.field_76778_j});
        @Nonnull
        public static final Set<Biome> VALID_VINE_BIOMES = Sets.newHashSet((Object[])new Biome[]{Biomes.field_76778_j});
        @Nonnull
        private static final Lock LOCK = new ReentrantLock();

        public static int canBerryGenerate(@Nonnull BlockPos pos, @Nonnull World world) {
            return pos.func_177956_o() >= 0 && Hooks.canGenerate(VALID_BERRY_BIOMES, world.func_180494_b(pos)) ? pos.func_177956_o() : -1;
        }

        public static boolean canGenerate(@Nonnull Set<Biome> validBiomes, @Nonnull Biome biome) {
            return validBiomes.isEmpty() || validBiomes.contains(biome);
        }

        public static void populate(@Nonnull BiomeDataBasePopulatorJson populator, @Nonnull BiomeDataBase data) {
            if (VALID_TREE_BIOMES.isEmpty()) {
                populator.populate(data);
                return;
            }
            LOCK.lock();
            HashSet blacklist = Sets.newHashSet((Iterable)BiomeDataBasePopulatorJson.blacklistedBiomes);
            BiomeDataBasePopulatorJson.blacklistedBiomes.addAll(Sets.difference((Set)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER), VALID_TREE_BIOMES));
            populator.populate(data);
            BiomeDataBasePopulatorJson.blacklistedBiomes = blacklist;
            LOCK.unlock();
        }
    }
}

